/*
 * Decompiled with CFR 0.152.
 */
package games.august.byteme.write;

import games.august.byteme.common.ByteOrder;
import games.august.byteme.common.Endian;
import games.august.byteme.common.Transformation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.DslMarker;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lgames/august/byteme/write/WriteByteArrayDsl;", "", "()V", "WriteByteArrayBuilder", "WriteByteArrayDslMarker", "core"})
public final class WriteByteArrayDsl {
    @NotNull
    public static final WriteByteArrayDsl INSTANCE = new WriteByteArrayDsl();

    private WriteByteArrayDsl() {
    }

    @WriteByteArrayDslMarker
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nJ\"\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\f2\b\b\u0002\u0010\u0017\u001a\u00020\u0018J,\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgames/august/byteme/write/WriteByteArrayDsl$WriteByteArrayBuilder;", "", "()V", "bytes", "", "", "applyTransformation", "", "value", "transformation", "Lgames/august/byteme/common/Transformation;", "build", "", "put1", "", "byte", "int", "put2", "endian", "Lgames/august/byteme/common/Endian;", "put3", "put4", "putBytes", "byteOrder", "Lgames/august/byteme/common/ByteOrder;", "putNumber", "numBytes", "core"})
    public static final class WriteByteArrayBuilder {
        @NotNull
        private final List<Byte> bytes = new ArrayList();

        @NotNull
        public final byte[] build() {
            return CollectionsKt.toByteArray((Collection)this.bytes);
        }

        public final void put1(byte by) {
            this.bytes.add(by);
        }

        public final void put1(int n, @NotNull Transformation transformation) {
            Intrinsics.checkNotNullParameter((Object)((Object)transformation), (String)"transformation");
            this.putNumber(n, 1, transformation, Endian.Little);
        }

        public static /* synthetic */ void put1$default(WriteByteArrayBuilder writeByteArrayBuilder, int n, Transformation transformation, int n2, Object object) {
            if ((n2 & 2) != 0) {
                transformation = Transformation.None;
            }
            writeByteArrayBuilder.put1(n, transformation);
        }

        public final void put2(int n, @NotNull Transformation transformation, @NotNull Endian endian) {
            Intrinsics.checkNotNullParameter((Object)((Object)transformation), (String)"transformation");
            Intrinsics.checkNotNullParameter((Object)((Object)endian), (String)"endian");
            this.putNumber(n, 2, transformation, endian);
        }

        public static /* synthetic */ void put2$default(WriteByteArrayBuilder writeByteArrayBuilder, int n, Transformation transformation, Endian endian, int n2, Object object) {
            if ((n2 & 2) != 0) {
                transformation = Transformation.None;
            }
            if ((n2 & 4) != 0) {
                endian = Endian.Little;
            }
            writeByteArrayBuilder.put2(n, transformation, endian);
        }

        public final void put3(int n, @NotNull Transformation transformation, @NotNull Endian endian) {
            Intrinsics.checkNotNullParameter((Object)((Object)transformation), (String)"transformation");
            Intrinsics.checkNotNullParameter((Object)((Object)endian), (String)"endian");
            this.putNumber(n, 3, transformation, endian);
        }

        public static /* synthetic */ void put3$default(WriteByteArrayBuilder writeByteArrayBuilder, int n, Transformation transformation, Endian endian, int n2, Object object) {
            if ((n2 & 2) != 0) {
                transformation = Transformation.None;
            }
            if ((n2 & 4) != 0) {
                endian = Endian.Little;
            }
            writeByteArrayBuilder.put3(n, transformation, endian);
        }

        public final void put4(int n, @NotNull Transformation transformation, @NotNull Endian endian) {
            Intrinsics.checkNotNullParameter((Object)((Object)transformation), (String)"transformation");
            Intrinsics.checkNotNullParameter((Object)((Object)endian), (String)"endian");
            this.putNumber(n, 4, transformation, endian);
        }

        public static /* synthetic */ void put4$default(WriteByteArrayBuilder writeByteArrayBuilder, int n, Transformation transformation, Endian endian, int n2, Object object) {
            if ((n2 & 2) != 0) {
                transformation = Transformation.None;
            }
            if ((n2 & 4) != 0) {
                endian = Endian.Little;
            }
            writeByteArrayBuilder.put4(n, transformation, endian);
        }

        public final void putBytes(@NotNull byte[] bytes, @NotNull ByteOrder byteOrder) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Intrinsics.checkNotNullParameter((Object)((Object)byteOrder), (String)"byteOrder");
            this.bytes.addAll(switch (WhenMappings.$EnumSwitchMapping$0[byteOrder.ordinal()]) {
                case 1 -> ArraysKt.toList((byte[])bytes);
                case 2 -> ArraysKt.reversed((byte[])bytes);
                default -> throw new NoWhenBranchMatchedException();
            });
        }

        public static /* synthetic */ void putBytes$default(WriteByteArrayBuilder writeByteArrayBuilder, byte[] byArray, ByteOrder byteOrder, int n, Object object) {
            if ((n & 2) != 0) {
                byteOrder = ByteOrder.None;
            }
            writeByteArrayBuilder.putBytes(byArray, byteOrder);
        }

        private final void putNumber(int value, int numBytes, Transformation transformation, Endian endian) {
            int transformedValue = this.applyTransformation(value, transformation);
            List byteList = new ArrayList();
            for (int shift = numBytes - 1; -1 < shift; --shift) {
                byteList.add((byte)(transformedValue >> 8 * shift));
            }
            switch (WhenMappings.$EnumSwitchMapping$1[endian.ordinal()]) {
                case 1: {
                    this.bytes.addAll(byteList);
                    break;
                }
                case 2: {
                    this.bytes.addAll(CollectionsKt.asReversedMutable((List)byteList));
                    break;
                }
                case 3: {
                    if (numBytes < 3 || numBytes > 4) {
                        throw new IllegalStateException("Middle order requires between 3 and 4 bytes".toString());
                    }
                    if (numBytes == 3) {
                        this.bytes.add((Byte)byteList.get(0));
                        this.bytes.add((Byte)byteList.get(2));
                        this.bytes.add((Byte)byteList.get(1));
                        break;
                    }
                    this.bytes.add((Byte)byteList.get(2));
                    this.bytes.add((Byte)byteList.get(3));
                    this.bytes.add((Byte)byteList.get(0));
                    this.bytes.add((Byte)byteList.get(1));
                    break;
                }
                case 4: {
                    if (numBytes < 3 || numBytes > 4) {
                        throw new IllegalStateException("InverseMiddle order requires between 3 and 4 bytes".toString());
                    }
                    if (numBytes == 3) {
                        this.bytes.add((Byte)byteList.get(2));
                        this.bytes.add((Byte)byteList.get(0));
                        this.bytes.add((Byte)byteList.get(1));
                        break;
                    }
                    this.bytes.add((Byte)byteList.get(1));
                    this.bytes.add((Byte)byteList.get(0));
                    this.bytes.add((Byte)byteList.get(3));
                    this.bytes.add((Byte)byteList.get(2));
                }
            }
        }

        static /* synthetic */ void putNumber$default(WriteByteArrayBuilder writeByteArrayBuilder, int n, int n2, Transformation transformation, Endian endian, int n3, Object object) {
            if ((n3 & 4) != 0) {
                transformation = Transformation.None;
            }
            if ((n3 & 8) != 0) {
                endian = Endian.Little;
            }
            writeByteArrayBuilder.putNumber(n, n2, transformation, endian);
        }

        private final int applyTransformation(int value, Transformation transformation) {
            return switch (WhenMappings.$EnumSwitchMapping$2[transformation.ordinal()]) {
                case 1 -> value;
                case 2 -> value + 128;
                case 3 -> -value;
                case 4 -> 128 - value;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;

            static {
                int[] nArray = new int[ByteOrder.values().length];
                try {
                    nArray[ByteOrder.None.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ByteOrder.Reversed.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[Endian.values().length];
                try {
                    nArray[Endian.Big.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Endian.Little.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Endian.Middle.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Endian.InverseMiddle.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[Transformation.values().length];
                try {
                    nArray[Transformation.None.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Transformation.Add.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Transformation.Negate.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Transformation.Subtract.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lgames/august/byteme/write/WriteByteArrayDsl$WriteByteArrayDslMarker;", "", "core"})
    @DslMarker
    public static @interface WriteByteArrayDslMarker {
    }
}

