/*
 * Decompiled with CFR 0.152.
 */
package games.mythical.proto_util;

import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.ProtocolMessageEnum;
import games.mythical.proto_util.dto.DtoConvert;
import games.mythical.proto_util.dto.DtoExclude;
import games.mythical.proto_util.dto.DtoJson;
import games.mythical.proto_util.helper.JsonHelper;
import games.mythical.proto_util.helper.StringHelper;
import games.mythical.proto_util.proto.ProtoConvert;
import games.mythical.proto_util.proto.ProtoExclude;
import games.mythical.proto_util.proto.ProtoField;
import games.mythical.proto_util.proto.ProtoJson;
import games.mythical.proto_util.transform.BigDecimal2String;
import games.mythical.proto_util.transform.ProtoTimestamp2Long;
import games.mythical.proto_util.transform.SqlTimestamp2ProtoTimestamp;
import games.mythical.proto_util.transform.String2BigDecimal;
import games.mythical.proto_util.transform.String2ProtoTimestamp;
import games.mythical.proto_util.transform.String2Uuid;
import games.mythical.proto_util.transform.Transformer;
import games.mythical.proto_util.transform.Uuid2String;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoUtil {
    private static final Logger log = LoggerFactory.getLogger(ProtoUtil.class);
    private static final String PROTO_BUILDER_NAME = "newBuilder";
    private static final String LOMBOK_BUILDER_NAME = "builder";
    private static final String BUILD_METHOD_NAME = "build";
    private static final List<Transformer> transformers = new LinkedList<String2BigDecimal>(List.of(new String2ProtoTimestamp(), new SqlTimestamp2ProtoTimestamp(), new ProtoTimestamp2Long(), new String2Uuid(), new BigDecimal2String(), new Uuid2String(), new String2BigDecimal()));

    public static void setTransformers(Transformer ... newTransformers) {
        transformers.clear();
        ProtoUtil.addTransformers(newTransformers);
    }

    public static void addTransformers(Transformer ... newTransformers) {
        transformers.addAll(List.of(newTransformers));
    }

    public static List<Transformer> getTransformers() {
        return Collections.unmodifiableList(transformers);
    }

    public static <P, T> T toDtoBuilder(P source, Class<T> dtoBuilderClass) {
        return (T)ProtoUtil.convertToBuilder(source, ProtoUtil.getBuiltClassFromBuilder(dtoBuilderClass), false);
    }

    public static <P, T> T toDtoBean(P source, Class<T> resultClass) {
        return ProtoUtil.convertBean(source, resultClass);
    }

    public static <P, T> T toDto(P source, Class<T> resultClass) {
        return ProtoUtil.convert(source, resultClass, false);
    }

    public static <S, P extends MessageOrBuilder> P toProtoBuilder(S source, Class<P> protoBuilderClass) {
        return (P)((MessageOrBuilder)ProtoUtil.convertToBuilder(source, ProtoUtil.getBuiltClassFromBuilder(protoBuilderClass), true));
    }

    public static <S, P extends MessageOrBuilder> P toProto(S source, Class<P> protoClass) {
        return (P)((MessageOrBuilder)ProtoUtil.convert(source, protoClass, true));
    }

    private static Object processValue(Object sourceValue, Field field, Field targetField, boolean toProto) {
        if (field.getAnnotation(ProtoJson.class) != null) {
            return JsonHelper.toJsonString(sourceValue);
        }
        if (field.getAnnotation(ProtoConvert.class) != null) {
            Class<? extends MessageOrBuilder> protoClass = field.getAnnotation(ProtoConvert.class).value();
            return ProtoUtil.toProto(sourceValue, protoClass);
        }
        if (targetField.getAnnotation(DtoConvert.class) != null) {
            Class<?> dtoClass = targetField.getAnnotation(DtoConvert.class).value();
            return ProtoUtil.toDto(sourceValue, dtoClass);
        }
        if (targetField.getAnnotation(DtoJson.class) != null && sourceValue instanceof String) {
            if (StringUtils.isNotBlank((CharSequence)((String)sourceValue))) {
                return JsonHelper.toStringObjectMap((String)sourceValue);
            }
            return Collections.emptyMap();
        }
        Class<?> targetClass = targetField.getType();
        if (sourceValue.getClass() == targetClass || sourceValue instanceof ProtocolMessageEnum && targetClass == Integer.TYPE) {
            return sourceValue;
        }
        if (sourceValue.getClass().isEnum()) {
            return ((Enum)sourceValue).name();
        }
        for (Transformer transformer : transformers) {
            if (!transformer.condition(sourceValue, targetClass, toProto)) continue;
            return transformer.transform(sourceValue, targetClass, toProto);
        }
        if (targetClass == String.class) {
            return sourceValue.toString();
        }
        return sourceValue;
    }

    private static Class<?> getBuiltClassFromBuilder(Class<?> builderClass) {
        try {
            Method buildMethod = builderClass.getDeclaredMethod(BUILD_METHOD_NAME, new Class[0]);
            return buildMethod.getReturnType();
        }
        catch (NoSuchMethodException ex) {
            log.error("Unable to determine class being built during conversion", (Throwable)ex);
            throw new RuntimeException("Unable to determine class being built during conversion", ex);
        }
    }

    private static <T, R> Object convertToBuilder(T source, Class<R> resultClass, boolean toProto) {
        try {
            PropertyDescriptor[] srcProps;
            Object builder = ProtoUtil.createBuilder(resultClass, toProto);
            for (PropertyDescriptor prop : srcProps = Introspector.getBeanInfo(source.getClass(), Object.class).getPropertyDescriptors()) {
                try {
                    ProtoUtil.processProp(source, prop, builder, resultClass, false, toProto);
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                    String msg = String.format("Unable to convert property %s to proto for %s", prop.getName(), resultClass.getSimpleName());
                    log.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            return builder;
        }
        catch (IntrospectionException | IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            String msg = String.format("Unable to convert %s to %s", source.getClass().getSimpleName(), resultClass.getSimpleName());
            log.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    private static <T, R> R convertBean(T source, Class<R> resultClass) {
        try {
            PropertyDescriptor[] srcProps;
            R target = ProtoUtil.createNoArgsObject(resultClass);
            for (PropertyDescriptor prop : srcProps = Introspector.getBeanInfo(source.getClass(), Object.class).getPropertyDescriptors()) {
                try {
                    ProtoUtil.processProp(source, prop, target, resultClass, true, false);
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                    String msg = String.format("Unable to convert property %s to proto for %s", prop.getName(), resultClass.getSimpleName());
                    log.error(msg, (Throwable)ex);
                    throw new RuntimeException(msg, ex);
                }
            }
            return target;
        }
        catch (IntrospectionException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            String msg = String.format("Unable to convert %s to %s", source.getClass().getSimpleName(), resultClass.getSimpleName());
            log.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    private static <T, R> R convert(T source, Class<R> resultClass, boolean toProto) {
        Object builder = ProtoUtil.convertToBuilder(source, resultClass, toProto);
        try {
            Method buildMethod = builder.getClass().getMethod(BUILD_METHOD_NAME, new Class[0]);
            return (R)buildMethod.invoke(builder, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            String msg = String.format("Unable to convert %s to %s", source.getClass().getSimpleName(), resultClass.getSimpleName());
            log.error(msg, (Throwable)ex);
            throw new RuntimeException(msg, ex);
        }
    }

    private static <R> Object createBuilder(Class<R> resultClass, boolean toProto) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method builderCreator = resultClass.getMethod(toProto ? PROTO_BUILDER_NAME : LOMBOK_BUILDER_NAME, new Class[0]);
        return builderCreator.invoke(null, new Object[0]);
    }

    private static <R> R createNoArgsObject(Class<R> resultClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<R> constructor = resultClass.getConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    private static Optional<Field> getTargetField(Field srcField, Class<?> targetClass, boolean isProto) {
        if (isProto) {
            return ProtoUtil.getTargetFieldInProto(srcField, targetClass);
        }
        return ProtoUtil.getTargetFieldInDto(srcField, targetClass);
    }

    private static Optional<Field> getTargetFieldInDto(Field srcField, Class<?> targetClass) {
        Field[] fields;
        String name = ProtoUtil.stripUnderscore(srcField.getName());
        for (Field field : fields = targetClass.getDeclaredFields()) {
            String annotationValue;
            ProtoField anno = field.getAnnotation(ProtoField.class);
            if (anno == null || !name.equals(annotationValue = anno.value())) continue;
            return Optional.of(field);
        }
        return ProtoUtil.getFirstField(targetClass, name);
    }

    private static Optional<Field> getTargetFieldInProto(Field srcField, Class<?> targetClass) {
        String fieldName;
        if (srcField.getAnnotation(ProtoField.class) == null) {
            fieldName = srcField.getName();
        } else {
            String annotationValue = srcField.getAnnotation(ProtoField.class).value();
            fieldName = StringHelper.snakeToCamel(annotationValue);
        }
        return ProtoUtil.getFirstField(targetClass, StringUtils.uncapitalize((String)fieldName) + "_");
    }

    private static Optional<Field> getField(Object source, String name) {
        return ProtoUtil.getFirstField(source.getClass(), name, name + "_", StringUtils.capitalize((String)name), StringUtils.capitalize((String)name) + "_", StringUtils.uncapitalize((String)name), StringUtils.uncapitalize((String)name) + "_", "is" + StringUtils.capitalize((String)name), "is" + StringUtils.capitalize((String)name) + "_");
    }

    private static Optional<Field> getFirstField(Class<?> sourceClass, String ... names) {
        if (names != null && names.length > 0) {
            for (String name : names) {
                try {
                    return Optional.of(sourceClass.getDeclaredField(name));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
        }
        return Optional.empty();
    }

    private static Class<?> getType(Class<?> type) {
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (List.class.isAssignableFrom(type)) {
            return List.class;
        }
        if (Map.class.isAssignableFrom(type)) {
            return Map.class;
        }
        if (Set.class.isAssignableFrom(type)) {
            return Set.class;
        }
        return type;
    }

    private static Method getReadMethod(PropertyDescriptor prop, Object source) throws NoSuchMethodException {
        Method method = prop.getReadMethod();
        if (method != null) {
            return method;
        }
        return source.getClass().getDeclaredMethod("get" + StringUtils.capitalize((String)prop.getName()) + "List", new Class[0]);
    }

    private static void processProp(Object source, PropertyDescriptor prop, Object builder, Class<?> resultClass, boolean toBean, boolean toProto) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, NoSuchFieldException {
        Optional<Field> fieldOpt = ProtoUtil.getField(source, prop.getName());
        if (fieldOpt.isPresent()) {
            Field field = fieldOpt.get();
            Object value = ProtoUtil.getReadMethod(prop, source).invoke(source, new Object[0]);
            Optional<Field> targetFieldOpt = ProtoUtil.getTargetField(field, resultClass, toProto);
            if (targetFieldOpt.isPresent() && field.getAnnotation(ProtoExclude.class) == null && ProtoUtil.isNotExcludedInDto(targetFieldOpt.get(), toProto) && value != null) {
                ArrayList<Object> convertedValue;
                boolean repeating;
                Field targetField = targetFieldOpt.get();
                if (value instanceof Collection) {
                    repeating = true;
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (Object item : (Collection)value) {
                        Object converted = ProtoUtil.processValue(item, field, targetField, toProto);
                        if (converted == null) continue;
                        list.add(converted);
                    }
                    convertedValue = list;
                } else {
                    repeating = false;
                    convertedValue = ProtoUtil.processValue(value, field, targetField, toProto);
                }
                if (convertedValue != null) {
                    Method setterMethod = ProtoUtil.getSetterMethod(builder, ProtoUtil.stripUnderscore(targetField.getName()), convertedValue.getClass(), repeating, toBean, toProto);
                    setterMethod.invoke(builder, convertedValue);
                }
            }
        }
    }

    private static String stripUnderscore(String name) {
        return name.endsWith("_") ? name.substring(0, name.length() - 1) : name;
    }

    private static boolean isNotExcludedInDto(Field targetField, boolean toProto) {
        return toProto || targetField.getAnnotation(DtoExclude.class) == null;
    }

    private static Method getSetterMethod(Object target, String name, Class<?> type, boolean repeating, boolean toBean, boolean toProto) throws NoSuchMethodException {
        Class<Object> argType;
        Object methodName;
        if (toProto) {
            String prefix = repeating ? "addAll" : "set";
            methodName = prefix + StringUtils.capitalize((String)name);
            argType = repeating ? Iterable.class : ProtoUtil.getType(type);
        } else if (toBean) {
            methodName = "set" + StringUtils.capitalize((String)name);
            argType = ProtoUtil.getType(type);
        } else {
            methodName = name;
            argType = ProtoUtil.getType(type);
        }
        return target.getClass().getDeclaredMethod((String)methodName, argType);
    }
}

