/*
 * Decompiled with CFR 0.152.
 */
package garden.ephemeral.gradle.plugins.dsstore;

import garden.ephemeral.gradle.plugins.dsstore.ItemConfig;
import garden.ephemeral.gradle.plugins.dsstore.RootItemConfig;
import garden.ephemeral.macfiles.common.types.FourCC;
import garden.ephemeral.macfiles.dsstore.DSStore;
import garden.ephemeral.macfiles.dsstore.DSStoreProperties;
import garden.ephemeral.macfiles.dsstore.types.BrowserWindowSettings;
import garden.ephemeral.macfiles.dsstore.types.DoublePoint;
import garden.ephemeral.macfiles.dsstore.types.DoubleRgbColor;
import garden.ephemeral.macfiles.dsstore.types.IconViewOptions;
import garden.ephemeral.macfiles.dsstore.types.IntPoint;
import garden.ephemeral.macfiles.dsstore.util.FileMode;
import garden.ephemeral.macfiles.native.NativeAliasKt;
import garden.ephemeral.macfiles.native.NativeBookmarkKt;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lgarden/ephemeral/gradle/plugins/dsstore/DSStoreGenerator;", "", "()V", "generate", "", "outputFile", "Ljava/nio/file/Path;", "rootItemConfig", "Lgarden/ephemeral/gradle/plugins/dsstore/RootItemConfig;", "itemConfigByName", "", "", "Lgarden/ephemeral/gradle/plugins/dsstore/ItemConfig;", "makeBrowserWindowSettings", "Lgarden/ephemeral/macfiles/dsstore/types/BrowserWindowSettings;", "makeIconViewOptions", "Lgarden/ephemeral/macfiles/dsstore/types/IconViewOptions;", "backgroundImagePath", "Ljava/io/File;", "dsstore-gradle-plugin"})
public final class DSStoreGenerator {
    @NotNull
    public static final DSStoreGenerator INSTANCE = new DSStoreGenerator();

    private DSStoreGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generate(@NotNull Path outputFile, @NotNull RootItemConfig rootItemConfig, @NotNull Map<String, ItemConfig> itemConfigByName) {
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        Intrinsics.checkNotNullParameter((Object)rootItemConfig, (String)"rootItemConfig");
        Intrinsics.checkNotNullParameter(itemConfigByName, (String)"itemConfigByName");
        Closeable closeable = (Closeable)DSStore.Companion.open(outputFile, FileMode.READ_WRITE);
        Throwable throwable = null;
        try {
            DSStore store = (DSStore)closeable;
            boolean bl = false;
            store.set(".", DSStoreProperties.Companion.getUnknownDirectoryTag(), (Object)1L);
            store.set(".", DSStoreProperties.Companion.getViewStyle2(), (Object)new FourCC("icnv"));
            File backgroundImagePath = (File)rootItemConfig.getBackgroundImage().getAsFile().getOrNull();
            if (backgroundImagePath != null) {
                store.set(".", DSStoreProperties.Companion.getBackgroundBookmark(), (Object)NativeBookmarkKt.bookmarkForFile((File)backgroundImagePath));
            }
            store.set(".", DSStoreProperties.Companion.getIconViewOptionsPList(), (Object)INSTANCE.makeIconViewOptions(backgroundImagePath));
            store.set(".", DSStoreProperties.Companion.getBrowserWindowSettings(), (Object)INSTANCE.makeBrowserWindowSettings(rootItemConfig));
            Map<String, ItemConfig> $this$forEach$iv = itemConfigByName;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, ItemConfig>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                ItemConfig.IconLocation location;
                Map.Entry<String, ItemConfig> element$iv;
                Map.Entry<String, ItemConfig> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String name = entry.getKey();
                ItemConfig config = entry.getValue();
                if ((ItemConfig.IconLocation)config.getIconLocation().getOrNull() == null) continue;
                boolean bl3 = false;
                store.set(name, DSStoreProperties.Companion.getIconLocation(), (Object)new IntPoint(location.getX(), location.getY()));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final IconViewOptions makeIconViewOptions(File backgroundImagePath) {
        return IconViewOptions.Companion.build((Function1)new Function1<IconViewOptions.Builder, Unit>(backgroundImagePath){
            final /* synthetic */ File $backgroundImagePath;
            {
                this.$backgroundImagePath = $backgroundImagePath;
                super(1);
            }

            public final void invoke(@NotNull IconViewOptions.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                $this$build.setViewOptionsVersion(Integer.valueOf(1));
                $this$build.setGridOffset(new IntPoint(0, 0));
                $this$build.setGridSpacing(Double.valueOf(100.0));
                $this$build.setArrangeBy("none");
                $this$build.setShowIconPreview(Boolean.valueOf(false));
                $this$build.setShowItemInfo(Boolean.valueOf(false));
                $this$build.setLabelOnBottom(Boolean.valueOf(true));
                $this$build.setTextSize(Double.valueOf(11.0));
                $this$build.setIconSize(Double.valueOf(72.0));
                $this$build.setScrollPosition(new DoublePoint(0.0, 0.0));
                $this$build.setBackgroundColor(DoubleRgbColor.Companion.getWhite());
                if (this.$backgroundImagePath != null) {
                    $this$build.setBackgroundType(Integer.valueOf(2));
                    $this$build.setBackgroundImageAlias(NativeAliasKt.aliasForFile((File)this.$backgroundImagePath));
                } else {
                    $this$build.setBackgroundType(Integer.valueOf(1));
                }
            }
        });
    }

    private final BrowserWindowSettings makeBrowserWindowSettings(RootItemConfig rootItemConfig) {
        return BrowserWindowSettings.Companion.build((Function1)new Function1<BrowserWindowSettings.Builder, Unit>(rootItemConfig){
            final /* synthetic */ RootItemConfig $rootItemConfig;
            {
                this.$rootItemConfig = $rootItemConfig;
                super(1);
            }

            public final void invoke(@NotNull BrowserWindowSettings.Builder $this$build) {
                Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
                RootItemConfig.WindowSize windowSize = (RootItemConfig.WindowSize)this.$rootItemConfig.getWindowSize().getOrElse((Object)new RootItemConfig.WindowSize(400, 300));
                $this$build.setShowStatusBar(Boolean.valueOf(false));
                $this$build.setWindowBounds("{{400, 100}, {" + windowSize.getWidth() + ", " + windowSize.getHeight() + "}}");
                $this$build.setContainerShowSidebar(Boolean.valueOf(false));
                $this$build.setPreviewPaneVisibility(Boolean.valueOf(false));
                $this$build.setSidebarWidth(Integer.valueOf(0));
                $this$build.setShowTabView(Boolean.valueOf(false));
                $this$build.setShowToolbar(Boolean.valueOf(false));
                $this$build.setShowPathbar(Boolean.valueOf(false));
                $this$build.setShowSidebar(Boolean.valueOf(false));
            }
        });
    }
}

