/*
 * Decompiled with CFR 0.152.
 */
package gay.blueokanna.merkletreeapi;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.WhirlpoolDigest;
import org.bouncycastle.util.encoders.Hex;

public class MerkleTree {
    private List<String> blockHashes = Collections.synchronizedList(new ArrayList());
    private ExecutorService executorService;
    private String Algorithm_Hash;

    public MerkleTree() {
        this.Algorithm_Hash = "SHA256";
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public MerkleTree(String Algorithm) {
        this.Algorithm_Hash = Algorithm;
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    public MerkleTree(String Algorithm, int numThread) {
        this.Algorithm_Hash = Algorithm;
        this.executorService = Executors.newFixedThreadPool(numThread);
    }

    public void addBlock(String block) {
        if (block == null || block.isEmpty()) {
            throw new IllegalArgumentException("Block cannot be null or empty.");
        }
        String calHash = this.calculateHash(block, this.Algorithm_Hash);
        this.blockHashes.add(calHash);
    }

    public String getBlockHash(int blockIndex) {
        if (blockIndex < 0 || blockIndex >= this.blockHashes.size()) {
            throw new IllegalArgumentException("Invalid block index.");
        }
        return this.blockHashes.get(blockIndex);
    }

    public CompletableFuture<Void> computeRootHashAsync() {
        return CompletableFuture.supplyAsync(this::computeRootHash, this.executorService).thenAccept(root -> {});
    }

    public String computeRootHash() {
        ArrayList<String> hashes = new ArrayList<String>(this.blockHashes);
        if (hashes.isEmpty()) {
            return null;
        }
        while (hashes.size() > 1) {
            ArrayList<CompletableFuture<String>> intermediateHashFutures = new ArrayList<CompletableFuture<String>>();
            for (int i = 0; i < hashes.size(); i += 2) {
                String leftHash = (String)hashes.get(i);
                String string = i + 1 < hashes.size() ? (String)hashes.get(i + 1) : leftHash;
                CompletableFuture<String> combinedHashFuture = CompletableFuture.supplyAsync(() -> this.calculateHash(leftHash + rightHash, this.Algorithm_Hash), this.executorService);
                intermediateHashFutures.add(combinedHashFuture);
            }
            CompletableFuture<Void> allOf = CompletableFuture.allOf((CompletableFuture[])intermediateHashFutures.toArray(CompletableFuture[]::new));
            allOf.join();
            hashes.clear();
            for (CompletableFuture completableFuture : intermediateHashFutures) {
                hashes.add((String)completableFuture.join());
            }
        }
        return (String)hashes.get(0);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    private String calculateHash(String input, String algorithm) {
        try {
            MessageDigest digest;
            switch (algorithm) {
                case "MD5": 
                case "SHA1": 
                case "SHA224": 
                case "SHA256": 
                case "SHA384": 
                case "SHA512": {
                    digest = MessageDigest.getInstance(algorithm);
                    break;
                }
                case "Whirlpool": {
                    return this.whirlpoolHash(input);
                }
                case "RIPEMD160": {
                    return this.RIPEMD160(input);
                }
                case "SHA3": {
                    return this.SHA3Hash(input);
                }
                default: {
                    throw new IllegalArgumentException("Unsupported algorithm: " + algorithm);
                }
            }
            byte[] hashBytes = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            return this.bytesToHex(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Hashing failed: " + e.getMessage());
        }
    }

    private String SHA3Hash(String input) {
        SHA3Digest digest = new SHA3Digest(256);
        digest.update(input.getBytes(), 0, input.getBytes().length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return Hex.toHexString((byte[])result);
    }

    private String RIPEMD160(String input) {
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(input.getBytes(), 0, input.getBytes().length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return this.bytesToHex(result);
    }

    private String whirlpoolHash(String input) {
        WhirlpoolDigest whirlpoolDigest = new WhirlpoolDigest();
        byte[] data = input.getBytes(StandardCharsets.UTF_8);
        whirlpoolDigest.update(data, 0, data.length);
        byte[] hash = new byte[whirlpoolDigest.getDigestSize()];
        whirlpoolDigest.doFinal(hash, 0);
        return this.bytesToHex(hash);
    }

    private String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }
}

