/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.beans;

import com.generationjava.beans.AbstractBeanViewer;
import com.generationjava.beans.BeanViewRuntime;
import com.generationjava.beans.BeansW;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ReflectionBeanViewer
extends AbstractBeanViewer {
    public Object invokeGet(BeanViewRuntime runtime, Object bean, String methodName, Object index) {
        int idx = -1;
        boolean arrayLike = index instanceof Integer;
        if (arrayLike) {
            idx = (Integer)index;
        }
        methodName = "get" + StringUtils.capitalise((String)methodName);
        Method getMethod = null;
        Class[] clss0 = new Class[]{};
        Class[] clss = null;
        try {
            clss = arrayLike ? new Class[]{Integer.TYPE} : clss0;
            getMethod = bean.getClass().getMethod(methodName, clss);
        }
        catch (SecurityException se) {
        }
        catch (NoSuchMethodException nsme) {
            try {
                if (clss != clss0) {
                    getMethod = bean.getClass().getMethod(methodName, clss0);
                }
                arrayLike = false;
            }
            catch (SecurityException se2) {
            }
            catch (NoSuchMethodException nsme2) {
                // empty catch block
            }
        }
        if (getMethod == null) {
            return null;
        }
        try {
            Object[] param = null;
            param = arrayLike ? new Object[]{(Integer)index} : new Object[]{};
            Object obj = getMethod.invoke(bean, param);
            obj = CollectionUtils.index((Object)obj, (Object)index);
            return obj;
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            return null;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            return null;
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            return null;
        }
    }

    public void invokeSet(BeanViewRuntime runtime, Object bean, String methodName, Object idx, Object value) {
        methodName = "set" + StringUtils.capitalise((String)methodName);
        Method setMethod = null;
        Method[] methods = bean.getClass().getMethods();
        int size = methods.length;
        for (int i = 0; i < size; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            setMethod = methods[i];
            break;
        }
        if (setMethod == null) {
            return;
        }
        value = BeansW.convert(value, setMethod.getParameterTypes()[0]);
        try {
            Object[] param = null;
            param = new Object[]{value};
            setMethod.invoke(bean, param);
            return;
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
            return;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            return;
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
            return;
        }
    }
}

