/*
 * Decompiled with CFR 0.152.
 */
package com.generationjava.compare;

import com.generationjava.beans.ReflectionBeanViewer;
import com.generationjava.compare.ObjectComparator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class BeanComparator
implements Comparator {
    private static Map beanComparatorRegistry = new HashMap();
    private String attribute;
    private HashMap cache;
    private ReflectionBeanViewer bv = new ReflectionBeanViewer();
    private Comparator oc = new ObjectComparator();

    public static BeanComparator getInstance(String attrib) {
        Object obj = beanComparatorRegistry.get(attrib);
        if (obj == null) {
            obj = new BeanComparator(attrib);
            beanComparatorRegistry.put(attrib, obj);
        }
        return (BeanComparator)obj;
    }

    public BeanComparator(String attrib) {
        this.attribute = attrib;
    }

    public void setComparator(Comparator comp) {
        this.oc = comp;
    }

    public void precompile(Collection col) {
        this.caching(true);
        Iterator iterator = col.iterator();
        while (iterator.hasNext()) {
            Object bean = iterator.next();
            Object ret = this.bv.get(this.attribute, bean);
            this.cache.put(bean, ret);
        }
    }

    public boolean caching(boolean b) {
        boolean b2 = this.caching();
        this.cache = b ? new HashMap() : null;
        return b2;
    }

    public boolean caching() {
        return this.cache != null;
    }

    public int compare(Object o1, Object o2) {
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        Object ret1 = null;
        Object ret2 = null;
        if (this.caching()) {
            ret1 = this.cache.get(o1);
            ret2 = this.cache.get(o2);
        }
        if (ret1 == null) {
            ret1 = this.bv.get(this.attribute, o1);
        }
        if (ret2 == null) {
            ret2 = this.bv.get(this.attribute, o2);
        }
        return this.oc.compare(ret1, ret2);
    }
}

