/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private static final String PARAMETER_SEPARATOR = ";";
    private static final String NAME_VALUE_SEPARATOR = "=";
    Map _mimeTypeParameterMap = new HashMap();

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String parameterList) throws MimeTypeParseException {
        this.parse(parameterList);
    }

    protected void parse(String parameterList) throws MimeTypeParseException {
        if (parameterList == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(parameterList, PARAMETER_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            String parameter = tokenizer.nextToken();
            if (parameter.length() == 0) continue;
            int eq = parameter.indexOf(NAME_VALUE_SEPARATOR);
            String name = null;
            if (eq > -1) {
                name = this.parseToken(parameter.substring(0, eq));
            }
            String value = this.parseToken(parameter.substring(eq + 1));
            if ((name == null || name.length() == 0) && value.length() == 0) continue;
            if (name.length() == 0 || value.length() == 0) {
                throw new MimeTypeParseException("Name or value is Missing");
            }
            this.set(name, value);
        }
    }

    public int size() {
        return this._mimeTypeParameterMap.size();
    }

    public boolean isEmpty() {
        return this._mimeTypeParameterMap.isEmpty();
    }

    public String get(String name) {
        return (String)this._mimeTypeParameterMap.get(name);
    }

    public void set(String name, String value) {
        name = this.parseToken(name);
        value = this.parseToken(value);
        this._mimeTypeParameterMap.put(name, value);
    }

    public void remove(String name) {
        this._mimeTypeParameterMap.remove(name);
    }

    public Enumeration getNames() {
        return Collections.enumeration(this._mimeTypeParameterMap.keySet());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration enumeration = this.getNames();
        while (enumeration.hasMoreElements()) {
            buf.append(PARAMETER_SEPARATOR);
            String name = (String)enumeration.nextElement();
            buf.append(name).append(NAME_VALUE_SEPARATOR).append(this.get(name));
        }
        return buf.toString();
    }

    private String parseToken(String token) {
        return this.removeBlank(token);
    }

    private String removeBlank(String str) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(str);
        while (tokenizer.hasMoreTokens()) {
            buf.append(tokenizer.nextToken());
        }
        return buf.toString();
    }
}

