/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.search.SearchTerm;

public abstract class Message
implements Part {
    private static final Address[] ADDRESS_ARRAY = new Address[0];
    protected boolean expunged;
    protected Folder folder;
    protected int msgnum;
    protected Session session;

    protected Message() {
    }

    protected Message(Folder folder, int number) {
        this.folder = folder;
        this.msgnum = number;
    }

    protected Message(Session session) {
        this.session = session;
    }

    public abstract void addFrom(Address[] var1) throws MessagingException;

    public void addRecipient(RecipientType type, Address address) throws MessagingException {
        this.addRecipients(type, new Address[]{address});
    }

    public abstract void addRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public Address[] getAllRecipients() throws MessagingException {
        int id;
        Address[] to = this.getRecipients(RecipientType.TO);
        Address[] cc = this.getRecipients(RecipientType.CC);
        Address[] bcc = this.getRecipients(RecipientType.BCC);
        LinkedList<Address> result = new LinkedList<Address>();
        for (id = 0; to != null && id < to.length; ++id) {
            result.add(to[id]);
        }
        for (id = 0; cc != null && id < cc.length; ++id) {
            result.add(cc[id]);
        }
        for (id = 0; bcc != null && id < bcc.length; ++id) {
            result.add(bcc[id]);
        }
        return result.toArray(ADDRESS_ARRAY);
    }

    public abstract Flags getFlags() throws MessagingException;

    public Folder getFolder() {
        return this.folder;
    }

    public abstract Address[] getFrom() throws MessagingException;

    public int getMessageNumber() {
        return this.msgnum;
    }

    public abstract Date getReceivedDate() throws MessagingException;

    public abstract Address[] getRecipients(RecipientType var1) throws MessagingException;

    public Address[] getReplyTo() throws MessagingException {
        return this.getFrom();
    }

    public abstract Date getSentDate() throws MessagingException;

    public abstract String getSubject() throws MessagingException;

    public boolean isExpunged() {
        return this.expunged;
    }

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.getFlags().contains(flag);
    }

    public boolean match(SearchTerm term) throws MessagingException {
        return term.match(this);
    }

    public abstract Message reply(boolean var1) throws MessagingException;

    public abstract void saveChanges() throws MessagingException;

    protected void setExpunged(boolean expunged) {
        this.expunged = expunged;
    }

    public void setFlag(Flags.Flag flag, boolean set) throws MessagingException {
        Flags flags = this.getFlags();
        if (set) {
            flags.add(flag);
        } else {
            flags.remove(flag);
        }
    }

    public abstract void setFlags(Flags var1, boolean var2) throws MessagingException;

    public abstract void setFrom() throws MessagingException;

    public abstract void setFrom(Address var1) throws MessagingException;

    protected void setMessageNumber(int number) {
        this.msgnum = number;
    }

    public void setRecipient(RecipientType type, Address address) throws MessagingException {
        this.setRecipients(type, new Address[]{address});
    }

    public abstract void setRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public void setReplyTo(Address[] addresses) throws MessagingException {
        throw new MethodNotSupportedException("setReplyTo not implemented");
    }

    public abstract void setSentDate(Date var1) throws MessagingException;

    public abstract void setSubject(String var1) throws MessagingException;

    public static class RecipientType
    implements Serializable {
        public static final RecipientType BCC = new RecipientType("Bcc");
        public static final RecipientType CC = new RecipientType("Cc");
        public static final RecipientType TO = new RecipientType("To");
        protected String type;

        protected RecipientType(String type) {
            this.type = type;
        }

        protected Object readResolve() throws ObjectStreamException {
            if (this.type.equals("To")) {
                return TO;
            }
            if (this.type.equals("Cc")) {
                return CC;
            }
            if (this.type.equals("Bcc")) {
                return BCC;
            }
            return this;
        }

        public String toString() {
            return this.type;
        }
    }
}

