/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.MultipartDataSource;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;

public class MimeMultipart
extends Multipart {
    protected DataSource ds;
    protected boolean parsed = true;
    private transient ContentType type;
    private static byte[] dash = new byte[]{45, 45};
    private static byte[] crlf = new byte[]{13, 10};
    private static int part;

    public MimeMultipart() {
        this("mixed");
    }

    public MimeMultipart(String subtype) {
        this.type = new ContentType("multipart", subtype, null);
        this.type.setParameter("boundary", MimeMultipart.getBoundary());
        this.contentType = this.type.toString();
    }

    public MimeMultipart(DataSource dataSource) throws MessagingException {
        this.ds = dataSource;
        if (dataSource instanceof MultipartDataSource) {
            super.setMultipartDataSource((MultipartDataSource)dataSource);
            this.parsed = true;
        } else {
            this.type = new ContentType(this.ds.getContentType());
            this.contentType = this.type.toString();
            this.parsed = false;
        }
    }

    public void setSubType(String subtype) throws MessagingException {
        this.type.setSubType(subtype);
        this.contentType = this.type.toString();
    }

    public int getCount() throws MessagingException {
        this.parse();
        return super.getCount();
    }

    public synchronized BodyPart getBodyPart(int part) throws MessagingException {
        this.parse();
        return super.getBodyPart(part);
    }

    public BodyPart getBodyPart(String cid) throws MessagingException {
        this.parse();
        for (int i = 0; i < this.parts.size(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)this.parts.get(i);
            if (!cid.equals(bodyPart.getContentID())) continue;
            return bodyPart;
        }
        return null;
    }

    protected void updateHeaders() throws MessagingException {
        this.parse();
        for (int i = 0; i < this.parts.size(); ++i) {
            MimeBodyPart bodyPart = (MimeBodyPart)this.parts.get(i);
            bodyPart.updateHeaders();
        }
    }

    public void writeTo(OutputStream out) throws IOException, MessagingException {
        this.parse();
        String boundary = this.type.getParameter("boundary");
        byte[] bytes = boundary.getBytes();
        for (int i = 0; i < this.parts.size(); ++i) {
            BodyPart bodyPart = (BodyPart)this.parts.get(i);
            out.write(dash);
            out.write(bytes);
            out.write(crlf);
            bodyPart.writeTo(out);
            out.write(crlf);
        }
        out.write(dash);
        out.write(bytes);
        out.write(dash);
        out.write(crlf);
        out.flush();
    }

    protected void parse() throws MessagingException {
        if (this.parsed) {
            return;
        }
        try {
            ContentType cType = new ContentType(this.contentType);
            byte[] boundary = ("--" + cType.getParameter("boundary")).getBytes();
            BufferedInputStream is = new BufferedInputStream(this.ds.getInputStream());
            PushbackInputStream pushbackInStream = new PushbackInputStream(is, boundary.length + 2);
            this.readTillFirstBoundary(pushbackInStream, boundary);
            while (pushbackInStream.available() > 0) {
                MimeBodyPartInputStream partStream = new MimeBodyPartInputStream(pushbackInStream, boundary);
                this.addBodyPart(new MimeBodyPart(partStream));
            }
        }
        catch (Exception e) {
            throw new MessagingException(e.toString(), e);
        }
        this.parsed = true;
    }

    private boolean readTillFirstBoundary(PushbackInputStream pushbackInStream, byte[] boundary) throws MessagingException {
        try {
            while (pushbackInStream.available() > 0) {
                int boundaryIndex;
                int value = pushbackInStream.read();
                if ((byte)value != boundary[0]) continue;
                for (boundaryIndex = 0; pushbackInStream.available() > 0 && boundaryIndex < boundary.length && (byte)value == boundary[boundaryIndex]; ++boundaryIndex) {
                    value = pushbackInStream.read();
                    if (value != -1) continue;
                    throw new MessagingException("Unexpected End of Stream while searching for first Mime Boundary");
                }
                if (boundaryIndex != boundary.length) continue;
                pushbackInStream.read();
                return true;
            }
        }
        catch (IOException ioe) {
            throw new MessagingException(ioe.toString(), ioe);
        }
        return false;
    }

    protected InternetHeaders createInternetHeaders(InputStream in) throws MessagingException {
        return new InternetHeaders(in);
    }

    protected MimeBodyPart createMimeBodyPart(InternetHeaders headers, byte[] data) throws MessagingException {
        return new MimeBodyPart(headers, data);
    }

    protected MimeBodyPart createMimeBodyPart(InputStream in) throws MessagingException {
        return new MimeBodyPart(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getBoundary() {
        int i;
        Class clazz = MimeMultipart.class;
        synchronized (clazz) {
            i = part++;
        }
        StringBuffer buf = new StringBuffer(64);
        buf.append("----=_Part_").append(i).append('.').append(System.currentTimeMillis());
        return buf.toString();
    }

    public class MimeBodyPartInputStream
    extends InputStream {
        PushbackInputStream inStream;
        boolean boundaryFound = false;
        byte[] boundary;

        public MimeBodyPartInputStream(PushbackInputStream inStream, byte[] boundary) {
            this.inStream = inStream;
            this.boundary = boundary;
        }

        public int read() throws IOException {
            int boundaryIndex;
            if (this.boundaryFound) {
                return -1;
            }
            int value = this.inStream.read();
            if (value == 13) {
                value = this.inStream.read();
                if (value != 10) {
                    this.inStream.unread(value);
                    return 13;
                }
                value = this.inStream.read();
                if ((byte)value != this.boundary[0]) {
                    this.inStream.unread(value);
                    this.inStream.unread(10);
                    return 13;
                }
            } else if ((byte)value != this.boundary[0]) {
                return value;
            }
            for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
                value = this.inStream.read();
            }
            if (boundaryIndex == this.boundary.length) {
                this.boundaryFound = true;
                if (this.inStream.read() == 45 && (value = this.inStream.read()) != 45 && value != -1) {
                    this.inStream.unread(value);
                }
                return -1;
            }
            if (value != -1) {
                this.inStream.unread(value);
            }
            this.inStream.unread(this.boundary, 1, boundaryIndex - 1);
            return this.boundary[0];
        }
    }
}

