/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.client.builder;

import [Ljava.net.URI;;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.apache.geronimo.client.AppClientContainer;
import org.apache.geronimo.client.StaticJndiContextPlugin;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.ServiceConfigBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.deployment.xbeans.DependencyType;
import org.apache.geronimo.deployment.xbeans.GbeanType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.NamingContext;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.ServiceReferenceBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.j2ee.management.impl.J2EEAppClientModuleImpl;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.naming.deployment.ENCConfigBuilder;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.deployment.SecurityBuilder;
import org.apache.geronimo.xbeans.geronimo.GerConnectorType;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientDocument;
import org.apache.geronimo.xbeans.geronimo.client.GerApplicationClientType;
import org.apache.geronimo.xbeans.geronimo.client.GerResourceType;
import org.apache.geronimo.xbeans.geronimo.naming.GerEjbRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerMessageDestinationType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceEnvRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerResourceRefType;
import org.apache.geronimo.xbeans.geronimo.naming.GerServiceRefType;
import org.apache.geronimo.xbeans.geronimo.security.GerDefaultPrincipalType;
import org.apache.geronimo.xbeans.j2ee.ApplicationClientDocument;
import org.apache.geronimo.xbeans.j2ee.ApplicationClientType;
import org.apache.geronimo.xbeans.j2ee.EjbLocalRefType;
import org.apache.geronimo.xbeans.j2ee.EjbRefType;
import org.apache.geronimo.xbeans.j2ee.EnvEntryType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationRefType;
import org.apache.geronimo.xbeans.j2ee.MessageDestinationType;
import org.apache.geronimo.xbeans.j2ee.ResourceEnvRefType;
import org.apache.geronimo.xbeans.j2ee.ResourceRefType;
import org.apache.geronimo.xbeans.j2ee.ServiceRefType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class AppClientModuleBuilder
implements ModuleBuilder {
    private final List defaultClientParentId;
    private final List defaultServerParentId;
    private final ObjectName corbaGBeanObjectName;
    private final Kernel kernel;
    private final Repository repository;
    private final ConfigurationStore store;
    private final String clientApplicationName = "client-application";
    private final ObjectName transactionContextManagerObjectName;
    private final ObjectName connectionTrackerObjectName;
    private final EJBReferenceBuilder ejbReferenceBuilder;
    private final ModuleBuilder connectorModuleBuilder;
    private final ResourceReferenceBuilder resourceReferenceBuilder;
    private final ServiceReferenceBuilder serviceReferenceBuilder;
    private static final String GERAPPCLIENT_NAMESPACE;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AppClientModuleBuilder(URI[] defaultClientParentId, URI[] defaultServerParentId, ObjectName transactionContextManagerObjectName, ObjectName connectionTrackerObjectName, ObjectName corbaGBeanObjectName, EJBReferenceBuilder ejbReferenceBuilder, ModuleBuilder connectorModuleBuilder, ResourceReferenceBuilder resourceReferenceBuilder, ServiceReferenceBuilder serviceReferenceBuilder, ConfigurationStore store, Repository repository, Kernel kernel) throws DeploymentException {
        this.defaultClientParentId = defaultClientParentId == null ? Collections.EMPTY_LIST : Arrays.asList(defaultClientParentId);
        this.defaultServerParentId = defaultServerParentId == null ? Collections.EMPTY_LIST : Arrays.asList(defaultServerParentId);
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.kernel = kernel;
        this.repository = repository;
        this.store = store;
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.connectorModuleBuilder = connectorModuleBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.serviceReferenceBuilder = serviceReferenceBuilder;
    }

    public Module createModule(File plan, JarFile moduleFile) throws DeploymentException {
        return this.createModule((Object)plan, moduleFile, "app-client", (URL)null, (URI)null, true);
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, URI earConfigId, Object moduleContextInfo) throws DeploymentException {
        return this.createModule(plan, moduleFile, targetPath, specDDUrl, earConfigId, false);
    }

    private Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, URI earConfigId, boolean standAlone) throws DeploymentException {
        ApplicationClientType appClient;
        String specDD;
        if (!$assertionsDisabled && moduleFile == null) {
            throw new AssertionError((Object)"moduleFile is null");
        }
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && targetPath.endsWith("/")) {
            throw new AssertionError((Object)"targetPath must not end with a '/'");
        }
        try {
            if (specDDUrl == null) {
                specDDUrl = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/application-client.xml");
            }
            specDD = DeploymentUtil.readAll((URL)specDDUrl);
        }
        catch (Exception e) {
            return null;
        }
        try {
            XmlObject xmlObject = XmlBeansUtil.parse((String)specDD);
            ApplicationClientDocument appClientDoc = SchemaConversionUtils.convertToApplicationClientSchema((XmlObject)xmlObject);
            appClient = appClientDoc.getApplicationClient();
        }
        catch (XmlException e) {
            throw new DeploymentException("Unable to parse application-client.xml", (Throwable)e);
        }
        GerApplicationClientType gerAppClient = this.getGeronimoAppClient(plan, moduleFile, standAlone, targetPath, appClient, earConfigId);
        URI configId = null;
        try {
            configId = new URI(gerAppClient.getConfigId());
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid configId " + gerAppClient.getConfigId(), (Throwable)e);
        }
        ArrayList<URI> parentId = null;
        if (gerAppClient.isSetParentId()) {
            String parentIdString = gerAppClient.getParentId();
            try {
                parentId = new ArrayList();
                parentId.add(new URI(parentIdString));
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Could not create parentId uri from " + parentIdString, (Throwable)e);
            }
        } else {
            parentId = new ArrayList<URI>(this.defaultServerParentId);
        }
        return new AppClientModule(standAlone, configId, parentId, moduleFile, targetPath, (XmlObject)appClient, (XmlObject)gerAppClient, specDD);
    }

    GerApplicationClientType getGeronimoAppClient(Object plan, JarFile moduleFile, boolean standAlone, String targetPath, ApplicationClientType appClient, URI earConfigId) throws DeploymentException {
        GerApplicationClientType gerAppClient = null;
        XmlObject rawPlan = null;
        try {
            Object path;
            try {
                if (plan instanceof XmlObject) {
                    rawPlan = (XmlObject)plan;
                } else if (plan != null) {
                    rawPlan = XmlBeansUtil.parse((File)((File)plan));
                } else {
                    path = DeploymentUtil.createJarURL((JarFile)moduleFile, (String)"META-INF/geronimo-application-client.xml");
                    rawPlan = XmlBeansUtil.parse((URL)path);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (rawPlan != null) {
                gerAppClient = (GerApplicationClientType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)GerApplicationClientDocument.type.getDocumentElementName(), (SchemaType)GerApplicationClientType.type);
            } else {
                path = standAlone ? new File(moduleFile.getName()).getName() : targetPath;
                gerAppClient = this.createDefaultPlan((String)path, appClient, standAlone, earConfigId);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        return gerAppClient;
    }

    private GerApplicationClientType createDefaultPlan(String name, ApplicationClientType appClient, boolean standAlone, URI earConfigId) {
        String id = appClient.getId();
        if (id == null) {
            id = name;
            if (id.endsWith(".jar")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        GerApplicationClientType geronimoAppClient = GerApplicationClientType.Factory.newInstance();
        if (standAlone) {
            geronimoAppClient.setClientConfigId(id);
            geronimoAppClient.setConfigId(id + "/server");
        } else {
            geronimoAppClient.setClientConfigId(earConfigId.getPath() + "/" + id);
            geronimoAppClient.setConfigId(id);
        }
        return geronimoAppClient;
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module) throws DeploymentException {
        earContext.addParentId(this.defaultServerParentId);
        JarFile moduleFile = module.getModuleFile();
        try {
            earContext.addIncludeAsPackedJar(URI.create(module.getTargetPath()), moduleFile);
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName());
        }
        ((AppClientModule)module).setEarFile(earFile);
    }

    public void initContext(EARContext earContext, Module clientModule, ClassLoader cl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addGBeans(EARContext earContext, Module module, ClassLoader earClassLoader) throws DeploymentException {
        J2eeContext earJ2eeContext = earContext.getJ2eeContext();
        AppClientModule appClientModule = (AppClientModule)module;
        ApplicationClientType appClient = (ApplicationClientType)appClientModule.getSpecDD();
        GerApplicationClientType geronimoAppClient = (GerApplicationClientType)appClientModule.getVendorDD();
        JarFile moduleFile = module.getModuleFile();
        String mainClasss = null;
        try {
            Manifest manifest = moduleFile.getManifest();
            if (manifest == null) {
                throw new DeploymentException("App client module jar does not contain a manifest: " + moduleFile.getName());
            }
            mainClasss = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            if (mainClasss == null) {
                throw new DeploymentException("App client module jar does not have Main-Class defined in the manifest: " + moduleFile.getName());
            }
            String classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            if (module.isStandAlone() && classPath != null) {
                throw new DeploymentException("Manifest class path entry is not allowed in a standalone jar (J2EE 1.4 Section 8.2)");
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Could not get manifest from app client module: " + moduleFile.getName());
        }
        ObjectName appClientModuleName = null;
        try {
            appClientModuleName = NameFactory.getModuleName(null, null, null, (String)"AppClientModule", (String)appClientModule.getName(), (J2eeContext)earJ2eeContext);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Could not construct module name", (Throwable)e);
        }
        GBeanData appClientModuleGBeanData = new GBeanData(appClientModuleName, J2EEAppClientModuleImpl.GBEAN_INFO);
        try {
            appClientModuleGBeanData.setReferencePatterns("J2EEServer", Collections.singleton(earContext.getServerObjectName()));
            if (!earContext.getJ2EEApplicationName().equals("null")) {
                appClientModuleGBeanData.setReferencePatterns("J2EEApplication", Collections.singleton(earContext.getApplicationObjectName()));
            }
            appClientModuleGBeanData.setAttribute("deploymentDescriptor", (Object)appClientModule.getOriginalSpecDD());
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
        }
        earContext.addGBean(appClientModuleGBeanData);
        EARContext appClientDeploymentContext = null;
        File appClientDir = null;
        ConfigurationData appClientConfigurationData = null;
        try {
            block55: {
                try {
                    appClientDir = this.store.createNewConfigurationDir();
                    try {
                        URI clientConfigId = URI.create(geronimoAppClient.getClientConfigId());
                        List clientParentId = ServiceConfigBuilder.getParentID((String)geronimoAppClient.getClientParentId(), (DependencyType[])geronimoAppClient.getImportArray());
                        clientParentId.addAll(this.defaultClientParentId);
                        appClientDeploymentContext = new EARContext(appClientDir, clientConfigId, ConfigurationModuleType.CAR, clientParentId, this.kernel, "client-application", this.transactionContextManagerObjectName, this.connectionTrackerObjectName, null, null, this.corbaGBeanObjectName, RefContext.derivedClientRefContext((RefContext)earContext.getRefContext(), (EJBReferenceBuilder)this.ejbReferenceBuilder, (ResourceReferenceBuilder)this.resourceReferenceBuilder, (ServiceReferenceBuilder)this.serviceReferenceBuilder));
                    }
                    catch (Exception e) {
                        throw new DeploymentException("Could not create a deployment context for the app client", (Throwable)e);
                    }
                    MessageDestinationType[] messageDestinations = appClient.getMessageDestinationArray();
                    GerMessageDestinationType[] gerMessageDestinations = geronimoAppClient.getMessageDestinationArray();
                    ENCConfigBuilder.registerMessageDestinations((RefContext)appClientDeploymentContext.getRefContext(), (String)appClientModule.getName(), (MessageDestinationType[])messageDestinations, (GerMessageDestinationType[])gerMessageDestinations);
                    URI moduleBase = new URI(appClientModule.getTargetPath());
                    try {
                        appClientDeploymentContext.addIncludeAsPackedJar(moduleBase, moduleFile);
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Unable to copy app client module jar into configuration: " + moduleFile.getName());
                    }
                    DependencyType[] includes = geronimoAppClient.getIncludeArray();
                    ServiceConfigBuilder.addIncludes((DeploymentContext)appClientDeploymentContext, (DependencyType[])includes, (Repository)this.repository);
                    DependencyType[] dependencies = geronimoAppClient.getDependencyArray();
                    ServiceConfigBuilder.addDependencies((DeploymentContext)appClientDeploymentContext, (DependencyType[])dependencies, (Repository)this.repository);
                    this.addManifestClassPath((DeploymentContext)appClientDeploymentContext, appClientModule.getEarFile(), moduleFile, moduleBase);
                    ClassLoader appClientClassLoader = appClientDeploymentContext.getClassLoader(this.repository);
                    if (geronimoAppClient != null) {
                        Iterator iterator3;
                        GbeanType[] gbeans = geronimoAppClient.getGbeanArray();
                        ServiceConfigBuilder.addGBeans((GbeanType[])gbeans, (ClassLoader)appClientClassLoader, (J2eeContext)appClientDeploymentContext.getJ2eeContext(), (DeploymentContext)appClientDeploymentContext);
                        ArrayList<Module> resourceModules = new ArrayList<Module>();
                        try {
                            Module connectorModule;
                            GerResourceType[] resources = geronimoAppClient.getResourceArray();
                            for (int i = 0; i < resources.length; ++i) {
                                void var28_39;
                                String path;
                                GerResourceType resource = resources[i];
                                if (resource.isSetExternalRar()) {
                                    path = resource.getExternalRar().trim();
                                    URI pathURI = null;
                                    try {
                                        pathURI = new URI(path);
                                    }
                                    catch (URISyntaxException e) {
                                        throw new DeploymentException("Bad path to external rar", (Throwable)e);
                                    }
                                    if (!this.repository.hasURI(pathURI)) {
                                        throw new DeploymentException("Missing rar in repository: " + path);
                                    }
                                    URL pathURL = null;
                                    try {
                                        pathURL = this.repository.getURL(pathURI);
                                    }
                                    catch (MalformedURLException e) {
                                        throw new DeploymentException("Could not locate external rar in repository", (Throwable)e);
                                    }
                                    try {
                                        JarFile jarFile = new JarFile(URLDecoder.decode(pathURL.getFile(), "UTF-8"));
                                    }
                                    catch (IOException e) {
                                        throw new DeploymentException("Could not access rar contents", (Throwable)e);
                                    }
                                }
                                path = resource.getInternalRar();
                                try {
                                    NestedJarFile nestedJarFile = new NestedJarFile(appClientModule.getEarFile(), path);
                                }
                                catch (IOException e) {
                                    throw new DeploymentException("Could not locate connector inside ear", (Throwable)e);
                                }
                                GerConnectorType connectorPlan = resource.getConnector();
                                Module connectorModule2 = this.connectorModuleBuilder.createModule((Object)connectorPlan, (JarFile)var28_39, path, null, null, null);
                                resourceModules.add(connectorModule2);
                                this.connectorModuleBuilder.installModule((JarFile)var28_39, appClientDeploymentContext, connectorModule2);
                            }
                            appClientClassLoader = appClientDeploymentContext.getClassLoader(this.repository);
                            Iterator iterator2 = resourceModules.iterator();
                            while (iterator2.hasNext()) {
                                connectorModule = (Module)iterator2.next();
                                this.connectorModuleBuilder.initContext(appClientDeploymentContext, connectorModule, appClientClassLoader);
                            }
                            iterator2 = resourceModules.iterator();
                            while (iterator2.hasNext()) {
                                connectorModule = (Module)iterator2.next();
                                this.connectorModuleBuilder.addGBeans(appClientDeploymentContext, connectorModule, appClientClassLoader);
                            }
                            Object var33_49 = null;
                            iterator3 = resourceModules.iterator();
                        }
                        catch (Throwable throwable) {
                            Object var33_50 = null;
                            Iterator iterator3 = resourceModules.iterator();
                            while (iterator3.hasNext()) {
                                Module connectorModule = (Module)iterator3.next();
                                connectorModule.close();
                            }
                            throw throwable;
                        }
                        while (iterator3.hasNext()) {
                            Module connectorModule = (Module)iterator3.next();
                            connectorModule.close();
                        }
                    }
                    ObjectName jndiContextName = ObjectName.getInstance("geronimo.client:type=StaticJndiContext");
                    GBeanData jndiContextGBeanData = new GBeanData(jndiContextName, StaticJndiContextPlugin.GBEAN_INFO);
                    try {
                        Map componentContext = this.buildComponentContext(appClientDeploymentContext, (NamingContext)earContext, appClientModule, appClient, geronimoAppClient, appClientClassLoader);
                        jndiContextGBeanData.setAttribute("context", (Object)componentContext);
                    }
                    catch (DeploymentException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new DeploymentException("Unable to construct jndi context for AppClientModule GBean", (Throwable)e);
                    }
                    appClientDeploymentContext.addGBean(jndiContextGBeanData);
                    ObjectName appClientContainerName = ObjectName.getInstance("geronimo.client:type=ClientContainer");
                    GBeanData appClientContainerGBeanData = new GBeanData(appClientContainerName, AppClientContainer.GBEAN_INFO);
                    try {
                        appClientContainerGBeanData.setAttribute("mainClassName", (Object)mainClasss);
                        appClientContainerGBeanData.setAttribute("appClientModuleName", (Object)appClientModuleName);
                        String callbackHandlerClassName = null;
                        if (appClient.isSetCallbackHandler()) {
                            callbackHandlerClassName = appClient.getCallbackHandler().getStringValue().trim();
                        }
                        if (geronimoAppClient.isSetCallbackHandler()) {
                            callbackHandlerClassName = geronimoAppClient.getCallbackHandler().trim();
                        }
                        String realmName = null;
                        if (geronimoAppClient.isSetRealmName()) {
                            realmName = geronimoAppClient.getRealmName().trim();
                        }
                        if (callbackHandlerClassName != null && realmName == null) {
                            throw new DeploymentException("You must specify a realm name with the callback handler");
                        }
                        if (realmName != null) {
                            appClientContainerGBeanData.setAttribute("realmName", (Object)realmName);
                            appClientContainerGBeanData.setAttribute("callbackHandlerClassName", (Object)callbackHandlerClassName);
                        } else if (geronimoAppClient.isSetDefaultPrincipal()) {
                            DefaultPrincipal defaultPrincipal = SecurityBuilder.buildDefaultPrincipal((GerDefaultPrincipalType)geronimoAppClient.getDefaultPrincipal());
                            appClientContainerGBeanData.setAttribute("defaultPrincipal", (Object)defaultPrincipal);
                        }
                        appClientContainerGBeanData.setReferencePattern("JNDIContext", jndiContextName);
                        appClientContainerGBeanData.setReferencePattern("TransactionContextManager", this.transactionContextManagerObjectName);
                    }
                    catch (Exception e) {
                        throw new DeploymentException("Unable to initialize AppClientModule GBean", (Throwable)e);
                    }
                    appClientDeploymentContext.addGBean(appClientContainerGBeanData);
                    appClientConfigurationData = appClientDeploymentContext.getConfigurationData();
                    Object var37_56 = null;
                    if (appClientDeploymentContext == null) break block55;
                }
                catch (Throwable throwable) {
                    Object var37_57 = null;
                    if (appClientDeploymentContext == null) throw throwable;
                    try {
                        appClientDeploymentContext.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException e) {}
                appClientDeploymentContext.close();
            }
            try {
                this.store.install(appClientDeploymentContext.getConfigurationData(), appClientDir);
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
            earContext.addChildConfiguration(appClientConfigurationData);
            return;
        }
        catch (Throwable e) {
            DeploymentUtil.recursiveDelete(appClientDir);
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (!(e instanceof Exception)) throw new Error(e);
            throw new DeploymentException(e);
        }
    }

    public String getSchemaNamespace() {
        return GERAPPCLIENT_NAMESPACE;
    }

    public void addManifestClassPath(DeploymentContext deploymentContext, JarFile earFile, JarFile jarFile, URI jarFileLocation) throws DeploymentException {
        Manifest manifest = null;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read manifest: " + jarFileLocation);
        }
        if (manifest == null) {
            return;
        }
        String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid manifest classpath entry: jarFile=" + jarFileLocation + ", path=" + path);
            }
            if (!pathUri.getPath().endsWith(".jar")) {
                throw new DeploymentException("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path);
            }
            if (pathUri.isAbsolute()) {
                throw new DeploymentException("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path);
            }
            URI classPathJarLocation = jarFileLocation.resolve(pathUri);
            File classPathFile = deploymentContext.getTargetFile(classPathJarLocation);
            if (classPathFile.exists()) continue;
            ZipEntry entry = earFile.getEntry(classPathJarLocation.getPath());
            if (entry == null) {
                throw new DeploymentException("Cound not find manifest class path entry: jarFile=" + jarFileLocation + ", path=" + path);
            }
            try {
                deploymentContext.addFile(classPathJarLocation, (ZipFile)earFile, entry);
            }
            catch (IOException e) {
                throw new DeploymentException("Cound not copy manifest class path entry into configuration: jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            JarFile classPathJarFile = null;
            try {
                classPathJarFile = new JarFile(classPathFile);
            }
            catch (IOException e) {
                throw new DeploymentException("Manifest class path entries must be a valid jar file (J2EE 1.4 Section 8.2): jarFile=" + jarFileLocation + ", path=" + path, (Throwable)e);
            }
            this.addManifestClassPath(deploymentContext, earFile, classPathJarFile, classPathJarLocation);
        }
    }

    private Map buildComponentContext(EARContext appClientContext, NamingContext ejbContext, AppClientModule appClientModule, ApplicationClientType appClient, GerApplicationClientType geronimoAppClient, ClassLoader cl) throws DeploymentException {
        return ENCConfigBuilder.buildComponentContext((EARContext)appClientContext, (NamingContext)ejbContext, (Module)appClientModule, null, (EnvEntryType[])appClient.getEnvEntryArray(), (EjbRefType[])appClient.getEjbRefArray(), (GerEjbRefType[])geronimoAppClient.getEjbRefArray(), (EjbLocalRefType[])new EjbLocalRefType[0], null, (ResourceRefType[])appClient.getResourceRefArray(), (GerResourceRefType[])geronimoAppClient.getResourceRefArray(), (ResourceEnvRefType[])appClient.getResourceEnvRefArray(), (GerResourceEnvRefType[])geronimoAppClient.getResourceEnvRefArray(), (MessageDestinationRefType[])appClient.getMessageDestinationRefArray(), (ServiceRefType[])appClient.getServiceRefArray(), (GerServiceRefType[])geronimoAppClient.getServiceRefArray(), (ClassLoader)cl);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !AppClientModuleBuilder.class.desiredAssertionStatus();
        GERAPPCLIENT_NAMESPACE = GerApplicationClientDocument.type.getDocumentElementName().getNamespaceURI();
        GBeanInfoBuilder infoBuilder = GBeanInfoBuilder.createStatic((Class)AppClientModuleBuilder.class, (String)"ModuleBuilder");
        infoBuilder.addAttribute("defaultClientParentId", URI;.class, true, true);
        infoBuilder.addAttribute("defaultServerParentId", URI;.class, true, true);
        infoBuilder.addAttribute("transactionContextManagerObjectName", ObjectName.class, true);
        infoBuilder.addAttribute("connectionTrackerObjectName", ObjectName.class, true);
        infoBuilder.addAttribute("corbaGBeanObjectName", ObjectName.class, true);
        infoBuilder.addReference("EJBReferenceBuilder", EJBReferenceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ConnectorModuleBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ResourceReferenceBuilder", ResourceReferenceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("ServiceReferenceBuilder", ServiceReferenceBuilder.class, "ModuleBuilder");
        infoBuilder.addReference("Store", ConfigurationStore.class, "ConfigurationStore");
        infoBuilder.addReference("Repository", Repository.class, "GBean");
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"defaultClientParentId", "defaultServerParentId", "transactionContextManagerObjectName", "connectionTrackerObjectName", "corbaGBeanObjectName", "EJBReferenceBuilder", "ConnectorModuleBuilder", "ResourceReferenceBuilder", "ServiceReferenceBuilder", "Store", "Repository", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

