/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import java.util.Collection;
import java.util.Iterator;
import javax.resource.ResourceException;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.ManagedConnection;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;

public class ConnectionTrackingInterceptor
implements ConnectionInterceptor {
    private final ConnectionInterceptor next;
    private final String key;
    private final ConnectionTracker connectionTracker;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConnectionTrackingInterceptor(ConnectionInterceptor next, String key, ConnectionTracker connectionTracker) {
        this.next = next;
        this.key = key;
        this.connectionTracker = connectionTracker;
    }

    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        this.connectionTracker.setEnvironment(connectionInfo, this.key);
        this.next.getConnection(connectionInfo);
        this.connectionTracker.handleObtained(this, connectionInfo);
    }

    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        this.connectionTracker.handleReleased(this, connectionInfo);
        this.next.returnConnection(connectionInfo, connectionReturnAction);
    }

    public void enter(Collection connectionInfos) throws ResourceException {
        Iterator i = connectionInfos.iterator();
        while (i.hasNext()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)i.next();
            this.next.getConnection(connectionInfo);
        }
    }

    public void exit(Collection connectionInfos) throws ResourceException {
        Iterator i = connectionInfos.iterator();
        while (i.hasNext()) {
            ConnectionInfo connectionInfo = (ConnectionInfo)i.next();
            if (connectionInfo.isUnshareable()) {
                return;
            }
            ManagedConnectionInfo managedConnectionInfo = connectionInfo.getManagedConnectionInfo();
            ManagedConnection managedConnection = managedConnectionInfo.getManagedConnection();
            if (!(managedConnection instanceof DissociatableManagedConnection) || !managedConnectionInfo.isFirstConnectionInfo(connectionInfo)) continue;
            int size = connectionInfos.size();
            i.remove();
            if (!$assertionsDisabled && size - 1 != connectionInfos.size()) {
                throw new AssertionError();
            }
            ((DissociatableManagedConnection)managedConnection).dissociateConnections();
            managedConnectionInfo.clearConnectionHandles();
            this.returnConnection(connectionInfo, ConnectionReturnAction.RETURN_HANDLE);
        }
    }

    static {
        $assertionsDisabled = !ConnectionTrackingInterceptor.class.desiredAssertionStatus();
    }
}

