/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound.transactionlog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import javax.transaction.xa.Xid;
import org.apache.geronimo.connector.outbound.ManagedConnectionFactoryWrapper;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.TransactionBranchInfo;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;

public class JDBCLog
implements TransactionLog,
GBeanLifecycle {
    private static final String INSERT_XID = "INSERT INTO TXLOG (SYSTEMID, FORMATID, GLOBALID, GLOBALBRANCHID, BRANCHBRANCHID, NAME) VALUES (?, ?, ?, ?, ?)";
    private static final String DELETE_XID = "DELETE FROM TXLOG WHERE SYSTEMID = ? AND FORMATID = ? AND GLOBALID = ?  AND GLOBALBRANCHID = ?";
    private static final String RECOVER = "SELECT FORMATID, GLOBALID, GLOBALBRANCHID, BRANCHBRANCHID, NAME FROM TXLOG WHERE SYSTEMID = ? ORDER BY FORMATID, GLOBALID, GLOBALBRANCHID, BRANCHBRANCHID, NAME";
    private DataSource dataSource;
    private final String systemId;
    private final ManagedConnectionFactoryWrapper managedConnectionFactoryWrapper;
    public static final GBeanInfo GBEAN_INFO;

    public JDBCLog(String systemId, ManagedConnectionFactoryWrapper managedConnectionFactoryWrapper) {
        this.systemId = systemId;
        this.managedConnectionFactoryWrapper = managedConnectionFactoryWrapper;
    }

    public JDBCLog(String systemId, DataSource dataSource) {
        this.systemId = systemId;
        this.managedConnectionFactoryWrapper = null;
        this.dataSource = dataSource;
    }

    public void doStart() throws Exception {
        this.dataSource = (DataSource)this.managedConnectionFactoryWrapper.$getResource();
    }

    public void doStop() throws Exception {
        this.dataSource = null;
    }

    public void doFail() {
    }

    public void begin(Xid xid) throws LogException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object prepare(Xid xid, List branches) throws LogException {
        int formatId = xid.getFormatId();
        byte[] globalTransactionId = xid.getGlobalTransactionId();
        byte[] branchQualifier = xid.getBranchQualifier();
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                PreparedStatement ps = connection.prepareStatement(INSERT_XID);
                try {
                    Iterator iterator = branches.iterator();
                    while (iterator.hasNext()) {
                        TransactionBranchInfo branch = (TransactionBranchInfo)iterator.next();
                        ps.setString(0, this.systemId);
                        ps.setInt(1, formatId);
                        ps.setBytes(2, globalTransactionId);
                        ps.setBytes(3, branchQualifier);
                        ps.setBytes(4, branch.getBranchXid().getBranchQualifier());
                        ps.setString(5, branch.getResourceName());
                        ps.execute();
                    }
                }
                finally {
                    ps.close();
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new LogException("Failure during prepare or commit", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, Object logMark) throws LogException {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                PreparedStatement ps = connection.prepareStatement(DELETE_XID);
                try {
                    ps.setString(0, this.systemId);
                    ps.setInt(1, xid.getFormatId());
                    ps.setBytes(2, xid.getGlobalTransactionId());
                    ps.setBytes(3, xid.getBranchQualifier());
                    ps.execute();
                }
                finally {
                    ps.close();
                }
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new LogException("Failure during prepare or commit", (Throwable)e);
        }
    }

    public void rollback(Xid xid, Object logMark) throws LogException {
        throw new LogException("JDBCLog does not support rollback of prepared transactions.  Use it only on servers that do not import transactions");
    }

    /*
     * Exception decompiling
     */
    public Collection recover(XidFactory xidFactory) throws LogException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getXMLStats() {
        return null;
    }

    public int getAverageForceTime() {
        return 0;
    }

    public int getAverageBytesPerForce() {
        return 0;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(JDBCLog.class, NameFactory.JCA_RESOURCE);
        infoFactory.addAttribute("systemId", String.class, true);
        infoFactory.addInterface(TransactionLog.class);
        infoFactory.addReference("ManagedConnectionFactoryWrapper", ManagedConnectionFactoryWrapper.class, NameFactory.JCA_MANAGED_CONNECTION_FACTORY);
        infoFactory.setConstructor(new String[]{"systemId", "DataSource"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

