/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli;

import java.io.IOException;
import java.util.ArrayList;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.apache.geronimo.console.cli.DeploymentContext;

public abstract class TextController {
    protected final DeploymentContext context;

    public TextController(DeploymentContext context) {
        this.context = context;
    }

    protected boolean ensureConnected() {
        if (this.context.connected) {
            return true;
        }
        this.context.out.println("Not connected.");
        return false;
    }

    protected void newScreen(String title) {
        this.context.out.println("\n\n------ " + title + " ------");
    }

    protected void print(String s) {
        this.context.out.print(s);
    }

    protected void println(String s) {
        this.context.out.println(s);
    }

    protected String truncate(String s, int size) {
        if (null == s) {
            return "";
        }
        if (s.length() <= size) {
            return s;
        }
        if (size < 3) {
            return "";
        }
        return s.substring(0, size - 3) + "...";
    }

    public abstract void execute();

    protected Target[] available(Target[] all, Target[] selected) {
        ArrayList<Target> list = new ArrayList<Target>();
        for (int i = 0; i < all.length; ++i) {
            boolean found = false;
            for (int j = 0; j < selected.length; ++j) {
                if (!all[i].getName().equals(selected[j].getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(all[i]);
        }
        return list.toArray(new Target[list.size()]);
    }

    protected TargetModuleID[] available(TargetModuleID[] all, TargetModuleID[] selected) {
        ArrayList<TargetModuleID> list = new ArrayList<TargetModuleID>();
        for (int i = 0; i < all.length; ++i) {
            boolean found = false;
            for (int j = 0; j < selected.length; ++j) {
                if (!TextController.equals(all[i], selected[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            list.add(all[i]);
        }
        return list.toArray(new TargetModuleID[list.size()]);
    }

    private static boolean equals(TargetModuleID one, TargetModuleID two) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        return one.getTarget().getName().equals(two.getTarget().getName()) && one.getModuleID().equals(two.getModuleID()) && TextController.equals(one.getParentTargetModuleID(), two.getParentTargetModuleID());
    }

    protected boolean confirmModuleAction(String action) throws IOException {
        String choice;
        if (this.context.modules.length == 0) {
            return false;
        }
        this.println("");
        do {
            this.print(action + " " + this.context.modules.length + " selected module(s)? ");
            this.context.out.flush();
        } while (!(choice = this.context.in.readLine().trim().toLowerCase()).equals("n") && !choice.equals("y"));
        return choice.equals("y");
    }

    protected void initializeDConfigBean(DConfigBean dcb) throws ConfigurationException {
        String[] xpaths = dcb.getXpaths();
        for (int i = 0; i < xpaths.length; ++i) {
            DDBean[] ddbs = dcb.getDDBean().getChildBean(xpaths[i]);
            for (int j = 0; j < ddbs.length; ++j) {
                this.initializeDConfigBean(dcb.getDConfigBean(ddbs[j]));
            }
        }
    }
}

