/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;

public class ProgressMonitor
extends TextController
implements ProgressListener {
    private ProgressObject progress;
    private boolean started = false;

    public ProgressMonitor(DeploymentContext context, ProgressObject progress) {
        super(context);
        this.progress = progress;
        progress.addProgressListener((ProgressListener)this);
    }

    public void execute() {
        this.initialize();
    }

    private synchronized void initialize() {
        if (!this.progress.getDeploymentStatus().isRunning()) {
            this.message("--" + this.progress.getDeploymentStatus().getMessage());
            this.printCompletion();
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.printCompletion();
    }

    public synchronized void handleProgressEvent(ProgressEvent event) {
        this.message("--" + event.getDeploymentStatus().getMessage());
        if (!event.getDeploymentStatus().isRunning()) {
            this.notifyAll();
        }
    }

    private void printBanner() {
        this.newScreen("Progress Monitor");
        this.println("Monitoring the progress of a " + this.progress.getDeploymentStatus().getCommand() + " operation.");
        this.println("This operation can" + (this.progress.isCancelSupported() ? "" : "not") + " be canceled");
        this.println("This operation can" + (this.progress.isStopSupported() ? "" : "not") + " be stopped");
    }

    private void message(String message) {
        if (!this.started) {
            this.printBanner();
            this.started = true;
        }
        this.println(message);
    }

    private void printCompletion() {
        this.println("Operation has " + (this.progress.getDeploymentStatus().isCompleted() ? "completed" : (this.progress.getDeploymentStatus().isFailed() ? "failed" : "finished")));
        this.println("Affected target/modules:");
        TargetModuleID[] ids = this.progress.getResultTargetModuleIDs();
        for (int i = 0; i < ids.length; ++i) {
            this.println("  " + ids[i]);
        }
    }
}

