/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.lock;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.lock.InstanceLock;

public class LockDomain {
    private final String name;
    private final boolean reentrant;
    private final Class lockClass;
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Map locks = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public LockDomain(String name, boolean reentrant, Class lockClass) {
        this.name = name;
        this.reentrant = reentrant;
        this.lockClass = lockClass;
    }

    public boolean isReentrant() {
        return this.reentrant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceLock getLock(Object key) {
        InstanceLock lock;
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        Map map = this.locks;
        synchronized (map) {
            this.processQueue();
            LockReference ref = (LockReference)this.locks.get(key);
            if (ref != null && (lock = (InstanceLock)ref.get()) != null) {
                return lock;
            }
            try {
                lock = (InstanceLock)this.lockClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException();
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException();
            }
            this.locks.put(key, new LockReference(key, lock));
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        LockReference lockRef;
        while ((lockRef = (LockReference)this.queue.poll()) != null) {
            Map map = this.locks;
            synchronized (map) {
                this.locks.remove(lockRef.key);
            }
        }
    }

    public String toString() {
        return "LockDomain[" + this.name + "]";
    }

    static {
        $assertionsDisabled = !LockDomain.class.desiredAssertionStatus();
    }

    private class LockReference
    extends WeakReference {
        private final Object key;

        public LockReference(Object key, Object lock) {
            super(lock, LockDomain.this.queue);
            this.key = key;
        }
    }
}

