/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.pool;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;

public class ThreadPool
implements Executor,
GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)ThreadPool.class);
    private PooledExecutor executor;
    private long keepAliveTime;
    private int poolSize;
    private String poolName;
    private int nextWorkerID = 0;
    public static final GBeanInfo GBEAN_INFO;

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public void execute(Runnable command) throws InterruptedException {
        this.executor.execute(command);
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    private int getNextWorkerID() {
        return this.nextWorkerID++;
    }

    public void doStart() throws WaitingException, Exception {
        PooledExecutor p = new PooledExecutor((Channel)new LinkedQueue(), this.poolSize);
        p.setKeepAliveTime(this.keepAliveTime);
        p.setMinimumPoolSize(this.poolSize);
        p.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable arg0) {
                return new Thread(arg0, ThreadPool.this.poolName + " " + ThreadPool.this.getNextWorkerID());
            }
        });
        this.executor = p;
        log.info((Object)("Thread pool " + this.poolName + " started"));
    }

    public void doStop() throws WaitingException, Exception {
        this.executor.shutdownNow();
        log.info((Object)("Thread pool " + this.poolName + " stopped"));
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            log.error((Object)"Failed to shutdown", (Throwable)e);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(ThreadPool.class);
        infoFactory.addAttribute("keepAliveTime", Long.TYPE, true);
        infoFactory.addAttribute("poolSize", Integer.TYPE, true);
        infoFactory.addAttribute("poolName", String.class, true);
        infoFactory.addInterface(Executor.class);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

