/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.validator;

import org.apache.geronimo.validator.ValidationContext;
import org.apache.geronimo.validator.ValidationException;
import org.apache.geronimo.validator.ValidationResult;
import org.apache.xmlbeans.SchemaType;

public abstract class ValidationTest {
    protected ValidationContext context;

    public abstract SchemaType getSchemaType();

    public abstract String getXpath();

    public abstract ValidationResult initialize(ValidationContext var1);

    protected Class loadClass(String className, String description) throws ValidationException {
        try {
            return this.context.loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new ValidationException("Class " + className + " could not be loaded (" + description + ")", e);
        }
    }

    protected ValidationResult warn(String messageCode, ValidationResult oldState) {
        this.context.out.println("Validator WARNING (in " + this.context.moduleName + ") " + this.getMessage(messageCode, null));
        if (oldState == ValidationResult.PASSED) {
            return ValidationResult.PASSED_WITH_WARNINGS;
        }
        return oldState;
    }

    protected ValidationResult warn(String messageCode, ValidationResult oldState, Object param) {
        this.context.out.println("Validator WARNING (in " + this.context.moduleName + ") " + this.getMessage(messageCode, new Object[]{param}));
        if (oldState == ValidationResult.PASSED) {
            return ValidationResult.PASSED_WITH_WARNINGS;
        }
        return oldState;
    }

    protected ValidationResult warn(String messageCode, ValidationResult oldState, Object[] params) {
        this.context.out.println("Validator WARNING (in " + this.context.moduleName + ") " + this.getMessage(messageCode, params));
        if (oldState == ValidationResult.PASSED) {
            return ValidationResult.PASSED_WITH_WARNINGS;
        }
        return oldState;
    }

    protected ValidationResult warn(String messageCode) {
        this.context.out.println("Validator WARNING (in " + this.context.moduleName + ") " + this.getMessage(messageCode, null));
        return ValidationResult.PASSED_WITH_WARNINGS;
    }

    protected ValidationResult warn(String messageCode, Object param) {
        this.context.out.println("Validator WARNING (in " + this.context.moduleName + ") " + this.getMessage(messageCode, new Object[]{param}));
        return ValidationResult.PASSED_WITH_WARNINGS;
    }

    protected ValidationResult warn(String messageCode, Object[] params) {
        this.context.out.println("Validator WARNING (in " + this.context.moduleName + ") " + this.getMessage(messageCode, params));
        return ValidationResult.PASSED_WITH_WARNINGS;
    }

    protected ValidationResult error(String messageCode, ValidationResult oldState) {
        this.context.out.println("Validator ERROR (in " + this.context.moduleName + ") " + this.getMessage(messageCode, null));
        if (oldState == ValidationResult.ABORTED) {
            return oldState;
        }
        return ValidationResult.FAILED;
    }

    protected ValidationResult error(String messageCode, ValidationResult oldState, Object param) {
        this.context.out.println("Validator ERROR (in " + this.context.moduleName + ") " + this.getMessage(messageCode, new Object[]{param}));
        if (oldState == ValidationResult.ABORTED) {
            return oldState;
        }
        return ValidationResult.FAILED;
    }

    protected ValidationResult error(String messageCode, ValidationResult oldState, Object[] params) {
        this.context.out.println("Validator ERROR (in " + this.context.moduleName + ") " + this.getMessage(messageCode, params));
        if (oldState == ValidationResult.ABORTED) {
            return oldState;
        }
        return ValidationResult.FAILED;
    }

    protected ValidationResult error(String messageCode) {
        this.context.out.println("Validator ERROR (in " + this.context.moduleName + ") " + this.getMessage(messageCode, null));
        return ValidationResult.FAILED;
    }

    protected ValidationResult error(String messageCode, Object param) {
        this.context.out.println("Validator ERROR (in " + this.context.moduleName + ") " + this.getMessage(messageCode, new Object[]{param}));
        return ValidationResult.FAILED;
    }

    protected ValidationResult error(String messageCode, Object[] params) {
        this.context.out.println("Validator ERROR (in " + this.context.moduleName + ") " + this.getMessage(messageCode, params));
        return ValidationResult.FAILED;
    }

    private String getMessage(String messageCode, Object[] params) {
        return messageCode + " " + params;
    }

    ValidationResult initializeTest(ValidationContext context) {
        this.context = context;
        return this.initialize(context);
    }
}

