/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cache;

import java.util.HashMap;
import org.apache.geronimo.cache.InstanceCache;

public final class SimpleInstanceCache
implements InstanceCache {
    private HashMap active = new HashMap();
    private HashMap inactive = new HashMap();

    public synchronized void putActive(Object key, Object value) {
        this.inactive.remove(key);
        this.active.put(key, value);
    }

    public synchronized void putInactive(Object key, Object value) {
        this.active.remove(key);
        this.inactive.put(key, value);
    }

    public synchronized Object get(Object key) {
        Object value = this.active.get(key);
        if (value != null) {
            return value;
        }
        value = this.inactive.remove(key);
        if (value != null) {
            this.active.put(key, value);
        }
        return value;
    }

    public synchronized Object remove(Object key) {
        Object value = this.active.remove(key);
        if (value == null) {
            value = this.inactive.remove(key);
        }
        return value;
    }

    public synchronized Object peek(Object key) {
        Object value = this.active.get(key);
        if (value != null) {
            return value;
        }
        return this.inactive.get(key);
    }

    public synchronized boolean isActive(Object key) {
        return this.active.containsKey(key);
    }
}

