/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;

public class ListDeployments
extends TextController {
    private static final Log log = LogFactory.getLog((Class)ListDeployments.class);
    private static final ModuleType[] ALL = new ModuleType[]{ModuleType.CAR, ModuleType.EAR, ModuleType.EJB, ModuleType.RAR, ModuleType.WAR};
    ModuleType type = null;
    boolean selected = false;

    public ListDeployments(DeploymentContext context) {
        super(context);
    }

    public void execute() {
        block2: while (true) {
            String choice;
            this.newScreen("Display Deployments");
            if (!this.context.connected) {
                this.println("ERROR: cannot display deployments in disconnected mode.");
                return;
            }
            if (this.selected) {
                this.showModules();
                if (!this.context.connected) {
                    return;
                }
            }
            do {
                this.context.out.print("Action ([E]JB, [C]lient, [W]eb app, [R]A, [A]pp, A[L]L modules or [B]ack): ");
                this.context.out.flush();
                try {
                    choice = this.context.in.readLine().trim().toLowerCase();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to read user input", (Throwable)e);
                    return;
                }
                if (choice.equals("b")) {
                    return;
                }
                if (choice.equals("e")) {
                    this.selected = true;
                    this.type = ModuleType.EJB;
                    continue block2;
                }
                if (choice.equals("c")) {
                    this.selected = true;
                    this.type = ModuleType.CAR;
                    continue block2;
                }
                if (choice.equals("w")) {
                    this.selected = true;
                    this.type = ModuleType.WAR;
                    continue block2;
                }
                if (choice.equals("r")) {
                    this.selected = true;
                    this.type = ModuleType.RAR;
                    continue block2;
                }
                if (!choice.equals("a")) continue;
                this.selected = true;
                this.type = ModuleType.EAR;
                continue block2;
            } while (!choice.equals("l"));
            this.selected = true;
            this.type = null;
        }
    }

    private void showModules() {
        try {
            TargetModuleID[] ids;
            if (this.type != null) {
                ids = this.context.deployer.getAvailableModules(this.type, this.context.targets);
                if (null == ids) {
                    ids = new TargetModuleID[]{};
                }
            } else {
                ArrayList<TargetModuleID> list = new ArrayList<TargetModuleID>();
                for (int i = 0; i < ALL.length; ++i) {
                    TargetModuleID[] modules = this.context.deployer.getAvailableModules(ALL[i], this.context.targets);
                    if (null == modules) continue;
                    list.addAll(Arrays.asList(modules));
                }
                ids = list.toArray(new TargetModuleID[list.size()]);
            }
            this.println(ids.length == 0 ? "No matching modules found." : "Found " + ids.length + " matching module" + (ids.length == 1 ? "" : "s"));
            for (int i = 0; i < ids.length; ++i) {
                this.println("  " + ids[i].toString());
            }
            this.println("");
        }
        catch (TargetException e) {
            this.println("ERROR: " + e.getMessage());
        }
        catch (IllegalStateException e) {
            this.println("ERROR: No longer connected to server.");
            this.context.connected = false;
        }
    }
}

