/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;

public class SaveServerSpecificDD
extends TextController {
    private static final Log log = LogFactory.getLog((Class)SaveServerSpecificDD.class);

    public SaveServerSpecificDD(DeploymentContext context) {
        super(context);
    }

    public void execute() {
        this.context.out.println("\nCurrent directory is " + this.context.saveDir);
        this.context.out.println("Select a file name.  The server-specific deployment information for the ");
        this.context.out.println(this.context.moduleInfo.getFileName() + " will be saved to the file you specify.");
        try {
            File file;
            while (true) {
                this.context.out.print("File Name: ");
                this.context.out.flush();
                String choice = this.context.in.readLine().trim();
                file = new File(this.context.saveDir, choice);
                if (file.exists() && !file.canWrite() || !file.exists() && !file.getParentFile().canWrite() || file.isDirectory()) {
                    this.context.out.println("ERROR: cannot write to this file.  Please try again.");
                    continue;
                }
                if (!file.exists()) break;
                this.context.out.print("File already exists.  Overwrite (Y/N)? ");
                this.context.out.flush();
                choice = this.context.in.readLine().trim().toLowerCase();
                if (!choice.equals("n")) break;
            }
            this.context.saveDir = file.getParentFile();
            try {
                this.context.moduleInfo.saveDConfigBean(file);
                this.context.out.println("Deployment information saved to " + file.getName());
                return;
            }
            catch (IOException e) {
                log.error((Object)"Unable to write to file", (Throwable)e);
                return;
            }
            catch (ConfigurationException e) {
                this.context.out.println("ERROR: " + e.getMessage());
                return;
            }
        }
        catch (IOException e) {
            log.error((Object)"Unable to read user input", (Throwable)e);
            return;
        }
    }
}

