/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;
import org.apache.geronimo.console.cli.controller.SelectServer;

public class SelectDistributedModules
extends TextController {
    private static final Log log = LogFactory.getLog((Class)SelectDistributedModules.class);
    private Runner runner;
    private boolean selected;
    private ModuleType type;

    public SelectDistributedModules(DeploymentContext context, Runner runner) {
        super(context);
        this.runner = runner;
    }

    public void execute() {
        block4: while (true) {
            int i;
            this.newScreen("Select Modules to " + this.runner.getAction());
            if (!this.context.connected) {
                this.println("ERROR: cannot " + this.runner.getAction() + " modules in disconnected mode.");
                this.context.targets = new Target[0];
                this.context.modules = new TargetModuleID[0];
                return;
            }
            this.println((this.context.targets.length == 0 ? "No" : String.valueOf(this.context.targets.length)) + " target" + (this.context.targets.length != 1 ? "s" : "") + " currently selected.");
            this.println((this.context.modules.length == 0 ? "No" : String.valueOf(this.context.modules.length)) + " module" + (this.context.modules.length != 1 ? "s" : "") + " currently selected" + (this.context.modules.length > 0 ? ":" : "."));
            for (int i2 = 0; i2 < this.context.modules.length; ++i2) {
                this.println("  " + (i2 + 1) + ") " + this.context.modules[i2]);
            }
            while (true) {
                String choice;
                this.context.out.print("Action (" + (this.context.modules.length > 0 ? "Remove Module [1" + (this.context.modules.length > 1 ? "-" + this.context.modules.length : "") + "], " : "") + "[A]dd Module, manage [T]argets, or [B]ack): ");
                this.context.out.flush();
                try {
                    choice = this.context.in.readLine().trim().toLowerCase();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to read user input", (Throwable)e);
                    return;
                }
                if (choice.equals("a")) {
                    this.executeAdd();
                    continue block4;
                }
                if (choice.equals("b")) {
                    return;
                }
                if (choice.equals("t")) {
                    new SelectServer(this.context).execute();
                    continue block4;
                }
                i = 0;
                try {
                    i = Integer.parseInt(choice);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (i >= 1 && i <= this.context.modules.length) break;
                this.println("  ERROR: There are only " + this.context.modules.length + " module(s) selected");
            }
            TargetModuleID[] list = new TargetModuleID[this.context.modules.length - 1];
            System.arraycopy(this.context.modules, 0, list, 0, i - 1);
            System.arraycopy(this.context.modules, i, list, i - 1, this.context.modules.length - i);
            this.context.modules = list;
        }
    }

    public void executeAdd() {
        this.selected = false;
        block4: while (true) {
            int i;
            TargetModuleID[] available = new TargetModuleID[]{};
            this.newScreen("Add Module");
            if (!this.context.connected) {
                this.println("ERROR: cannot select modules in disconnected mode.");
                return;
            }
            if (this.context.modules.length > 0) {
                this.println("Selected Modules");
                for (int i2 = 0; i2 < this.context.modules.length; ++i2) {
                    this.println("  " + this.context.modules[i2]);
                }
            }
            if (this.selected) {
                available = this.showModules();
                if (!this.context.connected) {
                    return;
                }
            }
            while (true) {
                String choice;
                this.print("List [E]JB, [C]lient, [W]eb app, [R]A, [A]pp, A[L]L modules");
                if (available.length > 0) {
                    this.println("");
                    this.print("  or add Module [1" + (available.length > 1 ? "-" + available.length : "") + "]");
                }
                this.print(" or [B]ack): ");
                this.context.out.flush();
                try {
                    choice = this.context.in.readLine().trim().toLowerCase();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to read user input", (Throwable)e);
                    return;
                }
                if (choice.equals("b")) {
                    return;
                }
                if (choice.equals("e")) {
                    this.selected = true;
                    this.type = ModuleType.EJB;
                    continue block4;
                }
                if (choice.equals("c")) {
                    this.selected = true;
                    this.type = ModuleType.CAR;
                    continue block4;
                }
                if (choice.equals("w")) {
                    this.selected = true;
                    this.type = ModuleType.WAR;
                    continue block4;
                }
                if (choice.equals("r")) {
                    this.selected = true;
                    this.type = ModuleType.RAR;
                    continue block4;
                }
                if (choice.equals("a")) {
                    this.selected = true;
                    this.type = ModuleType.EAR;
                    continue block4;
                }
                if (choice.equals("l")) {
                    this.selected = true;
                    this.type = null;
                    continue block4;
                }
                i = 0;
                try {
                    i = Integer.parseInt(choice);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (i >= 1 && i <= available.length) break;
                this.println("  ERROR: There are only " + available.length + " module(s) available");
            }
            TargetModuleID[] list = new TargetModuleID[this.context.modules.length + 1];
            System.arraycopy(this.context.modules, 0, list, 0, this.context.modules.length);
            list[this.context.modules.length] = available[i - 1];
            this.context.modules = list;
        }
    }

    private TargetModuleID[] showModules() {
        try {
            TargetModuleID[] ids;
            if (this.type != null) {
                ids = this.runner.getModules(this.type, this.context);
            } else {
                ArrayList<TargetModuleID> list = new ArrayList<TargetModuleID>();
                list.addAll(Arrays.asList(this.runner.getModules(ModuleType.CAR, this.context)));
                list.addAll(Arrays.asList(this.runner.getModules(ModuleType.EAR, this.context)));
                list.addAll(Arrays.asList(this.runner.getModules(ModuleType.EJB, this.context)));
                list.addAll(Arrays.asList(this.runner.getModules(ModuleType.RAR, this.context)));
                list.addAll(Arrays.asList(this.runner.getModules(ModuleType.WAR, this.context)));
                ids = list.toArray(new TargetModuleID[list.size()]);
            }
            ids = this.available(ids, this.context.modules);
            this.println(ids.length == 0 ? "No matching modules found." : "Found " + ids.length + " matching module" + (ids.length == 1 ? "" : "s"));
            for (int i = 0; i < ids.length; ++i) {
                this.println("  " + (i + 1) + ") " + ids[i]);
            }
            this.println("");
            return ids;
        }
        catch (TargetException e) {
            this.println("ERROR: " + e.getMessage());
        }
        catch (IllegalStateException e) {
            this.println("ERROR: No longer connected to server.");
            this.context.connected = false;
        }
        return new TargetModuleID[0];
    }

    public static class NonRunningModules
    extends Runner {
        public NonRunningModules(String action) {
            super(action);
        }

        public TargetModuleID[] getModules(ModuleType type, DeploymentContext context) throws TargetException {
            return context.deployer.getNonRunningModules(type, context.targets);
        }
    }

    public static class RunningModules
    extends Runner {
        public RunningModules(String action) {
            super(action);
        }

        public TargetModuleID[] getModules(ModuleType type, DeploymentContext context) throws TargetException {
            return context.deployer.getRunningModules(type, context.targets);
        }
    }

    private static abstract class Runner {
        private final String action;

        public Runner(String action) {
            this.action = action;
        }

        public String getAction() {
            return this.action;
        }

        abstract TargetModuleID[] getModules(ModuleType var1, DeploymentContext var2) throws TargetException;
    }
}

