/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.IOException;
import javax.enterprise.deploy.spi.Target;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;
import org.apache.geronimo.console.cli.controller.AddServer;

public class SelectServer
extends TextController {
    private static final Log log = LogFactory.getLog((Class)SelectServer.class);
    private Target[] all;
    private Target[] available;

    public SelectServer(DeploymentContext context) {
        super(context);
    }

    public void execute() {
        this.all = this.context.deployer.getTargets();
        if (this.all.length == 0) {
            this.println("  ERROR: No targets available.");
            this.println("         Perhaps the deployment manager is not connected?");
            return;
        }
        block4: while (true) {
            int i;
            this.available = this.available(this.all, this.context.targets);
            this.newScreen("Select Targets");
            this.println((this.context.targets.length == 0 ? "No" : String.valueOf(this.context.targets.length)) + " target" + (this.context.targets.length != 1 ? "s" : "") + " currently selected" + (this.context.targets.length > 0 ? ":" : "."));
            for (int i2 = 0; i2 < this.context.targets.length; ++i2) {
                this.println("  " + (i2 + 1) + ") " + this.context.targets[i2].getName() + " (" + this.truncate(this.context.targets[i2].getDescription(), 66 - this.context.targets[i2].getName().length()) + ")");
            }
            while (true) {
                String choice;
                this.context.out.print("Action (" + (this.context.targets.length > 0 ? "Remove Target [1" + (this.context.targets.length > 1 ? "-" + this.context.targets.length : "") + "] or " : "") + (this.available.length > 0 ? "[A]dd Target or " : "") + "[B]ack): ");
                this.context.out.flush();
                try {
                    choice = this.context.in.readLine().trim().toLowerCase();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to read user input", (Throwable)e);
                    return;
                }
                if (choice.equals("a") && this.available.length > 0) {
                    new AddServer(this.context, this.all).execute();
                    continue block4;
                }
                if (choice.equals("b")) {
                    return;
                }
                i = 0;
                try {
                    i = Integer.parseInt(choice);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (i >= 1 && i <= this.context.targets.length) break;
                this.println("  ERROR: There are only " + this.context.targets.length + " target(s) selected");
            }
            Target[] list = new Target[this.context.targets.length - 1];
            System.arraycopy(this.context.targets, 0, list, 0, i - 1);
            System.arraycopy(this.context.targets, i, list, i - 1, this.context.targets.length - i);
            this.context.targets = list;
        }
    }
}

