/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.enterprise.deploy.tool;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.ModuleType;

public abstract class AbstractDeployableObject
implements DeployableObject {
    private JarFile jar;
    private ModuleType type;
    private DDBeanRoot defaultRoot;
    private ClassLoader loader;

    public AbstractDeployableObject(JarFile jar, ModuleType type, DDBeanRoot defaultRoot, ClassLoader loader) {
        this.jar = jar;
        this.type = type;
        this.defaultRoot = defaultRoot;
        this.loader = loader;
    }

    public ModuleType getType() {
        return this.type;
    }

    public DDBeanRoot getDDBeanRoot() {
        return this.defaultRoot;
    }

    public DDBean[] getChildBean(String xpath) {
        return this.defaultRoot.getChildBean(xpath);
    }

    public String[] getText(String xpath) {
        return this.defaultRoot.getText(xpath);
    }

    public Class getClassFromScope(String className) {
        try {
            return this.loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getModuleDTDVersion() {
        return this.defaultRoot.getModuleDTDVersion();
    }

    public Enumeration entries() {
        return new JarEnumerator(this.jar.entries());
    }

    public InputStream getEntry(String name) {
        try {
            return this.jar.getInputStream(this.jar.getEntry(name));
        }
        catch (IOException e) {
            return null;
        }
    }

    private static class JarEnumerator
    implements Enumeration {
        private Enumeration entries;

        public JarEnumerator(Enumeration entries) {
            this.entries = entries;
        }

        public boolean hasMoreElements() {
            return this.entries.hasMoreElements();
        }

        public Object nextElement() {
            return ((JarEntry)this.entries.nextElement()).getName();
        }
    }
}

