/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.validator.ejb;

import java.lang.reflect.Modifier;
import javax.ejb.EJBHome;
import javax.ejb.SessionBean;
import org.apache.geronimo.validator.ValidationContext;
import org.apache.geronimo.validator.ValidationResult;
import org.apache.geronimo.validator.ejb.BaseEjbJarTest;
import org.apache.geronimo.xbeans.j2ee.SessionBeanType;

public class SessionBeanTests
extends BaseEjbJarTest {
    protected SessionBeanType bean;

    public String getXpath() {
        return "/ejb-jar/enterprise-beans/session";
    }

    public ValidationResult initialize(ValidationContext context) {
        this.bean = (SessionBeanType)context.getCurrentNode();
        return super.initialize(context);
    }

    public ValidationResult testBeanImplementationClass() {
        Class cls = this.loadClass(this.bean.getEjbClass().getStringValue(), "Session Bean Implementation Class");
        ValidationResult result = ValidationResult.PASSED;
        if (!Modifier.isPublic(cls.getModifiers())) {
            result = this.error("ejb.impl.not.public", result);
        }
        if (Modifier.isFinal(cls.getModifiers())) {
            result = this.error("ejb.impl.is.final", result);
        }
        if (!SessionBean.class.isAssignableFrom(cls)) {
            result = this.error("ejb.session.impl.wrong.interface", result);
        }
        if (!Modifier.isAbstract(cls.getModifiers())) {
            result = this.error("ejb.session.impl.abstract", result);
        }
        return result;
    }

    public ValidationResult testLocalOrRemote() {
        ValidationResult result = ValidationResult.PASSED;
        if (this.bean.getHome() == null && this.bean.getLocalHome() == null) {
            result = this.error("ejb.no.home.interface", result);
        }
        if (this.bean.getRemote() == null && this.bean.getLocal() == null) {
            result = this.error("ejb.no.component.interface", result);
        }
        return result;
    }

    public ValidationResult testHomeInterface() {
        Class cls;
        ValidationResult result = ValidationResult.PASSED;
        if (this.bean.getHome() == null) {
            return result;
        }
        if (!EJBHome.class.isAssignableFrom(cls = this.loadClass(this.bean.getHome().getStringValue(), "Session Bean Home Class"))) {
            result = this.error("ejb.home.wrong.superclass", result);
        }
        if (!Modifier.isPublic(cls.getModifiers())) {
            result = this.error("ejb.home.not.public", result);
        }
        if (!Modifier.isInterface(cls.getModifiers())) {
            result = this.error("ejb.home.not.interface", result);
        }
        return result;
    }
}

