/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.pool;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;

public class ThreadPool
implements Executor,
GBeanLifecycle {
    private PooledExecutor executor;
    private ClassLoader classLoader;
    public static final GBeanInfo GBEAN_INFO;

    public ThreadPool(int poolSize, String poolName, long keepAliveTime, ClassLoader classLoader) {
        PooledExecutor p = new PooledExecutor(poolSize);
        p.abortWhenBlocked();
        p.setKeepAliveTime(keepAliveTime);
        p.setMinimumPoolSize(poolSize);
        p.setThreadFactory((ThreadFactory)new ThreadPoolThreadFactory(poolName, classLoader));
        this.executor = p;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) throws InterruptedException {
        PooledExecutor p;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            p = this.executor;
        }
        if (p == null) {
            throw new IllegalStateException("ThreadPool has been stopped");
        }
        ContextClassLoaderRunnable task = new ContextClassLoaderRunnable(command, this.classLoader);
        p.execute((Runnable)task);
    }

    public void doStart() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        PooledExecutor p;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            p = this.executor;
            this.executor = null;
            this.classLoader = null;
        }
        if (p != null) {
            p.shutdownNow();
        }
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(ThreadPool.class);
        infoFactory.addAttribute("poolSize", Integer.TYPE, true);
        infoFactory.addAttribute("poolName", String.class, true);
        infoFactory.addAttribute("keepAliveTime", Long.TYPE, true);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addInterface(Executor.class);
        infoFactory.setConstructor(new String[]{"poolSize", "poolName", "keepAliveTime", "classLoader"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static final class ContextClassLoaderRunnable
    implements Runnable {
        private Runnable task;
        private ClassLoader classLoader;

        public ContextClassLoaderRunnable(Runnable task, ClassLoader classLoader) {
            this.task = task;
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Runnable myTask = this.task;
            ClassLoader myClassLoader = this.classLoader;
            this.task = null;
            this.classLoader = null;
            if (myClassLoader != null) {
                try {
                    myTask.run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(myClassLoader);
                }
            }
        }
    }

    private static final class ThreadPoolThreadFactory
    implements ThreadFactory {
        private final String poolName;
        private final ClassLoader classLoader;
        private int nextWorkerID = 0;

        public ThreadPoolThreadFactory(String poolName, ClassLoader classLoader) {
            this.poolName = poolName;
            this.classLoader = classLoader;
        }

        public Thread newThread(Runnable arg0) {
            Thread thread = new Thread(arg0, this.poolName + " " + this.getNextWorkerID());
            thread.setContextClassLoader(this.classLoader);
            return thread;
        }

        private synchronized int getNextWorkerID() {
            return this.nextWorkerID++;
        }
    }
}

