/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.FlowLayout;
import com.izforge.izpack.gui.TwoColumnConstraints;
import com.izforge.izpack.gui.TwoColumnLayout;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.GeronimoConfigProcessor;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.Processor;
import com.izforge.izpack.panels.RuleInputField;
import com.izforge.izpack.panels.VCheckBox;
import com.izforge.izpack.panels.ValidatePackSelectionsAutomationHelper;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.MultiLineLabel;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class ValidatePackSelections
extends IzPanel {
    protected String sTitle = null;
    protected GeronimoConfigProcessor gcp = null;
    protected static boolean fAdvancedMode = false;
    private static final long serialVersionUID = 3257850965439886129L;
    protected static final int POS_SUPPRESS = 0;
    protected static final int POS_DISPLAYED = 1;
    protected static final int POS_TYPE = 2;
    protected static final int POS_VARIABLE = 3;
    protected static final int POS_CONSTRAINTS = 4;
    protected static final int POS_FIELD = 5;
    protected static final int POS_PACKS = 6;
    protected static final int POS_OS = 7;
    protected static final int POS_TRUE = 8;
    protected static final int POS_FALSE = 9;
    protected static final int POS_MESSAGE = 10;
    protected static final int POS_GROUP = 11;
    protected static final String SPEC_FILE_NAME = "userInputSpec.xml";
    protected static final String LANG_FILE_NAME = "userInputLang.xml";
    protected static final String NODE_ID = "panel";
    protected static final String FIELD_NODE_ID = "field";
    protected static final String INSTANCE_IDENTIFIER = "order";
    protected static final String TYPE = "type";
    protected static final String DESCRIPTION = "description";
    protected static final String VARIABLE = "variable";
    protected static final String TEXT = "txt";
    protected static final String KEY = "id";
    protected static final String SPEC = "spec";
    protected static final String SET = "set";
    protected static final String TRUE = "true";
    protected static final String FALSE = "false";
    protected static final String ALIGNMENT = "align";
    protected static final String LEFT = "left";
    protected static final String CENTER = "center";
    protected static final String RIGHT = "right";
    protected static final String TOP = "top";
    protected static final String ITALICS = "italic";
    protected static final String BOLD = "bold";
    protected static final String SIZE = "size";
    protected static final String VALIDATOR = "validator";
    protected static final String PROCESSOR = "processor";
    protected static final String CLASS = "class";
    protected static final String FIELD_LABEL = "label";
    protected static final String TITLE_FIELD = "title";
    protected static final String TEXT_FIELD = "text";
    protected static final String TEXT_SIZE = "size";
    protected static final String STATIC_TEXT = "staticText";
    protected static final String COMBO_FIELD = "combo";
    protected static final String COMBO_CHOICE = "choice";
    protected static final String COMBO_VALUE = "value";
    protected static final String RADIO_FIELD = "radio";
    protected static final String RADIO_CHOICE = "choice";
    protected static final String RADIO_VALUE = "value";
    protected static final String SPACE_FIELD = "space";
    protected static final String DIVIDER_FIELD = "divider";
    protected static final String CHECK_FIELD = "check";
    protected static final String RULE_FIELD = "rule";
    protected static final String RULE_LAYOUT = "layout";
    protected static final String RULE_SEPARATOR = "separator";
    protected static final String RULE_RESULT_FORMAT = "resultFormat";
    protected static final String RULE_PLAIN_STRING = "plainString";
    protected static final String RULE_DISPLAY_FORMAT = "displayFormat";
    protected static final String RULE_SPECIAL_SEPARATOR = "specialSeparator";
    protected static final String RULE_ENCRYPTED = "processed";
    protected static final String RULE_PARAM_NAME = "name";
    protected static final String RULE_PARAM_VALUE = "value";
    protected static final String RULE_PARAM = "param";
    protected static final String PWD_FIELD = "password";
    protected static final String PWD_INPUT = "pwd";
    protected static final String PWD_SIZE = "size";
    protected static final String SEARCH_FIELD = "search";
    protected static final String SEARCH_BUTTON_FIELD = "autodetect";
    protected static final String SEARCH_CHOICE = "choice";
    protected static final String SEARCH_FILENAME = "filename";
    protected static final String SEARCH_RESULT = "result";
    protected static final String SEARCH_VALUE = "value";
    protected static final String SEARCH_TYPE = "type";
    protected static final String SEARCH_FILE = "file";
    protected static final String SEARCH_DIRECTORY = "directory";
    protected static final String SEARCH_PARENTDIR = "parentdir";
    protected static final String SEARCH_CHECKFILENAME = "checkfilename";
    protected static final String SELECTEDPACKS = "createForPack";
    protected static final String UNSELECTEDPACKS = "createForUnselectedPack";
    protected static final String NAME = "name";
    protected static final String OS = "os";
    protected static final String FAMILY = "family";
    protected static final String VALUE = "value";
    protected static final String DEPENDS = "depends";
    protected static final String SUPPRESS = "suppress";
    protected static final String WHEN = "when";
    protected static final String EXCLUSIVE = "exclusiveOf";
    protected static final String AUTO_INSTALL = "AutomatedInstallation";
    protected static final String SELECTED_PACKS = "selected";
    protected static final String PANEL_PKG = "com.izforge.izpack.panels";
    protected static final String PACKS_PANEL = "ImgPacksPanel";
    protected static HashMap varMap;
    protected static boolean fStaticInitComplete;
    protected static int instanceCount;
    protected int instanceNumber = 0;
    protected boolean fInitComplete = false;
    protected boolean packsDefined = false;
    protected InstallerFrame parentFrame;
    protected XMLElement spec;
    protected boolean haveSpec = false;
    protected Vector uiElements = new Vector();
    protected Vector buttonGroups = new Vector();
    protected Vector passwordGroups = new Vector();
    protected Vector passwordGroupsRead = new Vector();
    protected Vector searchFields = new Vector();
    protected TwoColumnLayout layout;
    protected LocaleDatabase langpack = null;
    protected static boolean fHasSetAdvancedMode;

    protected void setTitle(String title) {
        this.sTitle = title;
    }

    protected String getTitle() {
        return this.sTitle;
    }

    public ValidatePackSelections(InstallerFrame parent, InstallData installData) {
        super(parent, installData);
        if (!fHasSetAdvancedMode) {
            String sVal = FALSE;
            if (fAdvancedMode) {
                sVal = TRUE;
            }
            installData.setVariable("advanced.mode", sVal);
            fHasSetAdvancedMode = true;
        }
        this.instanceNumber = instanceCount++;
        this.parentFrame = parent;
        this.gcp = new GeronimoConfigProcessor();
        this.layout = new TwoColumnLayout(10, 5, 30, 25, 0);
        this.setLayout((LayoutManager)this.layout);
        try {
            String resource = "userInputLang.xml_" + this.idata.localeISO3;
            this.langpack = new LocaleDatabase(ResourceManager.getInstance().getInputStream(resource));
        }
        catch (Throwable exception) {
            // empty catch block
        }
        try {
            this.readSpec();
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
        if (!this.haveSpec) {
            return;
        }
        Vector fields = this.spec.getChildrenNamed(FIELD_NODE_ID);
        for (int i = 0; i < fields.size(); ++i) {
            XMLElement field = (XMLElement)fields.elementAt(i);
            String attribute = field.getAttribute("type");
            if (attribute == null) continue;
            if (attribute.equals(RULE_FIELD)) {
                this.addRuleField(field);
                continue;
            }
            if (attribute.equals(TEXT_FIELD)) {
                this.addTextField(field);
                continue;
            }
            if (attribute.equals(COMBO_FIELD)) {
                this.addComboBox(field);
                continue;
            }
            if (attribute.equals(RADIO_FIELD)) {
                this.addRadioButton(field);
                continue;
            }
            if (attribute.equals(PWD_FIELD)) {
                this.addPasswordField(field);
                continue;
            }
            if (attribute.equals(SPACE_FIELD)) {
                this.addSpace(field);
                continue;
            }
            if (attribute.equals(DIVIDER_FIELD)) {
                this.addDivider(field);
                continue;
            }
            if (attribute.equals(CHECK_FIELD)) {
                this.addCheckBox(field);
                continue;
            }
            if (attribute.equals(STATIC_TEXT)) {
                this.addText(field);
                continue;
            }
            if (attribute.equals(TITLE_FIELD)) {
                this.addTitle(field);
                continue;
            }
            if (!attribute.equals(SEARCH_FIELD)) continue;
            this.addSearch(field);
        }
    }

    public boolean isValidated() {
        String panelName = this.getTitle();
        return this.readInput() && this.gcp.checkInput(panelName, (AutomatedInstallData)this.idata);
    }

    public void panelActivate() {
        if (this.spec == null) {
            this.emitError("User input specification could not be found.", "The specification for the user input panel could not be found. Please contact the packager.");
            this.parentFrame.skipPanel();
        }
        if (!fStaticInitComplete) {
            Set keys = varMap.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                String var = (String)iter.next();
                Debug.trace((Object)("varMap: " + var));
                VCheckBox vcb = (VCheckBox)varMap.get(var);
                if (vcb == null) continue;
                vcb.setupDependents();
            }
            fStaticInitComplete = true;
        }
        Vector forPacks = this.spec.getChildrenNamed(SELECTEDPACKS);
        Vector forUnselectedPacks = this.spec.getChildrenNamed(UNSELECTEDPACKS);
        Vector forOs = this.spec.getChildrenNamed(OS);
        if (!(this.itemRequiredFor(forPacks) && this.itemRequiredForUnselected(forUnselectedPacks) && this.itemRequiredForOs(forOs))) {
            this.parentFrame.skipPanel();
            return;
        }
        if (!this.haveSpec) {
            this.parentFrame.skipPanel();
            return;
        }
        String panelName = this.getTitle();
        this.gcp.panelEntryTasks((AutomatedInstallData)this.idata, panelName);
        this.gcp.panelDebug((AutomatedInstallData)this.idata, panelName);
        if (this.gcp.shouldSkipPanel((AutomatedInstallData)this.idata, panelName)) {
            this.parentFrame.skipPanel();
            return;
        }
        this.buildUI();
        if (this.packsDefined) {
            this.parentFrame.lockPrevButton();
        }
        if (this.gcp.isPackSelectionProblem((AutomatedInstallData)this.idata)) {
            this.parentFrame.lockNextButton();
        }
        this.gcp.panelNavDebug((AutomatedInstallData)this.idata);
        if (this.gcp.isCheckpointPanel(panelName)) {
            String[] msgs = new String[]{"Congratulations!", "    Geronimo configuration is complete.", "________________", "Press 'Next' to continue with file installation or,", "    press 'Previous' to review or change configuration", "selections.", "", "", "", "", "", ""};
            if (this.gcp.haveConfigErrors((AutomatedInstallData)this.idata, msgs)) {
                this.parentFrame.lockNextButton();
            }
            int j = 0;
            for (int i = 0; i < 10; ++i) {
                Object[] uiElement = (Object[])this.uiElements.elementAt(i);
                if (i == 99) continue;
                MultiLineLabel label = (MultiLineLabel)uiElement[5];
                label.setText(msgs[j]);
                ++j;
            }
        }
    }

    public void panelDeactivate() {
        if (this.gcp.isCheckpointPanel(this.getTitle())) {
            XMLElement xml = this.idata.xmlData;
            XMLElement panelRoot = null;
            Debug.trace((Object)("-ValidatePackSelections.panelDeactivate() - xml: " + xml.getName()));
            panelRoot = xml.getFirstChildNamed("com.izforge.izpack.panels.ImgPacksPanel");
            if (panelRoot != null) {
                Vector vSel = panelRoot.getChildrenNamed(SELECTED_PACKS);
                for (int i = 0; i < vSel.size(); ++i) {
                    XMLElement sel = (XMLElement)vSel.elementAt(i);
                    Debug.trace((Object)("-ValidatePackSelections.panelDeactivate() - vSel( " + i + " ) = " + sel.toString()));
                }
                int children = panelRoot.getChildrenCount();
                int curChild = 0;
                while (panelRoot.getChildrenCount() > 0) {
                    panelRoot.removeChildAtIndex(0);
                    Debug.trace((Object)("-ValidatePackSelections.panelDeactivate() - removing ImgPack child: " + ++curChild + " of " + children));
                }
                List panels = this.idata.panels;
                Class<?> packsPanelCls = null;
                try {
                    packsPanelCls = Class.forName("com.izforge.izpack.panels.ImgPacksPanel");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                IzPanel packsPanel = null;
                for (int i = 0; i < panels.size() && !packsPanelCls.isInstance(packsPanel = (IzPanel)panels.get(i)); ++i) {
                    packsPanel = null;
                }
                if (packsPanel != null) {
                    Debug.trace((Object)"-ValidatePackSelections.panelDeactivate() - calling ImgPacks panel to make new xml.");
                    packsPanel.makeXMLData(panelRoot);
                }
            }
        }
    }

    public void makeXMLData(XMLElement panelRoot) {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        for (int i = 0; i < this.uiElements.size(); ++i) {
            Object[] uiElement = (Object[])this.uiElements.elementAt(i);
            String var = (String)uiElement[3];
            if (var == null) continue;
            String val = this.idata.getVariable(var);
            if (val != null) {
                Debug.trace((Object)("-makeXMLData(): entryMap.put( " + var + ", " + val + " )"));
                entryMap.put(var, val);
                continue;
            }
            Debug.trace((Object)("-makeXMLData(): entryMap.put( " + var + " was null"));
        }
        new ValidatePackSelectionsAutomationHelper(entryMap, this.getTitle()).makeXMLData((AutomatedInstallData)this.idata, panelRoot);
    }

    protected void buildUI() {
        Object[] uiElement;
        int i;
        for (i = 0; i < this.uiElements.size(); ++i) {
            uiElement = (Object[])this.uiElements.elementAt(i);
            if (this.itemRequiredFor((Vector)uiElement[6]) && this.itemRequiredForOs((Vector)uiElement[7]) && !this.isFieldSuppressed((Vector)uiElement[0])) {
                try {
                    if (uiElement[1] == null) {
                        this.add((JComponent)uiElement[5], uiElement[4]);
                    }
                    uiElement[1] = true;
                    ((JComponent)uiElement[5]).setVisible(true);
                }
                catch (Throwable exception) {
                    System.out.println("Internal format error in field: " + uiElement[2].toString());
                }
                continue;
            }
            try {
                if (uiElement[1] != null && uiElement[1].toString().equals(TRUE)) {
                    ((JComponent)uiElement[5]).setVisible(false);
                    uiElement[1] = false;
                }
                if (uiElement[1] == null) {
                    this.add((JComponent)uiElement[5], uiElement[4]);
                    ((JComponent)uiElement[5]).setVisible(false);
                    uiElement[1] = false;
                }
            }
            catch (Throwable exception) {
                System.out.println("Internal format error in field: " + uiElement[2].toString());
            }
            uiElement[1] = false;
        }
        if (!this.fInitComplete) {
            for (i = 0; i < this.uiElements.size(); ++i) {
                uiElement = (Object[])this.uiElements.elementAt(i);
                Object uiComp = uiElement[5];
                if (!(uiComp instanceof VCheckBox)) continue;
                VCheckBox vcb = (VCheckBox)uiComp;
                vcb.setValidStates();
            }
        }
    }

    protected boolean readInput() {
        String fieldType = null;
        Object[] field = null;
        this.passwordGroupsRead.clear();
        for (int i = 0; i < this.uiElements.size(); ++i) {
            boolean success;
            field = (Object[])this.uiElements.elementAt(i);
            if (field == null || !((Boolean)field[1]).booleanValue()) continue;
            fieldType = (String)field[2];
            if (fieldType.equals(RULE_FIELD) && !(success = this.readRuleField(field))) {
                return false;
            }
            if (!(fieldType.equals(PWD_FIELD) ? !(success = this.readPasswordField(field)) : (fieldType.equals(TEXT_FIELD) ? !(success = this.readTextField(field)) : (fieldType.equals(COMBO_FIELD) ? !(success = this.readComboBox(field)) : (fieldType.equals(RADIO_FIELD) ? !(success = this.readRadioButton(field)) : (fieldType.equals(CHECK_FIELD) ? !(success = this.readCheckBox(field)) : fieldType.equals(SEARCH_FIELD) && !(success = this.readSearch(field)))))))) continue;
            return false;
        }
        return true;
    }

    protected void readSpec() throws Exception {
        InputStream input = null;
        String instance = Integer.toString(this.instanceNumber);
        try {
            input = this.parentFrame.getResource(SPEC_FILE_NAME);
        }
        catch (Exception exception) {
            this.haveSpec = false;
            return;
        }
        if (input == null) {
            this.haveSpec = false;
            return;
        }
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder((IXMLBuilder)new StdXMLBuilder());
        parser.setValidator((IXMLValidator)new NonValidator());
        parser.setReader((IXMLReader)new StdXMLReader(input));
        XMLElement data = (XMLElement)parser.parse();
        if (data.hasChildren()) {
            Vector specElements = data.getChildrenNamed(NODE_ID);
            for (int i = 0; i < specElements.size(); ++i) {
                data = (XMLElement)specElements.elementAt(i);
                String attribute = data.getAttribute(INSTANCE_IDENTIFIER);
                if (!instance.equals(attribute)) continue;
                this.spec = data;
                input.close();
                this.haveSpec = true;
                return;
            }
            this.haveSpec = false;
            return;
        }
        this.haveSpec = false;
    }

    protected void addTitle(XMLElement spec) {
        String title = this.getText(spec);
        this.setTitle(title);
        boolean italic = this.getBoolean(spec, ITALICS, false);
        boolean bold = this.getBoolean(spec, BOLD, false);
        float multiplier = this.getFloat(spec, "size", 2.0f);
        int justify = this.getAlignment(spec);
        if (title != null) {
            JLabel label = new JLabel(title);
            Font font = label.getFont();
            float size = font.getSize();
            int style = 0;
            if (bold) {
                ++style;
            }
            if (italic) {
                style += 2;
            }
            font = font.deriveFont(style, size * multiplier);
            label.setFont(font);
            label.setAlignmentX(0.0f);
            TwoColumnConstraints constraints = new TwoColumnConstraints();
            constraints.align = justify;
            constraints.position = 9;
            this.add(label, constraints);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addRuleField(XMLElement spec) {
        void var7_16;
        void var10_19;
        void var9_18;
        void var8_17;
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        XMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute(VARIABLE);
        RuleInputField field = null;
        String validator = null;
        String message = null;
        boolean hasParams = false;
        String paramName = null;
        String paramValue = null;
        HashMap<String, String> validateParamMap = null;
        Vector validateParams = null;
        String processor = null;
        int resultFormat = 2;
        if (element != null) {
            JLabel label = new JLabel(this.getText(element));
            String layout = element.getAttribute(RULE_LAYOUT);
            String set = element.getAttribute(SET);
            String separator = element.getAttribute(RULE_SEPARATOR);
            String format = element.getAttribute(RULE_RESULT_FORMAT);
            if (format != null) {
                if (format.equals(RULE_PLAIN_STRING)) {
                    resultFormat = 1;
                } else if (format.equals(RULE_DISPLAY_FORMAT)) {
                    resultFormat = 2;
                } else if (format.equals(RULE_SPECIAL_SEPARATOR)) {
                    resultFormat = 3;
                } else if (format.equals(RULE_ENCRYPTED)) {
                    resultFormat = 4;
                }
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs, null);
        element = spec.getFirstChildNamed(VALIDATOR);
        if (element != null) {
            validator = element.getAttribute(CLASS);
            message = this.getText(element);
            validateParams = element.getChildrenNamed(RULE_PARAM);
            if (validateParams != null && validateParams.size() > 0 && validateParamMap == null) {
                validateParamMap = new HashMap<String, String>();
                hasParams = true;
            }
            Iterator it = validateParams.iterator();
            while (it.hasNext()) {
                element = (XMLElement)it.next();
                paramName = element.getAttribute("name");
                paramValue = element.getAttribute("value");
                validateParamMap.put(paramName, paramValue);
            }
        }
        if ((element = spec.getFirstChildNamed(PROCESSOR)) != null) {
            processor = element.getAttribute(CLASS);
        }
        field = hasParams ? new RuleInputField((String)var8_17, (String)var9_18, (String)var10_19, validator, validateParamMap, processor, resultFormat, this.getToolkit(), this.idata) : new RuleInputField((String)var8_17, (String)var9_18, (String)var10_19, validator, processor, resultFormat, this.getToolkit(), this.idata);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        this.uiElements.add(new Object[]{null, null, FIELD_LABEL, null, constraints, var7_16, forPacks, forOs});
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        this.uiElements.add(new Object[]{null, null, RULE_FIELD, variable, constraints2, field, forPacks, forOs, null, null, message});
    }

    protected boolean readRuleField(Object[] field) {
        RuleInputField ruleField = null;
        String variable = null;
        try {
            ruleField = (RuleInputField)field[5];
            variable = (String)field[3];
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || ruleField == null) {
            return true;
        }
        boolean success = ruleField.validateContents();
        if (!success) {
            String message = "";
            try {
                message = this.langpack.getString((String)field[10]);
                if (message.equals("")) {
                    message = (String)field[10];
                }
            }
            catch (Throwable t) {
                message = (String)field[10];
            }
            JOptionPane.showMessageDialog((Component)this.parentFrame, message, this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
            return false;
        }
        this.idata.setVariable(variable, ruleField.getText());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void addTextField(XMLElement spec) {
        void var5_6;
        void var7_10;
        void var6_7;
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        XMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute(VARIABLE);
        if (variable == null || variable.length() == 0) {
            return;
        }
        if (element != null) {
            int size;
            JLabel label = new JLabel(this.getText(element));
            String set = element.getAttribute(SET);
            if (set == null) {
                set = this.idata.getVariable(variable);
                if (set == null) {
                    set = "";
                }
            } else if (set != null && !"".equals(set)) {
                VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                set = vs.substitute(set, null);
            }
            try {
                size = Integer.parseInt(element.getAttribute("size"));
            }
            catch (Throwable exception) {
                size = 1;
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs, null);
        JTextField field = new JTextField((String)var6_7, (int)var7_10);
        field.setCaretPosition(0);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        this.uiElements.add(new Object[]{null, null, FIELD_LABEL, null, constraints, var5_6, forPacks, forOs});
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        this.uiElements.add(new Object[]{null, null, TEXT_FIELD, variable, constraints2, field, forPacks, forOs});
    }

    protected boolean readTextField(Object[] field) {
        JTextField textField = null;
        String variable = null;
        String value = null;
        try {
            textField = (JTextField)field[5];
            variable = (String)field[3];
            value = textField.getText();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        return true;
    }

    protected void addComboBox(XMLElement spec) {
        JLabel label;
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        XMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute(VARIABLE);
        TextValuePair listItem = null;
        JComboBox<TextValuePair> field = new JComboBox<TextValuePair>();
        if (element != null) {
            label = new JLabel(this.getText(element));
            Vector choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            for (int i = 0; i < choices.size(); ++i) {
                String processorClass = ((XMLElement)choices.elementAt(i)).getAttribute(PROCESSOR);
                if (processorClass != null && !"".equals(processorClass)) {
                    String choiceValues = "";
                    try {
                        choiceValues = ((Processor)Class.forName(processorClass).newInstance()).process(null);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    String set = ((XMLElement)choices.elementAt(i)).getAttribute(SET);
                    if (set == null) {
                        set = "";
                    }
                    if (set != null && !"".equals(set)) {
                        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    StringTokenizer tokenizer = new StringTokenizer(choiceValues, ":");
                    int counter = 0;
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        listItem = new TextValuePair(token, token);
                        field.addItem(listItem);
                        if (set.equals(token)) {
                            field.setSelectedIndex(field.getItemCount() - 1);
                        }
                        ++counter;
                    }
                    continue;
                }
                listItem = new TextValuePair(this.getText((XMLElement)choices.elementAt(i)), ((XMLElement)choices.elementAt(i)).getAttribute("value"));
                field.addItem(listItem);
                String set = ((XMLElement)choices.elementAt(i)).getAttribute(SET);
                if (set == null) continue;
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    set = vs.substitute(set, null);
                }
                if (!set.equals(TRUE)) continue;
                field.setSelectedIndex(i);
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs, null);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 15;
        this.uiElements.add(new Object[]{null, null, FIELD_LABEL, null, constraints, label, forPacks, forOs});
        TwoColumnConstraints constraints2 = new TwoColumnConstraints();
        constraints2.position = 26;
        this.uiElements.add(new Object[]{null, null, COMBO_FIELD, variable, constraints2, field, forPacks, forOs});
    }

    protected boolean readComboBox(Object[] field) {
        String value;
        String variable;
        try {
            variable = (String)field[3];
            JComboBox comboBox = (JComboBox)field[5];
            value = ((TextValuePair)comboBox.getSelectedItem()).getValue();
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        return true;
    }

    protected void addRadioButton(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        String variable = spec.getAttribute(VARIABLE);
        String value = null;
        XMLElement element = null;
        ButtonGroup group = new ButtonGroup();
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.indent = true;
        constraints.stretch = true;
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs, null);
        element = spec.getFirstChildNamed(SPEC);
        if (element != null) {
            Vector choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            for (int i = 0; i < choices.size(); ++i) {
                JRadioButton choice = new JRadioButton();
                choice.setText(this.getText((XMLElement)choices.elementAt(i)));
                value = ((XMLElement)choices.elementAt(i)).getAttribute("value");
                group.add(choice);
                String set = ((XMLElement)choices.elementAt(i)).getAttribute(SET);
                if (set != null) {
                    if (set != null && !"".equals(set)) {
                        VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                        set = vs.substitute(set, null);
                    }
                    if (set.equals(TRUE)) {
                        choice.setSelected(true);
                    }
                }
                this.buttonGroups.add(group);
                this.uiElements.add(new Object[]{null, null, RADIO_FIELD, variable, constraints, choice, forPacks, forOs, value, null, null, group});
            }
        }
    }

    protected boolean readRadioButton(Object[] field) {
        String variable = null;
        String value = null;
        JRadioButton button = null;
        try {
            button = (JRadioButton)field[5];
            if (!button.isSelected()) {
                return true;
            }
            variable = (String)field[3];
            value = (String)field[8];
        }
        catch (Throwable exception) {
            return true;
        }
        this.idata.setVariable(variable, value);
        return true;
    }

    protected void addPasswordField(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        String variable = spec.getAttribute(VARIABLE);
        String validator = null;
        String message = null;
        String processor = null;
        XMLElement element = null;
        PasswordGroup group = null;
        int size = 0;
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs, null);
        element = spec.getFirstChildNamed(VALIDATOR);
        if (element != null) {
            validator = element.getAttribute(CLASS);
            message = this.getText(element);
        }
        if ((element = spec.getFirstChildNamed(PROCESSOR)) != null) {
            processor = element.getAttribute(CLASS);
        }
        group = new PasswordGroup(validator, processor);
        element = spec.getFirstChildNamed(SPEC);
        if (element != null) {
            Vector inputs = element.getChildrenNamed(PWD_INPUT);
            if (inputs == null) {
                return;
            }
            for (int i = 0; i < inputs.size(); ++i) {
                XMLElement fieldSpec = (XMLElement)inputs.elementAt(i);
                String set = fieldSpec.getAttribute(SET);
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    set = vs.substitute(set, null);
                }
                JLabel label = new JLabel(this.getText(fieldSpec));
                try {
                    size = Integer.parseInt(fieldSpec.getAttribute("size"));
                }
                catch (Throwable exception) {
                    size = 1;
                }
                JPasswordField field = new JPasswordField(set, size);
                field.setCaretPosition(0);
                TwoColumnConstraints constraints = new TwoColumnConstraints();
                constraints.position = 15;
                this.uiElements.add(new Object[]{null, null, FIELD_LABEL, null, constraints, label, forPacks, forOs});
                TwoColumnConstraints constraints2 = new TwoColumnConstraints();
                constraints2.position = 26;
                this.uiElements.add(new Object[]{null, null, PWD_FIELD, variable, constraints2, field, forPacks, forOs, null, null, message, group});
                group.addField(field);
            }
        }
        this.passwordGroups.add(group);
    }

    protected boolean readPasswordField(Object[] field) {
        PasswordGroup group = null;
        String variable = null;
        String message = null;
        try {
            group = (PasswordGroup)field[11];
            variable = (String)field[3];
            message = (String)field[10];
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || this.passwordGroupsRead.contains(group)) {
            return true;
        }
        this.passwordGroups.add(group);
        boolean success = group.validateContents();
        if (!success) {
            JOptionPane.showMessageDialog((Component)this.parentFrame, message, this.parentFrame.langpack.getString("UserInputPanel.error.caption"), 2);
            return false;
        }
        this.idata.setVariable(variable, group.getPassword());
        return true;
    }

    protected boolean isFieldSuppressed(Vector suppressions) {
        boolean fRet = false;
        for (int i = 0; suppressions != null && i < suppressions.size(); ++i) {
            TextValuePair tvp = (TextValuePair)suppressions.elementAt(i);
            String var = tvp.toString();
            String val = this.idata.getVariable(var);
            if (!val.equalsIgnoreCase(tvp.getValue())) continue;
            fRet = true;
            break;
        }
        return fRet;
    }

    protected Vector getFieldSuppressionList(XMLElement spec) {
        Vector<TextValuePair> supps = null;
        XMLElement suppress = spec.getFirstChildNamed(SUPPRESS);
        if (suppress != null) {
            Vector whens = suppress.getChildrenNamed(WHEN);
            for (int i = 0; i < whens.size(); ++i) {
                if (supps == null) {
                    supps = new Vector<TextValuePair>();
                }
                XMLElement when = (XMLElement)whens.elementAt(i);
                String var = when.getAttribute(VARIABLE);
                String val = when.getAttribute("value");
                supps.add(new TextValuePair(var, val));
            }
        }
        return supps;
    }

    protected void addCheckBox(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        String label = "";
        String set = null;
        String trueValue = null;
        String falseValue = null;
        String variable = spec.getAttribute(VARIABLE);
        XMLElement detail = spec.getFirstChildNamed(SPEC);
        Vector suppress = this.getFieldSuppressionList(spec);
        if (variable == null) {
            return;
        }
        if (detail != null) {
            label = this.getText(detail);
            set = detail.getAttribute(SET);
            trueValue = detail.getAttribute(TRUE);
            falseValue = detail.getAttribute(FALSE);
        }
        VCheckBox checkbox = new VCheckBox(label, varMap, this.idata, spec);
        if (set != null) {
            if (set != null && !"".equals(set)) {
                VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                set = vs.substitute(set, null);
            }
            if (set.equals(FALSE)) {
                checkbox.setSelected(false);
            }
            if (set.equals(TRUE)) {
                checkbox.setSelected(true);
            }
        }
        XMLElement element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs, suppress);
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        constraints.indent = true;
        this.uiElements.add(new Object[]{suppress, null, CHECK_FIELD, variable, constraints, checkbox, forPacks, forOs, trueValue, falseValue});
    }

    protected boolean readCheckBox(Object[] field) {
        String variable = null;
        String trueValue = null;
        String falseValue = null;
        JCheckBox box = null;
        try {
            box = (JCheckBox)field[5];
            variable = (String)field[3];
            trueValue = (String)field[8];
            if (trueValue == null) {
                trueValue = "";
            }
            if ((falseValue = (String)field[9]) == null) {
                falseValue = "";
            }
        }
        catch (Throwable exception) {
            return true;
        }
        if (box.isSelected()) {
            this.idata.setVariable(variable, trueValue);
        } else {
            this.idata.setVariable(variable, falseValue);
        }
        return true;
    }

    protected void addSearch(XMLElement spec) {
        boolean showAutodetect;
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        XMLElement element = spec.getFirstChildNamed(SPEC);
        String variable = spec.getAttribute(VARIABLE);
        String filename = null;
        String check_filename = null;
        int search_type = 0;
        int result_type = 0;
        JComboBox<String> combobox = new JComboBox<String>();
        JLabel label = null;
        combobox.setEditable(true);
        if (element != null) {
            String result_type_str;
            label = new JLabel(this.getText(element));
            search_type = 2;
            String search_type_str = element.getAttribute("type");
            if (search_type_str != null) {
                if (search_type_str.equals(SEARCH_FILE)) {
                    search_type = 2;
                } else if (search_type_str.equals(SEARCH_DIRECTORY)) {
                    search_type = 1;
                }
            }
            if ((result_type_str = element.getAttribute(SEARCH_RESULT)) == null) {
                return;
            }
            if (result_type_str.equals(SEARCH_FILE)) {
                result_type = 2;
            } else if (result_type_str.equals(SEARCH_DIRECTORY)) {
                result_type = 1;
            } else if (result_type_str.equals(SEARCH_PARENTDIR)) {
                result_type = 3;
            } else {
                return;
            }
            filename = element.getAttribute(SEARCH_FILENAME);
            check_filename = element.getAttribute(SEARCH_CHECKFILENAME);
            Vector choices = element.getChildrenNamed("choice");
            if (choices == null) {
                return;
            }
            for (int i = 0; i < choices.size(); ++i) {
                XMLElement choice_el = (XMLElement)choices.elementAt(i);
                if (!OsConstraint.oneMatchesCurrentSystem((XMLElement)choice_el)) continue;
                String value = choice_el.getAttribute("value");
                combobox.addItem(value);
                String set = ((XMLElement)choices.elementAt(i)).getAttribute(SET);
                if (set == null) continue;
                if (set != null && !"".equals(set)) {
                    VariableSubstitutor vs = new VariableSubstitutor(this.idata.getVariables());
                    set = vs.substitute(set, null);
                }
                if (!set.equals(TRUE)) continue;
                combobox.setSelectedIndex(i);
            }
        } else {
            return;
        }
        element = spec.getFirstChildNamed(DESCRIPTION);
        this.addDescription(element, forPacks, forOs, null);
        TwoColumnConstraints westconstraint1 = new TwoColumnConstraints();
        westconstraint1.position = 15;
        this.uiElements.add(new Object[]{null, null, FIELD_LABEL, null, westconstraint1, label, forPacks, forOs});
        TwoColumnConstraints eastconstraint1 = new TwoColumnConstraints();
        eastconstraint1.position = 26;
        StringBuffer tooltiptext = new StringBuffer();
        if (filename != null && filename.length() > 0) {
            tooltiptext.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location"), filename));
        }
        boolean bl = showAutodetect = check_filename != null && check_filename.length() > 0;
        if (showAutodetect) {
            tooltiptext.append(MessageFormat.format(this.parentFrame.langpack.getString("UserInputPanel.search.location.checkedfile"), check_filename));
        }
        if (tooltiptext.length() > 0) {
            combobox.setToolTipText(tooltiptext.toString());
        }
        this.uiElements.add(new Object[]{null, null, SEARCH_FIELD, variable, eastconstraint1, combobox, forPacks, forOs});
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout((LayoutManager)new FlowLayout(3));
        JButton autodetectButton = ButtonFactory.createButton((String)this.parentFrame.langpack.getString("UserInputPanel.search.autodetect"), (Color)this.idata.buttonsHColor);
        autodetectButton.setVisible(showAutodetect);
        autodetectButton.setToolTipText(this.parentFrame.langpack.getString("UserInputPanel.search.autodetect.tooltip"));
        buttonPanel.add(autodetectButton);
        JButton browseButton = ButtonFactory.createButton((String)this.parentFrame.langpack.getString("UserInputPanel.search.browse"), (Color)this.idata.buttonsHColor);
        buttonPanel.add(browseButton);
        TwoColumnConstraints eastonlyconstraint = new TwoColumnConstraints();
        eastonlyconstraint.position = 27;
        this.uiElements.add(new Object[]{null, null, SEARCH_BUTTON_FIELD, null, eastonlyconstraint, buttonPanel, forPacks, forOs});
        this.searchFields.add(new SearchField(filename, check_filename, this.parentFrame, combobox, autodetectButton, browseButton, search_type, result_type));
    }

    protected boolean readSearch(Object[] field) {
        String variable = null;
        String value = null;
        JComboBox comboBox = null;
        try {
            variable = (String)field[3];
            comboBox = (JComboBox)field[5];
            for (int i = 0; i < this.searchFields.size(); ++i) {
                SearchField sf = (SearchField)this.searchFields.elementAt(i);
                if (!sf.belongsTo(comboBox)) continue;
                value = sf.getResult();
                break;
            }
        }
        catch (Throwable exception) {
            return true;
        }
        if (variable == null || value == null) {
            return true;
        }
        this.idata.setVariable(variable, value);
        return true;
    }

    protected void addText(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        Vector suppress = this.getFieldSuppressionList(spec);
        this.addDescription(spec, forPacks, forOs, suppress);
    }

    protected void addSpace(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        JPanel panel = new JPanel();
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        this.uiElements.add(new Object[]{null, null, SPACE_FIELD, null, constraints, panel, forPacks, forOs});
    }

    protected void addDivider(XMLElement spec) {
        Vector forPacks = spec.getChildrenNamed(SELECTEDPACKS);
        Vector forOs = spec.getChildrenNamed(OS);
        JPanel panel = new JPanel();
        String alignment = spec.getAttribute(ALIGNMENT);
        if (alignment != null) {
            if (alignment.equals(TOP)) {
                panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
            } else {
                panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            }
        } else {
            panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        }
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        this.uiElements.add(new Object[]{null, null, DIVIDER_FIELD, null, constraints, panel, forPacks, forOs});
    }

    protected void addDescription(XMLElement spec, Vector forPacks, Vector forOs, Vector suppress) {
        String description;
        TwoColumnConstraints constraints = new TwoColumnConstraints();
        constraints.position = 29;
        constraints.stretch = true;
        if (spec != null && (description = this.getText(spec)) != null) {
            String alignment = spec.getAttribute(ALIGNMENT);
            int justify = 0;
            if (alignment != null) {
                if (alignment.equals(LEFT)) {
                    justify = 0;
                } else if (alignment.equals(CENTER)) {
                    justify = 1;
                } else if (alignment.equals(RIGHT)) {
                    justify = 2;
                }
            }
            MultiLineLabel label = new MultiLineLabel(description, justify);
            this.uiElements.add(new Object[]{suppress, null, DESCRIPTION, null, constraints, label, forPacks, forOs});
        }
    }

    protected boolean getBoolean(XMLElement element, String attribute, boolean defaultValue) {
        String value;
        boolean result = defaultValue;
        if (attribute != null && attribute.length() > 0 && (value = element.getAttribute(attribute)) != null) {
            if (value.equals(TRUE)) {
                result = true;
            } else if (value.equals(FALSE)) {
                result = false;
            }
        }
        return result;
    }

    protected float getFloat(XMLElement element, String attribute, float defaultValue) {
        float result = defaultValue;
        if (attribute != null && attribute.length() > 0) {
            try {
                result = Float.parseFloat(element.getAttribute(attribute));
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected String getText(XMLElement element) {
        if (element == null) {
            return null;
        }
        String key = element.getAttribute(KEY);
        String text = null;
        if (key != null && this.langpack != null) {
            try {
                text = this.langpack.getString(key);
            }
            catch (Throwable exception) {
                text = null;
            }
        }
        if (text == null) {
            text = element.getAttribute(TEXT);
        }
        return text;
    }

    protected int getAlignment(XMLElement element) {
        int result = 31;
        String value = element.getAttribute(ALIGNMENT);
        if (value != null) {
            if (value.equals(LEFT)) {
                result = 31;
            } else if (value.equals(CENTER)) {
                result = 35;
            } else if (value.equals(RIGHT)) {
                result = 47;
            }
        }
        return result;
    }

    public boolean itemRequiredForOs(Vector os) {
        if (os.size() == 0) {
            return true;
        }
        int i = 0;
        if (i < os.size()) {
            String family = ((XMLElement)os.elementAt(i)).getAttribute(FAMILY);
            boolean match = false;
            if (family.equals("windows")) {
                match = OsVersion.IS_WINDOWS;
            } else if (family.equals("mac")) {
                match = OsVersion.IS_OSX;
            } else if (family.equals("unix")) {
                match = OsVersion.IS_UNIX;
            }
            return match;
        }
        return false;
    }

    protected boolean itemRequiredFor(Vector packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = ((XMLElement)packs.elementAt(k)).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean itemRequiredForUnselected(Vector packs) {
        if (packs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.idata.selectedPacks.size(); ++i) {
            String selected = ((Pack)this.idata.selectedPacks.get((int)i)).name;
            for (int k = 0; k < packs.size(); ++k) {
                String required = ((XMLElement)packs.elementAt(k)).getAttribute("name", "");
                if (!selected.equals(required)) continue;
                return false;
            }
        }
        return true;
    }

    protected Vector getUiElements() {
        return this.uiElements;
    }

    static {
        Properties props = System.getProperties();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String am;
            String name = (String)names.nextElement();
            if (!name.equalsIgnoreCase("advancedmode") || (am = props.getProperty(name)) == null || !am.equalsIgnoreCase(TRUE)) continue;
            fAdvancedMode = true;
        }
        varMap = new HashMap();
        fStaticInitComplete = false;
        instanceCount = 0;
        fHasSetAdvancedMode = false;
    }

    protected class SearchField
    implements ActionListener {
        public static final int TYPE_DIRECTORY = 1;
        public static final int TYPE_FILE = 2;
        public static final int RESULT_DIRECTORY = 1;
        public static final int RESULT_FILE = 2;
        public static final int RESULT_PARENTDIR = 3;
        protected String filename = null;
        protected String checkFilename = null;
        protected JButton autodetectButton = null;
        protected JButton browseButton = null;
        protected JComboBox pathComboBox = null;
        protected int searchType = 1;
        protected int resultType = 1;
        protected InstallerFrame parent = null;

        public SearchField(String filename, String checkFilename, InstallerFrame parent, JComboBox combobox, JButton autobutton, JButton browsebutton, int search_type, int result_type) {
            this.filename = filename;
            this.checkFilename = checkFilename;
            this.parent = parent;
            this.autodetectButton = autobutton;
            this.browseButton = browsebutton;
            this.pathComboBox = combobox;
            this.searchType = search_type;
            this.resultType = result_type;
            this.autodetectButton.addActionListener(this);
            this.browseButton.addActionListener(this);
            this.autodetect();
        }

        public boolean belongsTo(JComboBox combobox) {
            return this.pathComboBox == combobox;
        }

        protected boolean pathMatches(String path) {
            if (path != null) {
                File file = null;
                file = this.filename == null || this.searchType == 1 ? new File(path) : new File(path, this.filename);
                if (file.exists() && (this.searchType == 1 && file.isDirectory() || this.searchType == 2 && file.isFile())) {
                    if (this.checkFilename == null) {
                        return true;
                    }
                    file = new File(file, this.checkFilename);
                    return file.exists();
                }
            }
            return false;
        }

        public boolean autodetect() {
            int i;
            Vector<String> items = new Vector<String>();
            String selected = (String)this.pathComboBox.getSelectedItem();
            boolean found = false;
            for (int x = 0; x < this.pathComboBox.getItemCount(); ++x) {
                if (!((String)this.pathComboBox.getItemAt(x)).equals(selected)) continue;
                found = true;
            }
            if (!found) {
                this.pathComboBox.addItem(this.pathComboBox.getSelectedItem());
            }
            for (int i2 = 0; i2 < this.pathComboBox.getItemCount(); ++i2) {
                String path = (String)this.pathComboBox.getItemAt(i2);
                if (path.endsWith("*")) {
                    File dir = new File(path = path.substring(0, path.length() - 1));
                    if (!dir.isDirectory()) continue;
                    File[] subdirs = dir.listFiles();
                    for (int x = 0; x < subdirs.length; ++x) {
                        String search = subdirs[x].getAbsolutePath();
                        if (!this.pathMatches(search)) continue;
                        items.add(search);
                    }
                    continue;
                }
                if (!this.pathMatches(path)) continue;
                items.add(path);
            }
            items = new Vector(new HashSet(items));
            this.pathComboBox.removeAllItems();
            VariableSubstitutor vs = new VariableSubstitutor(ValidatePackSelections.this.idata.getVariables());
            for (i = 0; i < items.size(); ++i) {
                this.pathComboBox.addItem(vs.substitute((String)items.get(i), "plain"));
            }
            for (i = 0; i < this.pathComboBox.getItemCount(); ++i) {
                String path = (String)this.pathComboBox.getItemAt(i);
                if (!this.pathMatches(path)) continue;
                this.pathComboBox.setSelectedIndex(i);
                return true;
            }
            return this.pathMatches((String)this.pathComboBox.getSelectedItem());
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.autodetectButton) {
                if (!this.autodetect()) {
                    JOptionPane.showMessageDialog((Component)this.parent, this.parent.langpack.getString("UserInputPanel.search.autodetect.failed.message"), this.parent.langpack.getString("UserInputPanel.search.autodetect.failed.caption"), 2);
                }
            } else if (event.getSource() == this.browseButton) {
                int result;
                JFileChooser chooser = new JFileChooser();
                if (this.searchType == 1) {
                    chooser.setFileSelectionMode(1);
                }
                if ((result = chooser.showOpenDialog((Component)this.parent)) == 0) {
                    File f = chooser.getSelectedFile();
                    this.pathComboBox.setSelectedItem(f.getAbsolutePath());
                    if (!this.pathMatches(f.getAbsolutePath())) {
                        JOptionPane.showMessageDialog((Component)this.parent, this.parent.langpack.getString("UserInputPanel.search.wrongselection.message"), this.parent.langpack.getString("UserInputPanel.search.wrongselection.caption"), 2);
                    }
                }
            }
        }

        public String getResult() {
            String item = (String)this.pathComboBox.getSelectedItem();
            if (item != null) {
                item = item.trim();
            }
            String path = item;
            File f = new File(item);
            if (!f.isDirectory()) {
                path = f.getParent();
            }
            if (this.resultType == 1) {
                return path;
            }
            if (this.resultType == 2) {
                if (this.filename != null) {
                    return path + File.separatorChar + this.filename;
                }
                return item;
            }
            if (this.resultType == 3) {
                File dir = new File(path);
                return dir.getParent();
            }
            return null;
        }
    }

    protected static class TextValuePair {
        private String text = "";
        private String value = "";

        public TextValuePair(String text, String value) {
            this.text = text;
            this.value = value;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.text;
        }

        public String getValue() {
            return this.value;
        }
    }
}

