/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import com.izforge.izpack.panels.GeronimoConfigProcessor;
import com.izforge.izpack.util.Debug;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class ValidatePackSelectionsAutomationHelper
implements PanelAutomation {
    private static final String AUTO_KEY_USER_INPUT = "userInput";
    private static final String AUTO_ATTR_PANEL_NAME = "panelName";
    private static final String AUTO_KEY_ENTRY = "entry";
    private static final String AUTO_ATTRIBUTE_KEY = "key";
    private static final String AUTO_ATTRIBUTE_VALUE = "value";
    private Map entries;
    private String panelName = null;

    public ValidatePackSelectionsAutomationHelper() {
        this.entries = null;
    }

    public ValidatePackSelectionsAutomationHelper(Map entries, String panelName) {
        this.panelName = panelName;
        this.entries = entries;
    }

    public void makeXMLData(AutomatedInstallData idata, XMLElement panelRoot) {
        XMLElement userInput = new XMLElement(AUTO_KEY_USER_INPUT);
        userInput.setAttribute(AUTO_ATTR_PANEL_NAME, this.panelName);
        Vector panels = panelRoot.getChildrenNamed(AUTO_KEY_USER_INPUT);
        for (int i = 0; i < panels.size(); ++i) {
            panelRoot.removeChild((XMLElement)panels.elementAt(i));
        }
        panelRoot.addChild(userInput);
        Iterator keys = this.entries.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = (String)this.entries.get(key);
            XMLElement dataElement = new XMLElement(AUTO_KEY_ENTRY);
            dataElement.setAttribute(AUTO_ATTRIBUTE_KEY, key);
            dataElement.setAttribute(AUTO_ATTRIBUTE_VALUE, value);
            userInput.addChild(dataElement);
        }
    }

    public void runAutomated(AutomatedInstallData idata, XMLElement panelRoot) {
        Vector userEntries;
        XMLElement userInput = panelRoot.getFirstChildNamed(AUTO_KEY_USER_INPUT);
        if (userInput == null) {
            return;
        }
        String panelName = userInput.getAttribute(AUTO_ATTR_PANEL_NAME);
        if (panelName == null) {
            System.out.println("Auto-installation will fail. Panel name not set in xml");
        }
        if ((userEntries = userInput.getChildrenNamed(AUTO_KEY_ENTRY)) == null) {
            return;
        }
        for (int i = 0; i < userEntries.size(); ++i) {
            XMLElement dataElement = (XMLElement)userEntries.elementAt(i);
            String variable = dataElement.getAttribute(AUTO_ATTRIBUTE_KEY);
            String value = dataElement.getAttribute(AUTO_ATTRIBUTE_VALUE);
            Debug.trace((Object)("ValidatePackSelections: setting variable " + variable + " to " + value));
            idata.setVariable(variable, value);
        }
        GeronimoConfigProcessor gcp = new GeronimoConfigProcessor();
        gcp.processAutomatedInput(idata, panelName);
    }
}

