/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarOutputStream;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Reference;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.j2ee.deployment.AmbiguousEJBRefException;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.UnknownEJBRefException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;

public class EARContext
extends DeploymentContext
implements EJBReferenceBuilder {
    private final Map ejbRefs = new HashMap();
    private final Map ejbLocalRefs = new HashMap();
    private final Map resourceAdapterModules = new HashMap();
    private final Map activationSpecInfos = new HashMap();
    private final String j2eeDomainName;
    private final String j2eeServerName;
    private final String j2eeApplicationName;
    private final ObjectName domainObjectName;
    private final ObjectName serverObjectName;
    private final ObjectName applicationObjectName;
    private final ObjectName transactionContextManagerObjectName;
    private final ObjectName connectionTrackerObjectName;
    private final ObjectName transactedTimerName;
    private final ObjectName nonTransactedTimerName;
    private final EJBReferenceBuilder ejbReferenceBuilder;

    public EARContext(JarOutputStream jos, URI id, ConfigurationModuleType moduleType, URI parentID, Kernel kernel, String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, ObjectName transactionContextManagerObjectName, ObjectName connectionTrackerObjectName, ObjectName transactedTimerName, ObjectName nonTransactedTimerName, EJBReferenceBuilder ejbReferenceBuilder) throws MalformedObjectNameException, DeploymentException {
        super(jos, id, moduleType, parentID, kernel);
        this.j2eeDomainName = j2eeDomainName;
        this.j2eeServerName = j2eeServerName;
        if (j2eeApplicationName == null) {
            j2eeApplicationName = "null";
        }
        this.j2eeApplicationName = j2eeApplicationName;
        Properties domainNameProps = new Properties();
        domainNameProps.put("j2eeType", "J2EEDomain");
        domainNameProps.put("name", j2eeDomainName);
        try {
            this.domainObjectName = new ObjectName(j2eeDomainName, domainNameProps);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Unable to construct J2EEDomain ObjectName", (Throwable)e);
        }
        Properties serverNameProps = new Properties();
        serverNameProps.put("j2eeType", "J2EEServer");
        serverNameProps.put("name", j2eeServerName);
        try {
            this.serverObjectName = new ObjectName(j2eeDomainName, serverNameProps);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Unable to construct J2EEServer ObjectName", (Throwable)e);
        }
        if (!j2eeApplicationName.equals("null")) {
            Properties applicationNameProps = new Properties();
            applicationNameProps.put("j2eeType", "J2EEApplication");
            applicationNameProps.put("name", j2eeApplicationName);
            applicationNameProps.put("J2EEServer", j2eeServerName);
            try {
                this.applicationObjectName = new ObjectName(j2eeDomainName, applicationNameProps);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("Unable to construct J2EEApplication ObjectName", (Throwable)e);
            }
        } else {
            this.applicationObjectName = null;
        }
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactedTimerName = transactedTimerName;
        this.nonTransactedTimerName = nonTransactedTimerName;
        this.ejbReferenceBuilder = ejbReferenceBuilder;
    }

    public String getJ2EEDomainName() {
        return this.j2eeDomainName;
    }

    public String getJ2EEServerName() {
        return this.j2eeServerName;
    }

    public String getJ2EEApplicationName() {
        return this.j2eeApplicationName;
    }

    public ObjectName getDomainObjectName() {
        return this.domainObjectName;
    }

    public ObjectName getServerObjectName() {
        return this.serverObjectName;
    }

    public ObjectName getApplicationObjectName() {
        return this.applicationObjectName;
    }

    public ObjectName getTransactionContextManagerObjectName() {
        return this.transactionContextManagerObjectName;
    }

    public ObjectName getConnectionTrackerObjectName() {
        return this.connectionTrackerObjectName;
    }

    public ObjectName getTransactedTimerName() {
        return this.transactedTimerName;
    }

    public ObjectName getNonTransactedTimerName() {
        return this.nonTransactedTimerName;
    }

    public void addEJBRef(URI modulePath, String name, Object reference) throws DeploymentException {
        HashMap references = (HashMap)this.ejbRefs.get(name);
        if (references == null || references.isEmpty()) {
            references = new HashMap();
            this.ejbRefs.put(name, references);
        }
        this.addRef(modulePath, name, reference, references);
    }

    public void addEJBLocalRef(URI modulePath, String name, Object reference) throws DeploymentException {
        HashMap references = (HashMap)this.ejbLocalRefs.get(name);
        if (references == null || references.isEmpty()) {
            references = new HashMap();
            this.ejbLocalRefs.put(name, references);
        }
        this.addRef(modulePath, name, reference, references);
    }

    private void addRef(URI modulePath, String name, Object reference, Map references) throws DeploymentException {
        try {
            URI ejbURI = new URI(null, null, modulePath.getPath(), name);
            references.put(ejbURI, reference);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public Object getEJBRef(URI module, String ejbLink) throws DeploymentException {
        String name = ejbLink.substring(ejbLink.lastIndexOf(35) + 1);
        return this.getRef(module, ejbLink, (Map)this.ejbRefs.get(name));
    }

    public Object getEJBLocalRef(URI module, String ejbLink) throws DeploymentException {
        String name = ejbLink.substring(ejbLink.lastIndexOf(35) + 1);
        return this.getRef(module, ejbLink, (Map)this.ejbLocalRefs.get(name));
    }

    private Object getRef(URI module, String ejbLink, Map references) throws AmbiguousEJBRefException, UnknownEJBRefException {
        if (references == null || references.isEmpty()) {
            throw new UnknownEJBRefException(ejbLink);
        }
        if (ejbLink.indexOf(35) < 0) {
            if (references.size() != 1) {
                Object ejbRef = references.get(module.resolve("#" + ejbLink));
                if (ejbRef == null) {
                    throw new AmbiguousEJBRefException(ejbLink);
                }
                return ejbRef;
            }
            Object ejbRef = references.values().iterator().next();
            if (ejbRef == null) {
                throw new UnknownEJBRefException(ejbLink);
            }
            return ejbRef;
        }
        URI ejbURI = module.resolve(ejbLink).normalize();
        Object ejbRef = references.get(ejbURI);
        if (ejbRef == null) {
            throw new UnknownEJBRefException(ejbLink);
        }
        return ejbRef;
    }

    public void addResourceAdapter(String resourceAdapterName, String resourceAdapterModule, Map activationSpecInfoMap) {
        this.resourceAdapterModules.put(resourceAdapterName, resourceAdapterModule);
        this.activationSpecInfos.put(resourceAdapterName, activationSpecInfoMap);
    }

    public Object getActivationSpecInfo(String resourceAdapterName, String activationSpecClassName) {
        Map activationSpecInfoMap = (Map)this.activationSpecInfos.get(resourceAdapterName);
        Object activationSpecInfo = activationSpecInfoMap.get(activationSpecClassName);
        return activationSpecInfo;
    }

    public String getResourceAdapterModule(String resourceAdapterName) {
        return (String)this.resourceAdapterModules.get(resourceAdapterName);
    }

    public Reference createEJBLocalReference(String objectName, boolean isSession, String localHome, String local) throws DeploymentException {
        if (this.ejbReferenceBuilder != null) {
            return this.ejbReferenceBuilder.createEJBLocalReference(objectName, isSession, localHome, local);
        }
        throw new DeploymentException("No ejb reference builder");
    }

    public Reference createEJBRemoteReference(String objectName, boolean isSession, String home, String remote) throws DeploymentException {
        if (this.ejbReferenceBuilder != null) {
            return this.ejbReferenceBuilder.createEJBRemoteReference(objectName, isSession, home, remote);
        }
        throw new DeploymentException("No ejb reference builder");
    }
}

