/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import [Ljava.lang.String;;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.j2ee.management.J2EEServer;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class J2EEApplicationImpl {
    private final String deploymentDescriptor;
    private final String baseName;
    private final Kernel kernel;
    private final J2EEServer server;
    public static final GBeanInfo GBEAN_INFO;

    public J2EEApplicationImpl(Kernel kernel, String objectName, J2EEServer server, String deploymentDescriptor) {
        ObjectName myObjectName = JMXUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        Hashtable<String, String> keyPropertyList = myObjectName.getKeyPropertyList();
        String name = keyPropertyList.get("name");
        String j2eeServerName = keyPropertyList.get("J2EEServer");
        this.baseName = myObjectName.getDomain() + ":J2EEServer=" + j2eeServerName + ",J2EEApplication=" + name + ",";
        this.kernel = kernel;
        this.server = server;
        this.deploymentDescriptor = deploymentDescriptor;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"J2EEApplication".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("J2EEApplication object name j2eeType property must be 'J2EEApplication'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("J2EEApplication object must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("J2EEApplication object name must contain a J2EEServer property", objectName);
        }
        if (keyPropertyList.size() != 3) {
            throw new InvalidObjectNameException("J2EEApplication object name can only have j2eeType, name, and J2EEServer properties", objectName);
        }
    }

    public String[] getmodules() throws MalformedObjectNameException {
        return Util.getObjectNames(this.kernel, this.baseName, new String[]{"AppClientModule", "EJBModule", "WebModule", "ResourceAdapterModule"});
    }

    public String getdeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getserver() {
        return this.server.getobjectName();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(J2EEApplicationImpl.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addReference("j2eeServer", J2EEServer.class);
        infoFactory.addAttribute("deploymentDescriptor", String.class, true);
        infoFactory.addAttribute("modules", String;.class, false);
        infoFactory.setConstructor(new String[]{"kernel", "objectName", "j2eeServer", "deploymentDescriptor"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

