/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import [Ljava.lang.String;;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class J2EEServerImpl {
    private static final String SERVER_VENDOR = "The Apache Software Foundation";
    private final Kernel kernel;
    private final String baseName;
    private final ServerInfo serverInfo;
    public static final GBeanInfo GBEAN_INFO;

    public J2EEServerImpl(Kernel kernel, String objectName, ServerInfo serverInfo) {
        ObjectName myObjectName = JMXUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        Hashtable<String, String> keyPropertyList = myObjectName.getKeyPropertyList();
        String name = keyPropertyList.get("name");
        this.baseName = myObjectName.getDomain() + ":J2EEServer=" + name + ",";
        this.kernel = kernel;
        this.serverInfo = serverInfo;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"J2EEServer".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("J2EEServer object name j2eeType property must be 'J2EEServer'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("J2EEServer object must contain a J2EEServer property", objectName);
        }
        if (keyPropertyList.size() != 2) {
            throw new InvalidObjectNameException("J2EEServer object name can only have j2eeType, and name", objectName);
        }
    }

    public String[] getdeployedObjects() throws MalformedObjectNameException {
        return Util.getObjectNames(this.kernel, this.baseName, new String[]{"J2EEApplication", "AppClientModule", "EJBModule", "WebModule", "ResourceAdapterModule"});
    }

    public String[] getresources() throws MalformedObjectNameException {
        return Util.getObjectNames(this.kernel, this.baseName, new String[]{"JavaMailResource", "JCAConnectionFactory", "JDBCResource", "JDBCDriver", "JMSResource", "JNDIResource", "JTAResource", "RMI_IIOPResource", "URLResource"});
    }

    public String[] getjavaVMs() throws MalformedObjectNameException {
        return Util.getObjectNames(this.kernel, this.baseName, new String[]{"JVM"});
    }

    public String getserverVendor() {
        return SERVER_VENDOR;
    }

    public String getserverVersion() {
        return this.serverInfo.getVersion();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(J2EEServerImpl.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("deployedObjects", String;.class, false);
        infoFactory.addAttribute("resources", String;.class, false);
        infoFactory.addAttribute("javaVMs", String;.class, false);
        infoFactory.addAttribute("serverVendor", String.class, false);
        infoFactory.addAttribute("serverVersion", String.class, false);
        infoFactory.addReference("ServerInfo", ServerInfo.class);
        infoFactory.setConstructor(new String[]{"kernel", "objectName", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

