/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.j2eeobjectnames;

import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;

public class NameFactory {
    public static String J2EE_SERVER = "J2EEServer";
    public static String J2EE_APPLICATION = "J2EEApplication";
    public static String J2EE_MODULE = "J2EEModule";
    public static String J2EE_TYPE = "j2eeType";
    public static String J2EE_NAME = "name";
    public static String J2EE_DOMAIN = "J2EEDomain";
    public static String JVM = "JVM";
    public static String APP_CLIENT_MODULE = "AppClientModule";
    public static String EJB = "EJB";
    public static String EJB_MODULE = "EJBModule";
    public static String MESSAGE_DRIVEN_BEAN = "MessageDrivenBean";
    public static String ENTITY_BEAN = "EntityBean";
    public static String STATEFUL_SESSION_BEAN = "StatefulSessionBean";
    public static String STATELESS_SESSION_BEAN = "StatelessSessionBean";
    public static String WEB_MODULE = "WebModule";
    public static String SERVLET = "Servlet";
    public static String RESOURCE_ADAPTER_MODULE = "ResourceAdapterModule";
    public static String RESOURCE_ADAPTER = "ResourceAdapter";
    public static String JAVA_MAIL_RESOURCE = "JavaMailResource";
    public static String JCA_RESOURCE = "JCAResource";
    public static String JCA_CONNECTION_FACTORY = "JCAConnectionFactory";
    public static String JCA_MANAGED_CONNECTION_FACTORY = "JCAManagedConnectionFactory";
    public static String JDBC_RESOURCE = "JDBCResource";
    public static String JDBC_DATASOURCE = "JDBCDataSource";
    public static String JDBC_DRIVER = "JDBCDriver";
    public static String JMS_RESOURCE = "JMSResource";
    public static String JNDI_RESOURCE = "JNDIResource";
    public static String JTA_RESOURCE = "JTAResource";
    public static String RMI_IIOP_RESOURCE = "RMI_IIOPResource";
    public static String URL_RESOURCE = "URLResource";
    public static String NULL = "null";
    public static final String JCA_ADMIN_OBJECT = "JCAAdminObject";
    public static final String JCA_ACTIVATION_SPEC = "JCAActivationSpec";
    public static final String JCA_RESOURCE_ADAPTER = "JCAResourceAdapter";
    public static final String JCA_WORK_MANAGER = "JCAWorkManager";
    public static final String JCA_CONNECTION_MANAGER = "JCAConnectionManager";

    public static ObjectName getDomainName(String j2eeDomainName, J2eeContext context) throws MalformedObjectNameException {
        Properties props = new Properties();
        props.put(J2EE_TYPE, J2EE_DOMAIN);
        props.put(J2EE_NAME, context.getJ2eeDomainName(j2eeDomainName));
        return ObjectName.getInstance(context.getJ2eeDomainName(j2eeDomainName), props);
    }

    public static ObjectName getServerName(String j2eeDomainName, String j2eeServerName, J2eeContext context) throws MalformedObjectNameException {
        Properties props = new Properties();
        props.put(J2EE_TYPE, J2EE_SERVER);
        props.put(J2EE_NAME, context.getJ2eeServerName(j2eeServerName));
        return ObjectName.getInstance(context.getJ2eeDomainName(j2eeDomainName), props);
    }

    public static ObjectName getApplicationName(String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, J2eeContext context) throws MalformedObjectNameException {
        Properties props = new Properties();
        props.put(J2EE_TYPE, J2EE_APPLICATION);
        props.put(J2EE_SERVER, context.getJ2eeServerName(j2eeServerName));
        props.put(J2EE_NAME, context.getJ2eeApplicationName(j2eeApplicationName));
        return ObjectName.getInstance(context.getJ2eeDomainName(j2eeDomainName), props);
    }

    public static ObjectName getModuleName(String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, String j2eeModuleName, String j2eeType, J2eeContext context) throws MalformedObjectNameException {
        Properties props = new Properties();
        props.put(J2EE_TYPE, j2eeType);
        props.put(J2EE_SERVER, context.getJ2eeServerName(j2eeServerName));
        props.put(J2EE_APPLICATION, context.getJ2eeApplicationName(j2eeApplicationName));
        props.put(J2EE_NAME, context.getJ2eeModuleName(j2eeModuleName));
        return ObjectName.getInstance(context.getJ2eeDomainName(j2eeDomainName), props);
    }

    public static ObjectName getEjbComponentName(String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, String j2eeModuleName, String j2eeName, String j2eeType, J2eeContext context) throws MalformedObjectNameException {
        Properties props = new Properties();
        props.put(J2EE_TYPE, context.getJ2eeType(j2eeType));
        props.put(J2EE_SERVER, context.getJ2eeServerName(j2eeServerName));
        props.put(J2EE_APPLICATION, context.getJ2eeApplicationName(j2eeApplicationName));
        props.put(EJB_MODULE, context.getJ2eeModuleName(j2eeModuleName));
        props.put(J2EE_NAME, context.getJ2eeName(j2eeName));
        return ObjectName.getInstance(context.getJ2eeDomainName(j2eeDomainName), props);
    }

    public static String getEjbComponentNameString(String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, String j2eeModuleName, String j2eeName, String j2eeType, J2eeContext context) throws MalformedObjectNameException {
        return NameFactory.getEjbComponentName(j2eeDomainName, j2eeServerName, j2eeApplicationName, j2eeModuleName, j2eeName, j2eeType, context).getCanonicalName();
    }

    public static ObjectName getResourceComponentName(String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, String j2eeModuleName, String j2eeName, String j2eeType, J2eeContext context) throws MalformedObjectNameException {
        Properties props = new Properties();
        props.put(J2EE_TYPE, context.getJ2eeType(j2eeType));
        props.put(J2EE_SERVER, context.getJ2eeServerName(j2eeServerName));
        props.put(J2EE_APPLICATION, context.getJ2eeApplicationName(j2eeApplicationName));
        props.put(JCA_RESOURCE, context.getJ2eeModuleName(j2eeModuleName));
        props.put(J2EE_NAME, context.getJ2eeName(j2eeName));
        return ObjectName.getInstance(context.getJ2eeDomainName(j2eeDomainName), props);
    }

    public static String getResourceComponentNameString(String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, String j2eeModuleName, String j2eeName, String j2eeType, J2eeContext context) throws MalformedObjectNameException {
        return NameFactory.getResourceComponentName(j2eeDomainName, j2eeServerName, j2eeApplicationName, j2eeModuleName, j2eeName, j2eeType, context).getCanonicalName();
    }

    public static ObjectName getComponentRestrictedQueryName(String j2eeDomainName, String j2eeServerName, String j2eeName, String j2eeType, J2eeContext context) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer(context.getJ2eeDomainName(j2eeDomainName)).append(":" + J2EE_TYPE + "=").append(context.getJ2eeType(j2eeType)).append("," + J2EE_SERVER + "=").append(context.getJ2eeServerName(j2eeServerName)).append("," + J2EE_APPLICATION + "=" + NULL).append("," + J2EE_NAME + "=").append(context.getJ2eeName(j2eeName)).append(",*");
        return new ObjectName(buffer.toString());
    }

    public static ObjectName getWebComponentName(String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, String j2eeModuleName, String j2eeName, String j2eeType, J2eeContext context) throws MalformedObjectNameException {
        Properties props = new Properties();
        props.put(J2EE_TYPE, context.getJ2eeType(j2eeType));
        props.put(J2EE_SERVER, context.getJ2eeServerName(j2eeServerName));
        props.put(J2EE_APPLICATION, context.getJ2eeApplicationName(j2eeApplicationName));
        props.put(WEB_MODULE, context.getJ2eeModuleName(j2eeModuleName));
        props.put(J2EE_NAME, context.getJ2eeName(j2eeName));
        return ObjectName.getInstance(context.getJ2eeDomainName(j2eeDomainName), props);
    }

    public static String getWebComponentNameString(String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, String j2eeModuleName, String j2eeName, String j2eeType, J2eeContext context) throws MalformedObjectNameException {
        return NameFactory.getResourceComponentName(j2eeDomainName, j2eeServerName, j2eeApplicationName, j2eeModuleName, j2eeName, j2eeType, context).getCanonicalName();
    }

    public static ObjectName getComponentName(String j2eeDomainName, String j2eeServerName, String j2eeName, String j2eeType, J2eeContext context) throws MalformedObjectNameException {
        Properties props = new Properties();
        props.put(J2EE_TYPE, context.getJ2eeType(j2eeType));
        props.put(J2EE_SERVER, context.getJ2eeServerName(j2eeServerName));
        props.put(J2EE_NAME, context.getJ2eeName(j2eeName));
        return ObjectName.getInstance(context.getJ2eeDomainName(j2eeDomainName), props);
    }
}

