/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import [Ljava.lang.String;;
import java.util.Hashtable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;

public class J2EEDomainImpl {
    private final Kernel kernel;
    private final String baseName;
    public static final GBeanInfo GBEAN_INFO;

    public J2EEDomainImpl(Kernel kernel, String objectName) {
        ObjectName myObjectName = JMXUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        this.baseName = myObjectName.getDomain() + ":";
        this.kernel = kernel;
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"J2EEDomain".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("J2EEDomain object name j2eeType property must be 'J2EEDomain'", objectName);
        }
        String name = keyPropertyList.get("name");
        if (!objectName.getDomain().equals(name)) {
            throw new InvalidObjectNameException("Domain part of J2EEDomain object name must match name propert", objectName);
        }
    }

    public String[] getservers() throws MalformedObjectNameException {
        return Util.getObjectNames(this.kernel, this.baseName, new String[]{"J2EEServer"});
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(J2EEDomainImpl.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("servers", String;.class, false);
        infoFactory.setConstructor(new String[]{"kernel", "objectName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

