/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.management.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.j2ee.management.geronimo.JVM;

public class JVMImpl
implements JVM {
    public static final String JAVA_VERSION;
    public static final String JAVA_VENDOR;
    public static final String NODE;
    private static final Runtime runtime;
    private final String objectName;
    public static final GBeanInfo GBEAN_INFO;

    public JVMImpl(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public String getJavaVersion() {
        return JAVA_VERSION;
    }

    public String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public String getNode() {
        return NODE;
    }

    public long getFreeMemory() {
        return runtime.freeMemory();
    }

    public long getMaxMemory() {
        return runtime.maxMemory();
    }

    public long getTotalMemory() {
        return runtime.totalMemory();
    }

    public int getAvailableProcessors() {
        return runtime.availableProcessors();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        String node;
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VENDOR = System.getProperty("java.vendor");
        runtime = Runtime.getRuntime();
        try {
            node = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            node = null;
        }
        NODE = node;
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(JVMImpl.class, NameFactory.JVM);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("javaVersion", String.class, false);
        infoFactory.addAttribute("javaVendor", String.class, false);
        infoFactory.addAttribute("node", String.class, false);
        infoFactory.addAttribute("freeMemory", Long.TYPE, false);
        infoFactory.addAttribute("maxMemory", Long.TYPE, false);
        infoFactory.addAttribute("totalMemory", Long.TYPE, false);
        infoFactory.addAttribute("availableProcessors", Integer.TYPE, false);
        infoFactory.setConstructor(new String[]{"objectName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

