/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.jacc.WebRoleRefPermission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.jetty.JAASJettyPrincipal;
import org.apache.geronimo.jetty.JettyServletHolder;
import org.apache.geronimo.jetty.interceptor.SecurityContextBeforeAfter;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.realm.providers.CertificateCallbackHandler;
import org.apache.geronimo.security.realm.providers.PasswordCallbackHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.UserRealm;

public class JAASJettyRealm
implements UserRealm {
    private static Log log = LogFactory.getLog((Class)JAASJettyRealm.class);
    private final String realmName;
    private final String loginDomainName;
    private final HashMap userMap = new HashMap();

    public JAASJettyRealm(String realmName, String loginDomainName) {
        this.realmName = realmName;
        this.loginDomainName = loginDomainName;
    }

    public String getName() {
        return this.realmName;
    }

    public Principal getPrincipal(String username) {
        return (Principal)this.userMap.get(username);
    }

    /*
     * WARNING - void declaration
     */
    public Principal authenticate(String username, Object credentials, HttpRequest request) {
        try {
            void var5_7;
            PasswordCallbackHandler callbackHandler;
            char[] password;
            JAASJettyPrincipal userPrincipal = (JAASJettyPrincipal)this.userMap.get(username);
            if (userPrincipal != null) {
                this.userMap.remove(username);
            }
            if (credentials instanceof char[]) {
                password = (char[])credentials;
                callbackHandler = new PasswordCallbackHandler(username, password);
            } else if (credentials instanceof String) {
                password = ((String)credentials).toCharArray();
                callbackHandler = new PasswordCallbackHandler(username, password);
            } else if (credentials instanceof X509Certificate[]) {
                X509Certificate[] certs = (X509Certificate[])credentials;
                if (certs.length < 1) {
                    throw new LoginException("no certificates supplied");
                }
                callbackHandler = new CertificateCallbackHandler(certs[0]);
            } else {
                throw new LoginException("Cannot extract credentials from class: " + credentials.getClass().getName());
            }
            LoginContext loginContext = new LoginContext(this.loginDomainName, (CallbackHandler)var5_7);
            loginContext.login();
            var5_7.clear();
            Subject subject = ContextManager.getServerSideSubject((Subject)loginContext.getSubject());
            ContextManager.setCurrentCaller((Subject)subject);
            userPrincipal = new JAASJettyPrincipal(username);
            userPrincipal.setSubject(subject);
            this.userMap.put(username, userPrincipal);
            return userPrincipal;
        }
        catch (LoginException e) {
            log.info((Object)"problem", (Throwable)e);
            return null;
        }
    }

    public void logout(Principal user) {
        JAASJettyPrincipal principal = (JAASJettyPrincipal)user;
        this.userMap.remove(principal.getName());
        ContextManager.unregisterSubject((Subject)principal.getSubject());
    }

    public boolean reauthenticate(Principal user) {
        ContextManager.setCurrentCaller((Subject)((JAASJettyPrincipal)user).getSubject());
        return this.userMap.get(user.getName()) != null;
    }

    public void disassociate(Principal user) {
    }

    public boolean isUserInRole(Principal user, String role) {
        if (user == null || role == null) {
            return false;
        }
        AccessControlContext acc = ContextManager.getCurrentContext();
        try {
            acc.checkPermission((Permission)new WebRoleRefPermission(JettyServletHolder.getCurrentServletName(), role));
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    public Principal pushRole(Principal user, String role) {
        ((JAASJettyPrincipal)user).push(ContextManager.getCurrentCaller());
        ContextManager.setCurrentCaller((Subject)SecurityContextBeforeAfter.getCurrentRoleDesignate(role));
        return user;
    }

    public Principal popRole(Principal user) {
        ContextManager.setCurrentCaller((Subject)((JAASJettyPrincipal)user).pop());
        return user;
    }
}

