/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.Server;

public class JettyServer
extends Server {
    private final Map realmDelegates = new HashMap();

    public UserRealm addRealm(UserRealm realm) {
        RealmDelegate delegate = (RealmDelegate)this.realmDelegates.get(realm.getName());
        if (delegate == null) {
            delegate = new RealmDelegate(realm.getName());
            this.realmDelegates.put(realm.getName(), delegate);
        }
        delegate.delegate = realm;
        return delegate;
    }

    public UserRealm getRealm(String realmName) {
        RealmDelegate delegate = (RealmDelegate)this.realmDelegates.get(realmName);
        if (delegate == null) {
            delegate = new RealmDelegate(realmName);
            this.realmDelegates.put(realmName, delegate);
        }
        return delegate;
    }

    public void removeRealm(UserRealm realm) {
        this.realmDelegates.remove(realm.getName());
    }

    private class RealmDelegate
    implements UserRealm {
        private UserRealm delegate;
        private final String name;

        private RealmDelegate(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Principal getPrincipal(String username) {
            return this.delegate.getPrincipal(username);
        }

        public Principal authenticate(String username, Object credentials, HttpRequest request) {
            return this.delegate.authenticate(username, credentials, request);
        }

        public boolean reauthenticate(Principal user) {
            return this.delegate.reauthenticate(user);
        }

        public boolean isUserInRole(Principal user, String role) {
            return this.delegate.isUserInRole(user, role);
        }

        public void disassociate(Principal user) {
            this.delegate.disassociate(user);
        }

        public Principal pushRole(Principal user, String role) {
            return this.delegate.pushRole(user, role);
        }

        public Principal popRole(Principal user) {
            return this.delegate.popRole(user);
        }

        public void logout(Principal user) {
            this.delegate.logout(user);
        }
    }
}

