/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.jetty.JettyServletRegistration;
import org.mortbay.jetty.servlet.ServletHolder;

public class JettyServletHolder
extends ServletHolder {
    private static final ThreadLocal currentServletName = new ThreadLocal();
    public static final GBeanInfo GBEAN_INFO;

    public JettyServletHolder() {
    }

    public JettyServletHolder(String servletName, String servletClassName, String jspFile, Map initParams, Integer loadOnStartup, Set servletMappings, Map webRoleRefPermissions, ServletHolder previous, JettyServletRegistration context) throws Exception {
        super(context == null ? null : context.getServletHandler(), servletName, servletClassName, jspFile);
        if (context != null) {
            this.putAll(initParams);
            if (loadOnStartup != null) {
                this.setInitOrder(loadOnStartup);
            }
            context.registerServletHolder(this, servletName, servletMappings, webRoleRefPermissions == null ? Collections.EMPTY_MAP : webRoleRefPermissions);
        }
    }

    public String getServletName() {
        return this.getName();
    }

    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        JettyServletHolder.setCurrentServletName(this.getServletName());
        super.handle(request, response);
    }

    static String getCurrentServletName() {
        return (String)currentServletName.get();
    }

    static void setCurrentServletName(String servletName) {
        currentServletName.set(servletName);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(JettyServletHolder.class, NameFactory.DEFAULT_SERVLET);
        infoBuilder.addInterface(ServletHolder.class);
        infoBuilder.addAttribute("servletName", String.class, true);
        infoBuilder.addAttribute("servletClass", String.class, true);
        infoBuilder.addAttribute("jspFile", String.class, true);
        infoBuilder.addAttribute("initParams", Map.class, true);
        infoBuilder.addAttribute("loadOnStartup", Integer.class, true);
        infoBuilder.addAttribute("servletMappings", Set.class, true);
        infoBuilder.addAttribute("webRoleRefPermissions", Map.class, true);
        infoBuilder.addReference("Previous", ServletHolder.class, NameFactory.SERVLET);
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class, NameFactory.WEB_MODULE);
        infoBuilder.setConstructor(new String[]{"servletName", "servletClass", "jspFile", "initParams", "loadOnStartup", "servletMappings", "webRoleRefPermissions", "Previous", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

