/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.connector;

import javax.net.ssl.KeyManagerFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.connector.JettyConnector;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SslListener;

public class HTTPSConnector
extends JettyConnector {
    private final SslListener https;
    private final ServerInfo serverInfo;
    private String keystore;
    private String algorithm;
    public static final GBeanInfo GBEAN_INFO;

    public HTTPSConnector(JettyContainer container, ServerInfo serverInfo) {
        super(container, (HttpListener)new SslListener());
        this.serverInfo = serverInfo;
        this.https = (SslListener)this.listener;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        if (algorithm == null) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        this.https.setAlgorithm(algorithm);
    }

    public void setPassword(String password) {
        this.https.setPassword(password);
    }

    public void setKeyPassword(String password) {
        this.https.setKeyPassword(password);
    }

    public String getProtocol() {
        return this.https.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.https.setProtocol(protocol);
    }

    public String getKeystoreType() {
        return this.https.getKeystoreType();
    }

    public void setKeystoreType(String keystoreType) {
        this.https.setKeystoreType(keystoreType);
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.https.setNeedClientAuth(needClientAuth);
    }

    public boolean getNeedClientAuth() {
        return this.https.getNeedClientAuth();
    }

    public void doStart() throws Exception {
        this.https.setKeystore(this.serverInfo.resolvePath(this.keystore));
        super.doStart();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("Jetty Connector HTTPS", HTTPSConnector.class, JettyConnector.GBEAN_INFO);
        infoFactory.addAttribute("keystore", String.class, true);
        infoFactory.addAttribute("algorithm", String.class, true);
        infoFactory.addAttribute("keyPassword", String.class, true);
        infoFactory.addAttribute("keystoreType", String.class, true);
        infoFactory.addAttribute("needClientAuth", Boolean.TYPE, true);
        infoFactory.addAttribute("password", String.class, true);
        infoFactory.addAttribute("protocol", String.class, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.setConstructor(new String[]{"JettyContainer", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

