/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.connector;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty.JettyContainer;
import org.mortbay.http.HttpListener;
import org.mortbay.util.ThreadedServer;

public abstract class JettyConnector
implements GBeanLifecycle {
    private final JettyContainer container;
    protected final HttpListener listener;
    public static final GBeanInfo GBEAN_INFO;

    public JettyConnector() {
        this.container = null;
        this.listener = null;
    }

    public JettyConnector(JettyContainer container) {
        this.container = container;
        this.listener = null;
    }

    public JettyConnector(JettyContainer container, HttpListener listener) {
        this.container = container;
        this.listener = listener;
    }

    public String getDefaultScheme() {
        return this.listener.getDefaultScheme();
    }

    public String getHost() {
        return this.listener.getHost();
    }

    public void setHost(String host) throws UnknownHostException {
        this.listener.setHost(host);
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public void setPort(int port) {
        this.listener.setPort(port);
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public void doStart() throws Exception {
        this.container.addListener(this.listener);
        ((ThreadedServer)this.listener).open();
        this.listener.start();
    }

    public void doStop() {
        while (true) {
            try {
                this.listener.stop();
                this.container.removeListener(this.listener);
                return;
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    public void doFail() {
        while (true) {
            try {
                this.listener.stop();
                this.container.removeListener(this.listener);
                return;
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("Jetty HTTP Connector", JettyConnector.class);
        infoFactory.addAttribute("defaultScheme", String.class, false);
        infoFactory.addAttribute("host", String.class, true);
        infoFactory.addAttribute("port", Integer.TYPE, true);
        infoFactory.addAttribute("address", InetSocketAddress.class, false);
        infoFactory.addReference("JettyContainer", JettyContainer.class, "GBean");
        infoFactory.setConstructor(new String[]{"JettyContainer"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

