/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.net.URL;
import java.net.URLClassLoader;

public class JettyClassLoader
extends URLClassLoader {
    private final boolean contextPriorityClassLoader;
    private final ClassLoader parent;
    private final ClassLoader resourceClassLoader;

    public JettyClassLoader(URL[] urls, URL resourceURL, ClassLoader parent, boolean contextPriorityClassLoader) {
        super(urls, parent);
        URL[] resourceURLS;
        if (parent == null) {
            throw new IllegalArgumentException("Parent class loader is null");
        }
        if (resourceURL != null) {
            resourceURLS = new URL[urls.length + 1];
            System.arraycopy(urls, 0, resourceURLS, 0, urls.length);
            resourceURLS[resourceURLS.length - 1] = resourceURL;
        } else {
            resourceURLS = urls;
        }
        this.resourceClassLoader = new ResourceClassLoader(resourceURLS, parent);
        this.parent = parent;
        this.contextPriorityClassLoader = contextPriorityClassLoader;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (!this.contextPriorityClassLoader || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.apache.geronimo.") || name.startsWith("org.apache.commons.logging.") || name.startsWith("org.mortbay.") || name.startsWith("org.xml.") || name.startsWith("org.w3c.")) {
            return super.loadClass(name);
        }
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.findClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        return this.parent.loadClass(name);
    }

    public URL getResource(String name) {
        return this.resourceClassLoader.getResource(name);
    }

    private class ResourceClassLoader
    extends URLClassLoader {
        public ResourceClassLoader(URL[] urls, ClassLoader classLoader) {
            super(urls, classLoader);
        }

        public URL getResource(String name) {
            if (!JettyClassLoader.this.contextPriorityClassLoader || name.startsWith("java/") || name.startsWith("javax/") || name.startsWith("org/apache/geronimo/") || name.startsWith("org/apache/commons/logging/") || name.startsWith("org/mortbay/") || name.startsWith("org/xml/") || name.startsWith("org/w3c/")) {
                return super.getResource(name);
            }
            URL url = this.findResource(name);
            if (url != null) {
                return url;
            }
            return JettyClassLoader.this.parent.getResource(name);
        }
    }
}

