/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.JettyEJBWebServiceContext;
import org.apache.geronimo.jetty.JettyServer;
import org.apache.geronimo.webservices.SoapHandler;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpListener;
import org.mortbay.http.RequestLog;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.Server;

public class JettyContainerImpl
implements JettyContainer,
SoapHandler,
GBeanLifecycle {
    private final Server server;
    private final Map webServices = new HashMap();
    public static final GBeanInfo GBEAN_INFO;

    public JettyContainerImpl() {
        this.server = new JettyServer();
    }

    public void resetStatistics() {
        this.server.statsReset();
    }

    public void setCollectStatistics(boolean on) {
        this.server.setStatsOn(on);
    }

    public boolean getCollectStatistics() {
        return this.server.getStatsOn();
    }

    public long getCollectStatisticsStarted() {
        return this.server.getStatsOnMs();
    }

    public int getConnections() {
        return this.server.getConnections();
    }

    public int getConnectionsOpen() {
        return this.server.getConnectionsOpen();
    }

    public int getConnectionsOpenMax() {
        return this.server.getConnectionsOpenMax();
    }

    public long getConnectionsDurationAve() {
        return this.server.getConnectionsDurationAve();
    }

    public long getConnectionsDurationMax() {
        return this.server.getConnectionsDurationMax();
    }

    public int getConnectionsRequestsAve() {
        return this.server.getConnectionsRequestsAve();
    }

    public int getConnectionsRequestsMax() {
        return this.server.getConnectionsRequestsMax();
    }

    public int getErrors() {
        return this.server.getErrors();
    }

    public int getRequests() {
        return this.server.getRequests();
    }

    public int getRequestsActive() {
        return this.server.getRequestsActive();
    }

    public int getRequestsActiveMax() {
        return this.server.getRequestsActiveMax();
    }

    public long getRequestsDurationAve() {
        return this.server.getRequestsDurationAve();
    }

    public long getRequestsDurationMax() {
        return this.server.getRequestsDurationMax();
    }

    public void addListener(HttpListener listener) {
        this.server.addListener(listener);
    }

    public void removeListener(HttpListener listener) {
        this.server.removeListener(listener);
    }

    public void addContext(HttpContext context) {
        this.server.addContext(context);
    }

    public void removeContext(HttpContext context) {
        this.server.removeContext(context);
    }

    public void addRealm(UserRealm realm) {
        this.server.addRealm(realm);
    }

    public void removeRealm(UserRealm realm) {
        this.server.removeRealm(realm.getName());
    }

    public void addWebService(String contextPath, String[] virtualHosts, WebServiceContainer webServiceContainer, String securityRealmName, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) throws Exception {
        JettyEJBWebServiceContext webServiceContext = new JettyEJBWebServiceContext(contextPath, webServiceContainer, securityRealmName, realmName, transportGuarantee, authMethod, classLoader);
        webServiceContext.setHosts(virtualHosts);
        this.addContext(webServiceContext);
        webServiceContext.start();
        this.webServices.put(contextPath, webServiceContext);
    }

    public void removeWebService(String contextPath) {
        JettyEJBWebServiceContext webServiceContext = (JettyEJBWebServiceContext)((Object)this.webServices.remove(contextPath));
        this.removeContext(webServiceContext);
    }

    public void setRequestLog(RequestLog log) {
        this.server.setRequestLog(log);
    }

    public RequestLog getRequestLog() {
        return this.server.getRequestLog();
    }

    public void doStart() throws Exception {
        this.server.start();
    }

    public void doStop() {
        try {
            this.server.stop(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doFail() {
        try {
            this.server.stop(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder("Jetty Web Container", JettyContainerImpl.class);
        infoBuilder.addAttribute("collectStatistics", Boolean.TYPE, true);
        infoBuilder.addAttribute("collectStatisticsStarted", Long.TYPE, false);
        infoBuilder.addAttribute("connections", Integer.TYPE, false);
        infoBuilder.addAttribute("connectionsOpen", Integer.TYPE, false);
        infoBuilder.addAttribute("connectionsOpenMax", Integer.TYPE, false);
        infoBuilder.addAttribute("connectionsDurationAve", Long.TYPE, false);
        infoBuilder.addAttribute("connectionsDurationMax", Long.TYPE, false);
        infoBuilder.addAttribute("connectionsRequestsAve", Integer.TYPE, false);
        infoBuilder.addAttribute("connectionsRequestsMax", Integer.TYPE, false);
        infoBuilder.addAttribute("errors", Integer.TYPE, false);
        infoBuilder.addAttribute("requests", Integer.TYPE, false);
        infoBuilder.addAttribute("requestsActive", Integer.TYPE, false);
        infoBuilder.addAttribute("requestsActiveMax", Integer.TYPE, false);
        infoBuilder.addAttribute("requestsDurationAve", Long.TYPE, false);
        infoBuilder.addAttribute("requestsDurationMax", Long.TYPE, false);
        infoBuilder.addOperation("resetStatistics");
        infoBuilder.addAttribute("requestLog", RequestLog.class, false, false);
        infoBuilder.addOperation("addListener", new Class[]{HttpListener.class});
        infoBuilder.addOperation("removeListener", new Class[]{HttpListener.class});
        infoBuilder.addOperation("addContext", new Class[]{HttpContext.class});
        infoBuilder.addOperation("removeContext", new Class[]{HttpContext.class});
        infoBuilder.addOperation("addRealm", new Class[]{UserRealm.class});
        infoBuilder.addOperation("removeRealm", new Class[]{UserRealm.class});
        infoBuilder.addInterface(SoapHandler.class);
        infoBuilder.addInterface(JettyContainer.class);
        infoBuilder.setConstructor(new String[0]);
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

