/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.jetty.JAASJettyRealm;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.mortbay.http.Authenticator;
import org.mortbay.http.BasicAuthenticator;
import org.mortbay.http.ClientCertAuthenticator;
import org.mortbay.http.DigestAuthenticator;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.util.URI;

public class JettyEJBWebServiceContext
extends HttpContext
implements HttpHandler {
    private final String contextPath;
    private final WebServiceContainer webServiceContainer;
    private final Authenticator authenticator;
    private final UserRealm realm;
    private final boolean isConfidentialTransportGuarantee;
    private final boolean isIntegralTransportGuarantee;
    private final ClassLoader classLoader;
    private HttpContext httpContext;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JettyEJBWebServiceContext(String contextPath, WebServiceContainer webServiceContainer, String securityRealmName, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) {
        this.contextPath = contextPath;
        this.webServiceContainer = webServiceContainer;
        if (securityRealmName != null) {
            JAASJettyRealm realm = new JAASJettyRealm(realmName, securityRealmName);
            this.setRealm(realm);
            this.realm = realm;
            if ("NONE".equals(transportGuarantee)) {
                this.isConfidentialTransportGuarantee = false;
                this.isIntegralTransportGuarantee = false;
            } else if ("INTEGRAL".equals(transportGuarantee)) {
                this.isConfidentialTransportGuarantee = false;
                this.isIntegralTransportGuarantee = true;
            } else {
                if (!"CONFIDENTIAL".equals(transportGuarantee)) throw new IllegalArgumentException("Invalid transport-guarantee: " + transportGuarantee);
                this.isConfidentialTransportGuarantee = true;
                this.isIntegralTransportGuarantee = false;
            }
            if ("BASIC".equals(authMethod)) {
                this.authenticator = new BasicAuthenticator();
            } else if ("DIGEST".equals(authMethod)) {
                this.authenticator = new DigestAuthenticator();
            } else if ("CLIENT-CERT".equals(authMethod)) {
                this.authenticator = new ClientCertAuthenticator();
            } else {
                if (!"NONE".equals(authMethod)) throw new IllegalArgumentException("Invalid authMethod: " + authMethod);
                this.authenticator = null;
            }
        } else {
            this.realm = null;
            this.authenticator = null;
            this.isConfidentialTransportGuarantee = false;
            this.isIntegralTransportGuarantee = false;
        }
        this.classLoader = classLoader;
    }

    public String getName() {
        return this.contextPath;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void initialize(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpRequest req, HttpResponse res) throws HttpException, IOException {
        req.setContentType("text/xml");
        RequestAdapter request = new RequestAdapter(req);
        ResponseAdapter response = new ResponseAdapter(res);
        if (req.getParameter("wsdl") != null) {
            try {
                this.webServiceContainer.getWsdl((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (HttpException)new HttpException(500, "Could not fetch wsdl!").initCause((Throwable)e);
            }
        }
        if (this.isConfidentialTransportGuarantee ? !req.isConfidential() : this.isIntegralTransportGuarantee && !req.isIntegral()) {
            throw new HttpException(403);
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.classLoader);
        try {
            String pathInContext;
            if (this.authenticator != null && this.authenticator.authenticate(this.realm, pathInContext = URI.canonicalPath((String)req.getPath()), req, res) == null) {
                throw new HttpException(403);
            }
            try {
                this.webServiceContainer.invoke((WebServiceContainer.Request)request, (WebServiceContainer.Response)response);
                req.setHandled(true);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (HttpException)new HttpException(500, "Could not process message!").initCause((Throwable)e);
            }
        }
        finally {
            currentThread.setContextClassLoader(oldClassLoader);
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public static class ResponseAdapter
    implements WebServiceContainer.Response {
        private final HttpResponse response;

        public ResponseAdapter(HttpResponse response) {
            this.response = response;
        }

        public void setHeader(String name, String value) {
            this.response.setField(name, value);
        }

        public String getHeader(String name) {
            return this.response.getField(name);
        }

        public OutputStream getOutputStream() {
            return this.response.getOutputStream();
        }

        public void setStatusCode(int code) {
            this.response.setStatus(code);
        }

        public int getStatusCode() {
            return this.response.getStatus();
        }

        public void setContentType(String type) {
            this.response.setContentType(type);
        }

        public String getContentType() {
            return this.response.getContentType();
        }

        public void setStatusMessage(String responseString) {
            this.response.setStatus(this.response.getStatus(), responseString);
        }
    }

    public static class RequestAdapter
    implements WebServiceContainer.Request {
        private final HttpRequest request;
        private java.net.URI uri;
        private static final Map methods = new HashMap();

        public RequestAdapter(HttpRequest request) {
            this.request = request;
        }

        public String getHeader(String name) {
            return this.request.getField(name);
        }

        public java.net.URI getURI() {
            if (this.uri == null) {
                try {
                    String uriString = this.request.getScheme() + "://" + this.request.getHost() + ":" + this.request.getPort() + this.request.getURI();
                    this.uri = new java.net.URI(uriString);
                }
                catch (URISyntaxException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            return this.uri;
        }

        public int getContentLength() {
            return this.request.getContentLength();
        }

        public String getContentType() {
            return this.request.getContentType();
        }

        public InputStream getInputStream() throws IOException {
            return this.request.getInputStream();
        }

        public int getMethod() {
            Integer method = (Integer)methods.get(this.request.getMethod());
            return method == null ? 8 : method;
        }

        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        public Map getParameters() {
            return this.request.getParameters();
        }

        public Object getAttribute(String name) {
            return this.request.getAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            this.request.setAttribute(name, value);
        }

        static {
            methods.put("OPTIONS", new Integer(0));
            methods.put("GET", new Integer(1));
            methods.put("HEAD", new Integer(2));
            methods.put("POST", new Integer(3));
            methods.put("PUT", new Integer(4));
            methods.put("DELETE", new Integer(5));
            methods.put("TRACE", new Integer(6));
            methods.put("CONNECT", new Integer(7));
        }
    }
}

