/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanQuery;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.JettyWebConnector;
import org.apache.geronimo.jetty.connector.AJP13Connector;
import org.apache.geronimo.jetty.connector.HTTPConnector;
import org.apache.geronimo.jetty.connector.HTTPSConnector;
import org.apache.geronimo.jetty.requestlog.JettyLogManager;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.management.geronimo.WebManager;
import org.apache.geronimo.system.serverinfo.ServerInfo;

public class JettyManagerImpl
implements WebManager {
    private static final Log log = LogFactory.getLog((Class)JettyManagerImpl.class);
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;

    public JettyManagerImpl(Kernel kernel) {
        this.kernel = kernel;
    }

    /*
     * WARNING - void declaration
     */
    public String addConnector(String containerObjectName, String uniqueName, String protocol, String host, int port) {
        void var8_9;
        GBeanData connector;
        ObjectName container;
        try {
            container = ObjectName.getInstance(containerObjectName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid web container ObjectName '" + containerObjectName + "'");
        }
        ObjectName name = this.getConnectorName(container, protocol, uniqueName);
        if (protocol.equals("HTTP")) {
            connector = new GBeanData(name, HTTPConnector.GBEAN_INFO);
        } else if (protocol.equals("HTTPS")) {
            connector = new GBeanData(name, HTTPSConnector.GBEAN_INFO);
            GBeanQuery query = new GBeanQuery(null, ServerInfo.class.getName());
            Set set = this.kernel.listGBeans(query);
            connector.setReferencePattern("ServerInfo", (ObjectName)set.iterator().next());
        } else if (protocol.equals("AJP")) {
            connector = new GBeanData(name, AJP13Connector.GBEAN_INFO);
        } else {
            throw new IllegalArgumentException("Invalid protocol '" + protocol + "'");
        }
        var8_9.setAttribute("host", (Object)host);
        var8_9.setAttribute("port", (Object)new Integer(port));
        var8_9.setAttribute("minThreads", (Object)new Integer(10));
        var8_9.setAttribute("maxThreads", (Object)new Integer(50));
        var8_9.setReferencePattern("JettyContainer", container);
        ObjectName config = Util.getConfiguration((Kernel)this.kernel, (ObjectName)container);
        try {
            this.kernel.invoke(config, "addGBean", new Object[]{var8_9, Boolean.FALSE}, new String[]{GBeanData.class.getName(), Boolean.TYPE.getName()});
        }
        catch (Exception e) {
            log.error((Object)"Unable to add GBean ", (Throwable)e);
            return null;
        }
        return name.getCanonicalName();
    }

    public String[] getContainers() {
        GBeanQuery query = new GBeanQuery(null, JettyContainer.class.getName());
        Set names = this.kernel.listGBeans(query);
        String[] result = new String[names.size()];
        int i = 0;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            result[i++] = name.getCanonicalName();
        }
        return result;
    }

    public String[] getSupportedProtocols() {
        return new String[]{"HTTP", "HTTPS", "AJP"};
    }

    public void removeConnector(String objectName) {
        ObjectName name = null;
        try {
            name = ObjectName.getInstance(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name '" + objectName + "': " + e.getMessage());
        }
        try {
            GBeanInfo info = this.kernel.getGBeanInfo(name);
            boolean found = false;
            Set intfs = info.getInterfaces();
            Iterator it = intfs.iterator();
            while (it.hasNext()) {
                String intf = (String)it.next();
                if (!intf.equals((class$org$apache$geronimo$jetty$JettyWebConnector == null ? JettyManagerImpl.class$("org.apache.geronimo.jetty.JettyWebConnector") : class$org$apache$geronimo$jetty$JettyWebConnector).getName())) continue;
                found = true;
            }
            if (!found) {
                throw new GBeanNotFoundException(name);
            }
            ObjectName config = Util.getConfiguration((Kernel)this.kernel, (ObjectName)name);
            this.kernel.invoke(config, "removeGBean", new Object[]{name}, new String[]{ObjectName.class.getName()});
        }
        catch (GBeanNotFoundException e) {
            log.warn((Object)("No such GBean '" + objectName + "'"));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public String[] getConnectors(String protocol) {
        GBeanQuery query = new GBeanQuery(null, JettyWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        ArrayList<String> result = new ArrayList<String>();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            try {
                if (!this.kernel.getAttribute(name, "protocol").equals(protocol)) continue;
                result.add(name.getCanonicalName());
            }
            catch (Exception e) {
                log.error((Object)"Unable to check the protocol for a connector", (Throwable)e);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String getAccessLog(String containerObjectName) {
        GBeanQuery query = new GBeanQuery(null, JettyLogManager.class.getName());
        Set names = this.kernel.listGBeans(query);
        if (names.size() == 0) {
            return null;
        }
        if (names.size() > 1) {
            throw new IllegalStateException("Should not be more than one Jetty access log manager");
        }
        return ((ObjectName)names.iterator().next()).getCanonicalName();
    }

    public String[] getConnectors() {
        GBeanQuery query = new GBeanQuery(null, JettyWebConnector.class.getName());
        Set names = this.kernel.listGBeans(query);
        String[] result = new String[names.size()];
        int i = 0;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            ObjectName name = (ObjectName)it.next();
            result[i++] = name.getCanonicalName();
        }
        return result;
    }

    public String[] getConnectorsForContainer(String containerObjectName, String protocol) {
        if (protocol == null) {
            return this.getConnectorsForContainer(containerObjectName);
        }
        try {
            ObjectName containerName = ObjectName.getInstance(containerObjectName);
            ArrayList<String> results = new ArrayList<String>();
            GBeanQuery query = new GBeanQuery(null, JettyWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            Iterator it = set.iterator();
            block4: while (it.hasNext()) {
                ObjectName name = (ObjectName)it.next();
                GBeanData data = this.kernel.getGBeanData(name);
                Set refs = data.getReferencePatterns("JettyContainer");
                Iterator refit = refs.iterator();
                while (refit.hasNext()) {
                    ObjectName ref = (ObjectName)refit.next();
                    boolean match = false;
                    if (ref.isPattern()) {
                        Set matches = this.kernel.listGBeans(ref);
                        if (matches.size() != 1) {
                            log.error((Object)("Unable to compare a connector->container reference that's a pattern to a fixed container name: " + ref.getCanonicalName()));
                        } else {
                            ref = (ObjectName)matches.iterator().next();
                            if (ref.equals(containerName)) {
                                match = true;
                            }
                        }
                    } else if (ref.equals(containerName)) {
                        match = true;
                    }
                    if (!match) continue;
                    try {
                        String testProtocol = (String)this.kernel.getAttribute(name, "protocol");
                        if (testProtocol == null || !testProtocol.equals(protocol)) continue block4;
                        results.add(name.getCanonicalName());
                    }
                    catch (Exception e) {
                        log.error((Object)("Unable to look up protocol for connector '" + name + "'"), (Throwable)e);
                    }
                    continue block4;
                }
            }
            return results.toArray(new String[results.size()]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to look up connectors for Jetty container '" + containerObjectName + "': " + e);
        }
    }

    public String[] getConnectorsForContainer(String containerObjectName) {
        try {
            ObjectName containerName = ObjectName.getInstance(containerObjectName);
            ArrayList<String> results = new ArrayList<String>();
            GBeanQuery query = new GBeanQuery(null, JettyWebConnector.class.getName());
            Set set = this.kernel.listGBeans(query);
            Iterator it = set.iterator();
            block2: while (it.hasNext()) {
                ObjectName name = (ObjectName)it.next();
                GBeanData data = this.kernel.getGBeanData(name);
                Set refs = data.getReferencePatterns("JettyContainer");
                Iterator refit = refs.iterator();
                while (refit.hasNext()) {
                    ObjectName ref = (ObjectName)refit.next();
                    if (ref.isPattern()) {
                        Set matches = this.kernel.listGBeans(ref);
                        if (matches.size() != 1) {
                            log.error((Object)("Unable to compare a connector->container reference that's a pattern to a fixed container name: " + ref.getCanonicalName()));
                            continue;
                        }
                        ref = (ObjectName)matches.iterator().next();
                        if (!ref.equals(containerName)) continue;
                        results.add(name.getCanonicalName());
                        continue block2;
                    }
                    if (!ref.equals(containerName)) continue;
                    results.add(name.getCanonicalName());
                    continue block2;
                }
            }
            return results.toArray(new String[results.size()]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to look up connectors for Jetty container '" + containerObjectName + "': " + e);
        }
    }

    private ObjectName getConnectorName(ObjectName container, String protocol, String uniqueName) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("J2EEApplication", container.getKeyProperty("J2EEApplication"));
        table.put("J2EEServer", container.getKeyProperty("J2EEServer"));
        table.put("J2EEModule", container.getKeyProperty("J2EEModule"));
        table.put("j2eeType", container.getKeyProperty("j2eeType"));
        table.put("name", "JettyWebConnector-" + protocol + "-" + uniqueName);
        try {
            return ObjectName.getInstance(container.getDomain(), table);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Never should have failed: " + e.getMessage());
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("Jetty Web Manager", JettyManagerImpl.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(WebManager.class);
        infoFactory.setConstructor(new String[]{"kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

