/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty.JettyServletHolder;
import org.apache.geronimo.jetty.JettyServletRegistration;
import org.apache.geronimo.kernel.StoredObject;
import org.apache.geronimo.webservices.POJOWebServiceServlet;
import org.apache.geronimo.webservices.WebServiceContainer;
import org.apache.geronimo.webservices.WebServiceContainerInvoker;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpRequest;

public class JettyPOJOWebServiceHolder
extends ServletHolder
implements GBeanLifecycle {
    private StoredObject storedWebServiceContainer;
    private Set servletMappings;
    private Map webRoleRefPermissions;
    private JettyServletRegistration context;
    private String pojoClassName;
    public static final GBeanInfo GBEAN_INFO;

    public JettyPOJOWebServiceHolder() {
    }

    public JettyPOJOWebServiceHolder(String pojoClassName, String servletName, Map initParams, Integer loadOnStartup, Set servletMappings, Map webRoleRefPermissions, StoredObject storedWebServiceContainer, ServletHolder previous, JettyServletRegistration context) throws Exception {
        super(context == null ? null : context.getServletHandler(), servletName, POJOWebServiceServlet.class.getName(), null);
        this.pojoClassName = pojoClassName;
        this.context = context;
        this.storedWebServiceContainer = storedWebServiceContainer;
        if (context != null) {
            this.putAll(initParams);
            if (loadOnStartup != null) {
                this.setInitOrder(loadOnStartup);
            }
            this.servletMappings = servletMappings;
            this.webRoleRefPermissions = webRoleRefPermissions == null ? Collections.EMPTY_MAP : webRoleRefPermissions;
        }
    }

    public String getServletName() {
        return this.getName();
    }

    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        JettyServletHolder.setCurrentServletName(this.getServletName());
        PolicyContext.setHandlerData((Object)ServletHttpRequest.unwrap((ServletRequest)request));
        super.handle(request, response);
    }

    public void doStart() throws Exception {
        if (this.context != null) {
            Class<?> pojoClass = this.context.getWebClassLoader().loadClass(this.pojoClassName);
            WebServiceContainer webServiceContainer = (WebServiceContainer)this.storedWebServiceContainer.getObject(this.context.getWebClassLoader());
            ServletContext servletContext = this.context.getServletHandler().getServletContext();
            String webServicecontainerID = this.getServletName() + WebServiceContainerInvoker.WEBSERVICE_CONTAINER + webServiceContainer.hashCode();
            this.put(WebServiceContainerInvoker.WEBSERVICE_CONTAINER, webServicecontainerID);
            servletContext.setAttribute(webServicecontainerID, (Object)webServiceContainer);
            String pojoClassID = this.getServletName() + POJOWebServiceServlet.POJO_CLASS + pojoClass.hashCode();
            this.put(POJOWebServiceServlet.POJO_CLASS, pojoClassID);
            servletContext.setAttribute(pojoClassID, pojoClass);
            this.context.registerServletHolder(this, this.getServletName(), this.servletMappings, this.webRoleRefPermissions);
        }
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(JettyPOJOWebServiceHolder.class, "ServletWebServiceTemplate");
        infoBuilder.addInterface(ServletHolder.class);
        infoBuilder.addAttribute("pojoClassName", String.class, true);
        infoBuilder.addAttribute("servletName", String.class, true);
        infoBuilder.addAttribute("initParams", Map.class, true);
        infoBuilder.addAttribute("loadOnStartup", Integer.class, true);
        infoBuilder.addAttribute("servletMappings", Set.class, true);
        infoBuilder.addAttribute("webRoleRefPermissions", Map.class, true);
        infoBuilder.addAttribute("webServiceContainer", StoredObject.class, true);
        infoBuilder.addReference("Previous", ServletHolder.class, "Servlet");
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class);
        infoBuilder.setConstructor(new String[]{"pojoClassName", "servletName", "initParams", "loadOnStartup", "servletMappings", "webRoleRefPermissions", "webServiceContainer", "Previous", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

