/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jetty.JettyServletRegistration;
import org.apache.geronimo.management.Servlet;
import org.mortbay.jetty.servlet.ServletHolder;

public class JettyServletHolder
extends ServletHolder
implements Servlet {
    private static final ThreadLocal currentServletName = new ThreadLocal();
    private final String objectName;
    public static final GBeanInfo GBEAN_INFO;

    public JettyServletHolder() {
        this.objectName = null;
    }

    public JettyServletHolder(String objectName, String servletName, String servletClassName, String jspFile, Map initParams, Integer loadOnStartup, Set servletMappings, Map webRoleRefPermissions, String runAsRole, ServletHolder previous, JettyServletRegistration context) throws Exception {
        super(context == null ? null : context.getServletHandler(), servletName, servletClassName, jspFile);
        if (context != null) {
            this.putAll(initParams);
            if (loadOnStartup != null) {
                this.setInitOrder(loadOnStartup);
            }
            context.registerServletHolder(this, servletName, servletMappings, webRoleRefPermissions == null ? Collections.EMPTY_MAP : webRoleRefPermissions);
        }
        this.setRunAs(runAsRole);
        this.objectName = objectName;
    }

    public String getServletName() {
        return this.getName();
    }

    public void handle(ServletRequest request, ServletResponse response) throws ServletException, UnavailableException, IOException {
        JettyServletHolder.setCurrentServletName(this.getServletName());
        super.handle(request, response);
    }

    static String getCurrentServletName() {
        return (String)currentServletName.get();
    }

    static void setCurrentServletName(String servletName) {
        currentServletName.set(servletName);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return false;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return false;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(JettyServletHolder.class, "DefaultServlet");
        infoBuilder.addInterface(ServletHolder.class);
        infoBuilder.addAttribute("servletName", String.class, true);
        infoBuilder.addAttribute("servletClass", String.class, true);
        infoBuilder.addAttribute("jspFile", String.class, true);
        infoBuilder.addAttribute("initParams", Map.class, true);
        infoBuilder.addAttribute("loadOnStartup", Integer.class, true);
        infoBuilder.addAttribute("servletMappings", Set.class, true);
        infoBuilder.addAttribute("webRoleRefPermissions", Map.class, true);
        infoBuilder.addAttribute("runAsRole", String.class, true);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addInterface(Servlet.class);
        infoBuilder.addReference("Previous", ServletHolder.class, "Servlet");
        infoBuilder.addReference("JettyServletRegistration", JettyServletRegistration.class, "WebModule");
        infoBuilder.setConstructor(new String[]{"objectName", "servletName", "servletClass", "jspFile", "initParams", "loadOnStartup", "servletMappings", "webRoleRefPermissions", "runAsRole", "Previous", "JettyServletRegistration"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

