/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty;

import [Ljava.lang.String;;
import [Ljava.net.URI;;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.PermissionCollection;
import java.util.Collection;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContextImpl;
import org.apache.geronimo.j2ee.management.impl.InvalidObjectNameException;
import org.apache.geronimo.j2ee.management.impl.Util;
import org.apache.geronimo.jetty.JAASJettyRealm;
import org.apache.geronimo.jetty.JettyClassLoader;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.JettyServletRegistration;
import org.apache.geronimo.jetty.interceptor.BeforeAfter;
import org.apache.geronimo.jetty.interceptor.ComponentContextBeforeAfter;
import org.apache.geronimo.jetty.interceptor.InstanceContextBeforeAfter;
import org.apache.geronimo.jetty.interceptor.RequestWrappingBeforeAfter;
import org.apache.geronimo.jetty.interceptor.SecurityContextBeforeAfter;
import org.apache.geronimo.jetty.interceptor.ThreadClassloaderBeforeAfter;
import org.apache.geronimo.jetty.interceptor.TransactionContextBeforeAfter;
import org.apache.geronimo.jetty.interceptor.WebApplicationContextBeforeAfter;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.JMXUtil;
import org.apache.geronimo.management.J2EEApplication;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.WebModule;
import org.apache.geronimo.naming.java.SimpleReadOnlyContext;
import org.apache.geronimo.naming.reference.ClassLoaderAwareReference;
import org.apache.geronimo.naming.reference.KernelAwareReference;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.jacc.RoleDesignateSource;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;
import org.apache.geronimo.transaction.context.OnlineUserTransaction;
import org.apache.geronimo.transaction.context.TransactionContextManager;
import org.mortbay.http.Authenticator;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.JSR154Filter;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;

public class JettyWebAppContext
extends WebApplicationContext
implements GBeanLifecycle,
JettyServletRegistration,
WebModule {
    private static Log log;
    private final Kernel kernel;
    private final J2eeContext moduleContext;
    private final String originalSpecDD;
    private final J2EEServer server;
    private final J2EEApplication application;
    private final ClassLoader webClassLoader;
    private final JettyContainer jettyContainer;
    private final URI webAppRoot;
    private final WebApplicationHandler handler;
    private String displayName;
    private final String[] welcomeFiles;
    private final BeforeAfter chain;
    private final int contextLength;
    private final SecurityContextBeforeAfter securityInterceptor;
    private static final String[] J2EE_TYPES;
    private final String objectName;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JettyWebAppContext() {
        this.kernel = null;
        this.server = null;
        this.application = null;
        this.moduleContext = null;
        this.originalSpecDD = null;
        this.webClassLoader = null;
        this.jettyContainer = null;
        this.webAppRoot = null;
        this.handler = null;
        this.chain = null;
        this.contextLength = 0;
        this.securityInterceptor = null;
        this.welcomeFiles = null;
        this.objectName = null;
    }

    public JettyWebAppContext(String objectName, String originalSpecDD, URI uri, String[] virtualHosts, Map componentContext, OnlineUserTransaction userTransaction, ClassLoader classLoader, URI[] webClassPath, boolean contextPriorityClassLoader, URL configurationBaseUrl, Set unshareableResources, Set applicationManagedSecurityResources, String displayName, Map contextParamMap, Collection listenerClassNames, boolean distributable, Map mimeMap, String[] welcomeFiles, Map localeEncodingMapping, Map errorPages, Authenticator authenticator, String realmName, Map tagLibMap, int sessionTimeoutSeconds, String policyContextID, String securityRealmName, DefaultPrincipal defaultPrincipal, PermissionCollection checkedPermissions, PermissionCollection excludedPermissions, TransactionContextManager transactionContextManager, TrackedConnectionAssociator trackedConnectionAssociator, JettyContainer jettyContainer, RoleDesignateSource roleDesignateSource, J2EEServer server, J2EEApplication application, Kernel kernel) throws Exception, IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (!$assertionsDisabled && uri == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && componentContext == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && userTransaction == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && classLoader == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && webClassPath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && configurationBaseUrl == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && transactionContextManager == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && trackedConnectionAssociator == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && jettyContainer == null) {
            throw new AssertionError();
        }
        this.kernel = kernel;
        this.server = server;
        this.application = application;
        this.objectName = objectName;
        ObjectName myObjectName = JMXUtil.getObjectName((String)objectName);
        this.verifyObjectName(myObjectName);
        this.moduleContext = J2eeContextImpl.newContext((ObjectName)myObjectName, (String)"WebModule");
        this.jettyContainer = jettyContainer;
        this.originalSpecDD = originalSpecDD;
        this.setConfigurationClassNames(new String[0]);
        URI root = null;
        root = configurationBaseUrl.getProtocol().equalsIgnoreCase("file") ? new URI("file", configurationBaseUrl.getPath(), null) : URI.create(configurationBaseUrl.toString());
        this.webAppRoot = root.resolve(uri);
        URL webAppRootURL = this.webAppRoot.toURL();
        URL[] urls = new URL[webClassPath.length];
        for (int i = 0; i < webClassPath.length; ++i) {
            URI classPathEntry = webClassPath[i];
            classPathEntry = root.resolve(classPathEntry);
            urls[i] = classPathEntry.toURL();
        }
        this.webClassLoader = new JettyClassLoader(urls, webAppRootURL, classLoader, contextPriorityClassLoader);
        this.setClassLoader(this.webClassLoader);
        this.setHosts(virtualHosts);
        this.handler = new WebApplicationHandler();
        this.addHandler((HttpHandler)this.handler);
        userTransaction.setUp(transactionContextManager, trackedConnectionAssociator);
        this.setDisplayName(displayName);
        this.setContextParamMap(contextParamMap);
        this.setListenerClassNames(listenerClassNames);
        this.setDistributable(distributable);
        this.setMimeMap(mimeMap);
        this.welcomeFiles = welcomeFiles;
        this.setLocaleEncodingMapping(localeEncodingMapping);
        this.setErrorPages(errorPages);
        this.setAuthenticator(authenticator);
        this.setRealmName(realmName);
        this.setTagLibMap(tagLibMap);
        this.setSessionTimeoutSeconds(sessionTimeoutSeconds);
        SimpleReadOnlyContext enc = null;
        if (componentContext != null) {
            Iterator iterator = componentContext.values().iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (value instanceof KernelAwareReference) {
                    ((KernelAwareReference)value).setKernel(kernel);
                }
                if (!(value instanceof ClassLoaderAwareReference)) continue;
                ((ClassLoaderAwareReference)value).setClassLoader(this.webClassLoader);
            }
            enc = new SimpleReadOnlyContext(componentContext);
        }
        int index = 0;
        BeforeAfter interceptor = new InstanceContextBeforeAfter(null, index++, unshareableResources, applicationManagedSecurityResources, trackedConnectionAssociator);
        interceptor = new TransactionContextBeforeAfter(interceptor, index++, index++, transactionContextManager);
        interceptor = new ComponentContextBeforeAfter(interceptor, index++, (Context)enc);
        interceptor = new ThreadClassloaderBeforeAfter(interceptor, index++, index++, this.webClassLoader);
        interceptor = new WebApplicationContextBeforeAfter(interceptor, index++, this);
        if (securityRealmName != null) {
            if (roleDesignateSource == null) {
                throw new IllegalArgumentException("RoleDesignateSource must be supplied for a secure web app");
            }
            Map roleDesignates = roleDesignateSource.getRoleDesignateMap();
            JAASJettyRealm realm = new JAASJettyRealm(realmName, securityRealmName);
            this.setRealm(realm);
            this.securityInterceptor = new SecurityContextBeforeAfter(interceptor, index++, index++, policyContextID, defaultPrincipal, authenticator, checkedPermissions, excludedPermissions, roleDesignates, realm);
            interceptor = this.securityInterceptor;
        } else {
            this.securityInterceptor = null;
        }
        interceptor = new RequestWrappingBeforeAfter(interceptor, (ServletHandler)this.handler);
        this.chain = interceptor;
        this.contextLength = index;
        FilterHolder jsr154FilterHolder = new FilterHolder((HttpHandler)this.handler, "jsr154", JSR154Filter.class.getName());
        this.handler.addFilterHolder(jsr154FilterHolder);
        jsr154FilterHolder.setInitParameter("unwrappedDispatch", "true");
        this.handler.addFilterPathMapping("/*", "jsr154", 15);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return false;
    }

    public boolean isEventProvider() {
        return true;
    }

    public Object enterContextScope(HttpRequest httpRequest, HttpResponse httpResponse) {
        Object[] context = new Object[this.contextLength];
        this.chain.before(context, httpRequest, httpResponse);
        return context;
    }

    public void leaveContextScope(HttpRequest httpRequest, HttpResponse httpResponse, Object oldScope) {
        Object[] context = (Object[])oldScope;
        this.chain.after(context, httpRequest, httpResponse);
    }

    public ClassLoader getWebClassLoader() {
        return this.webClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        this.setClassLoader(this.webClassLoader);
        if (!this.isStarting()) {
            super.start();
            return;
        }
        ((AbstractSessionManager)this.getServletHandler().getSessionManager()).setUseRequestedId(true);
        this.setWAR(this.webAppRoot.toString());
        this.jettyContainer.addContext((HttpContext)this);
        Object context = this.enterContextScope(null, null);
        try {
            super.doStart();
        }
        finally {
            this.leaveContextScope(null, null, context);
        }
        this.setWelcomeFiles(this.welcomeFiles);
        log.info((Object)"JettyWebAppContext started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        if (!this.isStopping()) {
            super.stop();
            return;
        }
        if (this.securityInterceptor != null) {
            this.securityInterceptor.stop();
        }
        Object context = this.enterContextScope(null, null);
        try {
            super.doStop();
            Object var3_2 = null;
            this.leaveContextScope(null, null, context);
            this.jettyContainer.removeContext((HttpContext)this);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.leaveContextScope(null, null, context);
            this.jettyContainer.removeContext((HttpContext)this);
            throw throwable;
        }
        LogFactory.release((ClassLoader)this.webClassLoader);
        log.info((Object)"JettyWebAppContext stopped");
    }

    public void doFail() {
        try {
            super.stop();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info((Object)"JettyWebAppContext failed");
    }

    public void setContextParamMap(Map initParameters) {
        if (initParameters != null) {
            Iterator iterator = initParameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.setInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setLocaleEncodingMapping(Map localeEncodingMap) {
        if (localeEncodingMap != null) {
            Iterator iterator = localeEncodingMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.addLocaleEncoding((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setListenerClassNames(Collection eventListeners) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (eventListeners != null) {
            Iterator iterator = eventListeners.iterator();
            while (iterator.hasNext()) {
                String listenerClassName = (String)iterator.next();
                Class clazz = this.loadClass(listenerClassName);
                EventListener listener = (EventListener)clazz.newInstance();
                this.addEventListener(listener);
                this.handler.addEventListener(listener);
            }
        }
    }

    public void setErrorPages(Map errorPageMap) {
        if (errorPageMap != null) {
            Iterator iterator = errorPageMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.setErrorPage((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setTagLibMap(Map tagLibMap) {
        if (tagLibMap != null) {
            Iterator iterator = tagLibMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.setResourceAlias((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void setSessionTimeoutSeconds(int seconds) {
        this.handler.setSessionInactiveInterval(seconds);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        super.setDisplayName(displayName);
    }

    public String getDeploymentDescriptor() {
        return this.originalSpecDD;
    }

    public String getServer() {
        return this.server.getObjectName();
    }

    public String getApplication() {
        if (this.application == null) {
            return null;
        }
        return this.application.getObjectName();
    }

    public String[] getJavaVMs() {
        return this.server.getJavaVMs();
    }

    public String[] getServlets() {
        try {
            return Util.getObjectNames((Kernel)this.kernel, (J2eeContext)this.moduleContext, (String[])J2EE_TYPES);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)e);
            return new String[0];
        }
    }

    private void verifyObjectName(ObjectName objectName) {
        if (objectName.isPattern()) {
            throw new InvalidObjectNameException("ObjectName can not be a pattern", objectName);
        }
        Hashtable<String, String> keyPropertyList = objectName.getKeyPropertyList();
        if (!"WebModule".equals(keyPropertyList.get("j2eeType"))) {
            throw new InvalidObjectNameException("WebModule object name j2eeType property must be 'WebModule'", objectName);
        }
        if (!keyPropertyList.containsKey("name")) {
            throw new InvalidObjectNameException("WebModule object must contain a name property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEServer")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEServer property", objectName);
        }
        if (!keyPropertyList.containsKey("J2EEApplication")) {
            throw new InvalidObjectNameException("WebModule object name must contain a J2EEApplication property", objectName);
        }
        if (keyPropertyList.size() != 4) {
            throw new InvalidObjectNameException("WebModule object name can only have j2eeType, name, J2EEApplication, and J2EEServer properties", objectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServletHolder(ServletHolder servletHolder, String servletName, Set servletMappings, Map webRoleRefPermissions) throws Exception {
        this.handler.addServletHolder(servletHolder);
        if (servletMappings != null) {
            Iterator iterator = servletMappings.iterator();
            while (iterator.hasNext()) {
                String urlPattern = (String)iterator.next();
                this.handler.mapPathToServlet(urlPattern, servletName);
            }
        }
        Object context = this.enterContextScope(null, null);
        try {
            servletHolder.start();
        }
        finally {
            this.leaveContextScope(null, null, context);
        }
    }

    public boolean checkSecurityConstraints(String pathInContext, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (this.securityInterceptor != null) {
            return this.securityInterceptor.checkSecurityConstraints(pathInContext, request, response);
        }
        return super.checkSecurityConstraints(pathInContext, request, response);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !JettyWebAppContext.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)JettyWebAppContext.class);
        J2EE_TYPES = new String[]{"Servlet"};
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder("Jetty WebApplication Context", JettyWebAppContext.class, "WebModule");
        infoBuilder.addAttribute("deploymentDescriptor", String.class, true);
        infoBuilder.addAttribute("displayName", String.class, true);
        infoBuilder.addAttribute("contextParamMap", Map.class, true);
        infoBuilder.addAttribute("listenerClassNames", Collection.class, true);
        infoBuilder.addAttribute("distributable", Boolean.TYPE, true);
        infoBuilder.addAttribute("mimeMap", Map.class, true);
        infoBuilder.addAttribute("welcomeFiles", String;.class, true);
        infoBuilder.addAttribute("localeEncodingMapping", Map.class, true);
        infoBuilder.addAttribute("errorPages", Map.class, true);
        infoBuilder.addAttribute("authenticator", Authenticator.class, true);
        infoBuilder.addAttribute("realmName", String.class, true);
        infoBuilder.addAttribute("tagLibMap", Map.class, true);
        infoBuilder.addAttribute("sessionTimeoutSeconds", Integer.TYPE, true);
        infoBuilder.addAttribute("uri", URI.class, true);
        infoBuilder.addAttribute("virtualHosts", String;.class, true);
        infoBuilder.addAttribute("componentContext", Map.class, true);
        infoBuilder.addAttribute("userTransaction", OnlineUserTransaction.class, true);
        infoBuilder.addAttribute("classLoader", ClassLoader.class, false);
        infoBuilder.addAttribute("webClassPath", URI;.class, true);
        infoBuilder.addAttribute("contextPriorityClassLoader", Boolean.TYPE, true);
        infoBuilder.addAttribute("configurationBaseUrl", URL.class, true);
        infoBuilder.addAttribute("unshareableResources", Set.class, true);
        infoBuilder.addAttribute("applicationManagedSecurityResources", Set.class, true);
        infoBuilder.addAttribute("contextPath", String.class, true);
        infoBuilder.addReference("TransactionContextManager", TransactionContextManager.class, "TransactionContextManager");
        infoBuilder.addReference("TrackedConnectionAssociator", TrackedConnectionAssociator.class, "JCAConnectionTracker");
        infoBuilder.addReference("JettyContainer", JettyContainer.class, "GBean");
        infoBuilder.addReference("RoleDesignateSource", RoleDesignateSource.class, "JACCManager");
        infoBuilder.addInterface(JettyServletRegistration.class);
        infoBuilder.addAttribute("policyContextID", String.class, true);
        infoBuilder.addAttribute("securityRealmName", String.class, true);
        infoBuilder.addAttribute("defaultPrincipal", DefaultPrincipal.class, true);
        infoBuilder.addAttribute("checkedPermissions", PermissionCollection.class, true);
        infoBuilder.addAttribute("excludedPermissions", PermissionCollection.class, true);
        infoBuilder.addReference("J2EEServer", J2EEServer.class);
        infoBuilder.addReference("J2EEApplication", J2EEApplication.class);
        infoBuilder.addAttribute("kernel", Kernel.class, false);
        infoBuilder.addAttribute("objectName", String.class, false);
        infoBuilder.addAttribute("server", String.class, false);
        infoBuilder.addAttribute("application", String.class, false);
        infoBuilder.addAttribute("javaVMs", String;.class, false);
        infoBuilder.addAttribute("servlets", String;.class, false);
        infoBuilder.addInterface(WebModule.class);
        infoBuilder.setConstructor(new String[]{"objectName", "deploymentDescriptor", "uri", "virtualHosts", "componentContext", "userTransaction", "classLoader", "webClassPath", "contextPriorityClassLoader", "configurationBaseUrl", "unshareableResources", "applicationManagedSecurityResources", "displayName", "contextParamMap", "listenerClassNames", "distributable", "mimeMap", "welcomeFiles", "localeEncodingMapping", "errorPages", "authenticator", "realmName", "tagLibMap", "sessionTimeoutSeconds", "policyContextID", "securityRealmName", "defaultPrincipal", "checkedPermissions", "excludedPermissions", "TransactionContextManager", "TrackedConnectionAssociator", "JettyContainer", "RoleDesignateSource", "J2EEServer", "J2EEApplication", "kernel"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

