/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.connector;

import javax.net.ssl.KeyManagerFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.JettySecureConnector;
import org.apache.geronimo.jetty.connector.JettyConnector;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SslListener;

public class HTTPSConnector
extends JettyConnector
implements JettySecureConnector {
    private final SslListener https;
    private final ServerInfo serverInfo;
    private String keystore;
    private String algorithm;
    public static final GBeanInfo GBEAN_INFO;

    public HTTPSConnector(JettyContainer container, ServerInfo serverInfo) {
        super(container, (HttpListener)new SslListener());
        this.serverInfo = serverInfo;
        this.https = (SslListener)this.listener;
    }

    public int getDefaultPort() {
        return 443;
    }

    public String getProtocol() {
        return "HTTPS";
    }

    public String getKeystoreFileName() {
        return this.keystore;
    }

    public void setKeystoreFileName(String keystore) {
        this.keystore = keystore;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        if ("default".equalsIgnoreCase(algorithm)) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        this.https.setAlgorithm(algorithm);
    }

    public void setKeystorePassword(String password) {
        this.https.setPassword(password);
    }

    public void setKeyPassword(String password) {
        this.https.setKeyPassword(password);
    }

    public String getSecureProtocol() {
        return this.https.getProtocol();
    }

    public void setSecureProtocol(String protocol) {
        this.https.setProtocol(protocol);
    }

    public String getKeystoreType() {
        return this.https.getKeystoreType();
    }

    public void setKeystoreType(String keystoreType) {
        this.https.setKeystoreType(keystoreType);
    }

    public void setClientAuthRequired(boolean needClientAuth) {
        this.https.setNeedClientAuth(needClientAuth);
    }

    public boolean isClientAuthRequired() {
        return this.https.getNeedClientAuth();
    }

    public void doStart() throws Exception {
        this.https.setKeystore(this.serverInfo.resolvePath(this.keystore));
        super.doStart();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("Jetty Connector HTTPS", HTTPSConnector.class, JettyConnector.GBEAN_INFO);
        infoFactory.addAttribute("keystoreFileName", String.class, true, true);
        infoFactory.addAttribute("algorithm", String.class, true, true);
        infoFactory.addAttribute("keystorePassword", String.class, true, true);
        infoFactory.addAttribute("keyPassword", String.class, true, true);
        infoFactory.addAttribute("secureProtocol", String.class, true, true);
        infoFactory.addAttribute("keystoreType", String.class, true, true);
        infoFactory.addAttribute("clientAuthRequired", Boolean.TYPE, true, true);
        infoFactory.addReference("ServerInfo", ServerInfo.class, "GBean");
        infoFactory.addInterface(JettySecureConnector.class);
        infoFactory.setConstructor(new String[]{"JettyContainer", "ServerInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

