/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.connector;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.jetty.JettyContainer;
import org.apache.geronimo.jetty.JettyWebConnector;
import org.mortbay.http.HttpListener;
import org.mortbay.http.SocketListener;
import org.mortbay.http.ajp.AJP13Listener;
import org.mortbay.util.ThreadedServer;

public abstract class JettyConnector
implements GBeanLifecycle,
JettyWebConnector {
    public static final String CONNECTOR_CONTAINER_REFERENCE = "JettyContainer";
    private final JettyContainer container;
    protected final HttpListener listener;
    private String connectHost;
    public static final GBeanInfo GBEAN_INFO;

    public JettyConnector() {
        this.container = null;
        this.listener = null;
    }

    public JettyConnector(JettyContainer container) {
        this.container = container;
        this.listener = null;
    }

    public JettyConnector(JettyContainer container, HttpListener listener) {
        this.container = container;
        this.listener = listener;
    }

    public String getDefaultScheme() {
        return this.listener.getDefaultScheme();
    }

    public String getHost() {
        return this.listener.getHost();
    }

    public void setHost(String host) throws UnknownHostException {
        this.listener.setHost(host);
    }

    public int getPort() {
        return this.listener.getPort();
    }

    public void setPort(int port) {
        this.listener.setPort(port);
    }

    public abstract int getDefaultPort();

    public String getConnectUrl() {
        if (this.connectHost == null) {
            String host = this.getHost();
            if (host == null || host.equals("0.0.0.0")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    host = "unknown-host";
                }
                if (address != null && ((host = address.getHostName()) == null || host.equals(""))) {
                    host = address.getHostAddress();
                }
            }
            this.connectHost = host;
        }
        return this.getProtocol().toLowerCase() + "://" + this.connectHost + (this.getPort() == this.getDefaultPort() ? "" : ":" + this.getPort());
    }

    public void setMinThreads(int minThreads) {
        ((ThreadedServer)this.listener).setMinThreads(minThreads);
    }

    public int getMinThreads() {
        return ((ThreadedServer)this.listener).getMinThreads();
    }

    public void setMaxThreads(int maxThreads) {
        ((ThreadedServer)this.listener).setMaxThreads(maxThreads);
    }

    public int getMaxThreads() {
        return ((ThreadedServer)this.listener).getMaxThreads();
    }

    public int getThreads() {
        return ((ThreadedServer)this.listener).getThreads();
    }

    public int getIdlethreads() {
        return ((ThreadedServer)this.listener).getIdleThreads();
    }

    public InetSocketAddress getListenAddress() {
        return new InetSocketAddress(this.getHost(), this.getPort());
    }

    public int getBufferSizeBytes() {
        return this.listener.getBufferSize();
    }

    public void setBufferSizeBytes(int bytes) {
        if (this.listener instanceof SocketListener) {
            SocketListener socketListener = (SocketListener)this.listener;
            socketListener.setBufferSize(bytes);
        } else if (this.listener instanceof AJP13Listener) {
            ((AJP13Listener)this.listener).setBufferSize(bytes);
        } else {
            throw new UnsupportedOperationException(this.listener == null ? "No Listener" : this.listener.getClass().getName());
        }
    }

    public int getAcceptQueueSize() {
        return ((ThreadedServer)this.listener).getAcceptQueueSize();
    }

    public void setAcceptQueueSize(int size) {
        ((ThreadedServer)this.listener).setAcceptQueueSize(size);
    }

    public int getLingerMillis() {
        return ((ThreadedServer)this.listener).getLingerTimeSecs() * 1000;
    }

    public void setLingerMillis(int millis) {
        ((ThreadedServer)this.listener).setLingerTimeSecs(Math.round((float)millis / 1000.0f));
    }

    public boolean isTcpNoDelay() {
        return ((ThreadedServer)this.listener).getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean enable) {
        ((ThreadedServer)this.listener).setTcpNoDelay(enable);
    }

    public int getRedirectPort() {
        return this.listener.getConfidentialPort();
    }

    public void setRedirectPort(int port) {
        if (this.listener instanceof SocketListener) {
            SocketListener socketListener = (SocketListener)this.listener;
            socketListener.setConfidentialPort(port);
            socketListener.setIntegralPort(port);
            socketListener.setIntegralScheme("https");
            socketListener.setConfidentialScheme("https");
        } else if (this.listener instanceof AJP13Listener) {
            AJP13Listener ajpListener = (AJP13Listener)this.listener;
            ajpListener.setConfidentialPort(port);
            ajpListener.setIntegralPort(port);
            ajpListener.setIntegralScheme("https");
            ajpListener.setConfidentialScheme("https");
        } else {
            throw new UnsupportedOperationException(this.listener == null ? "No Listener" : this.listener.getClass().getName());
        }
    }

    public abstract String getProtocol();

    public void doStart() throws Exception {
        this.container.addListener(this.listener);
        ((ThreadedServer)this.listener).open();
        this.listener.start();
    }

    public void doStop() {
        while (true) {
            try {
                this.listener.stop();
                this.container.removeListener(this.listener);
                return;
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    public void doFail() {
        while (true) {
            try {
                this.listener.stop();
                this.container.removeListener(this.listener);
                return;
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("Jetty HTTP Connector", JettyConnector.class);
        infoFactory.addReference(CONNECTOR_CONTAINER_REFERENCE, JettyContainer.class, "GBean");
        infoFactory.addInterface(JettyWebConnector.class, new String[]{"host", "port", "minThreads", "maxThreads", "bufferSizeBytes", "acceptQueueSize", "lingerMillis", "tcpNoDelay", "redirectPort", "connectUrl"}, new String[]{"host", "port", "redirectPort"});
        infoFactory.setConstructor(new String[]{CONNECTOR_CONTAINER_REFERENCE});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

