/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.interceptor;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.apache.geronimo.common.GeronimoSecurityException;
import org.apache.geronimo.jetty.JAASJettyPrincipal;
import org.apache.geronimo.jetty.interceptor.BeforeAfter;
import org.apache.geronimo.security.ContextManager;
import org.apache.geronimo.security.IdentificationPrincipal;
import org.apache.geronimo.security.SubjectId;
import org.apache.geronimo.security.deploy.DefaultPrincipal;
import org.apache.geronimo.security.util.ConfigurationUtil;
import org.mortbay.http.Authenticator;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.SecurityConstraint;
import org.mortbay.http.UserRealm;
import org.mortbay.jetty.servlet.FormAuthenticator;
import org.mortbay.jetty.servlet.ServletHttpRequest;

public class SecurityContextBeforeAfter
implements BeforeAfter {
    private final BeforeAfter next;
    private final int policyContextIDIndex;
    private final int webAppContextIndex;
    private final String policyContextID;
    private static final ThreadLocal currentWebAppContext = new ThreadLocal();
    private final Map roleDesignates;
    private final JAASJettyPrincipal defaultPrincipal;
    private final String formLoginPath;
    private final PermissionCollection checked;
    private final PermissionCollection excludedPermissions;
    private final Authenticator authenticator;
    private final UserRealm realm;

    public SecurityContextBeforeAfter(BeforeAfter next, int policyContextIDIndex, int webAppContextIndex, String policyContextID, DefaultPrincipal defaultPrincipal, Authenticator authenticator, PermissionCollection checkedPermissions, PermissionCollection excludedPermissions, Map roleDesignates, UserRealm realm) {
        this.next = next;
        this.policyContextIDIndex = policyContextIDIndex;
        this.webAppContextIndex = webAppContextIndex;
        this.policyContextID = policyContextID;
        this.defaultPrincipal = this.generateDefaultPrincipal(defaultPrincipal);
        this.roleDesignates = roleDesignates;
        this.checked = checkedPermissions;
        this.excludedPermissions = excludedPermissions;
        if (authenticator instanceof FormAuthenticator) {
            String formLoginPath = ((FormAuthenticator)authenticator).getLoginPage();
            if (formLoginPath.indexOf(63) > 0) {
                formLoginPath = formLoginPath.substring(0, formLoginPath.indexOf(63));
            }
            this.formLoginPath = formLoginPath;
        } else {
            this.formLoginPath = null;
        }
        this.authenticator = authenticator;
        Subject defaultSubject = this.defaultPrincipal.getSubject();
        ContextManager.registerSubject((Subject)defaultSubject);
        SubjectId id = ContextManager.getSubjectId((Subject)defaultSubject);
        defaultSubject.getPrincipals().add((Principal)new IdentificationPrincipal(id));
        this.realm = realm;
    }

    public void stop() {
        Subject defaultSubject = this.defaultPrincipal.getSubject();
        ContextManager.unregisterSubject((Subject)defaultSubject);
    }

    public void before(Object[] context, HttpRequest httpRequest, HttpResponse httpResponse) {
        context[this.policyContextIDIndex] = PolicyContext.getContextID();
        context[this.webAppContextIndex] = SecurityContextBeforeAfter.getCurrentSecurityInterceptor();
        PolicyContext.setContextID((String)this.policyContextID);
        SecurityContextBeforeAfter.setCurrentSecurityInterceptor(this);
        if (httpRequest != null) {
            ServletHttpRequest request = (ServletHttpRequest)httpRequest.getWrapper();
            PolicyContext.setHandlerData((Object)request);
        }
        if (this.next != null) {
            this.next.before(context, httpRequest, httpResponse);
        }
    }

    public void after(Object[] context, HttpRequest httpRequest, HttpResponse httpResponse) {
        if (this.next != null) {
            this.next.after(context, httpRequest, httpResponse);
        }
        SecurityContextBeforeAfter.setCurrentSecurityInterceptor((SecurityContextBeforeAfter)context[this.webAppContextIndex]);
        PolicyContext.setContextID((String)((String)context[this.policyContextIDIndex]));
    }

    private static void setCurrentSecurityInterceptor(SecurityContextBeforeAfter context) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)ContextManager.SET_CONTEXT);
        }
        currentWebAppContext.set(context);
    }

    private static SecurityContextBeforeAfter getCurrentSecurityInterceptor() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)ContextManager.GET_CONTEXT);
        }
        return (SecurityContextBeforeAfter)currentWebAppContext.get();
    }

    public static Subject getCurrentRoleDesignate(String role) {
        return SecurityContextBeforeAfter.getCurrentSecurityInterceptor().getRoleDesignate(role);
    }

    private Subject getRoleDesignate(String roleName) {
        return (Subject)this.roleDesignates.get(roleName);
    }

    public boolean checkSecurityConstraints(String pathInContext, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (this.formLoginPath != null) {
            String pathToBeTested;
            String string = pathToBeTested = pathInContext.indexOf(63) > 0 ? pathInContext.substring(0, pathInContext.indexOf(63)) : pathInContext;
            if (pathToBeTested.equals(this.formLoginPath)) {
                return true;
            }
        }
        try {
            Principal user = this.obtainUser(pathInContext, request, response);
            if (user == null) {
                return false;
            }
            if (user == SecurityConstraint.__NOBODY) {
                return true;
            }
            AccessControlContext acc = ContextManager.getCurrentContext();
            ServletHttpRequest servletHttpRequest = (ServletHttpRequest)request.getWrapper();
            String transportType = request.isConfidential() ? "CONFIDENTIAL" : (request.isIntegral() ? "INTEGRAL" : "NONE");
            WebUserDataPermission wudp = new WebUserDataPermission(servletHttpRequest.getServletPath(), new String[]{servletHttpRequest.getMethod()}, transportType);
            acc.checkPermission((Permission)wudp);
            acc.checkPermission((Permission)new WebResourcePermission((HttpServletRequest)servletHttpRequest));
        }
        catch (HttpException he) {
            response.sendError(he.getCode(), he.getReason());
            return false;
        }
        catch (AccessControlException ace) {
            response.sendError(403);
            return false;
        }
        return true;
    }

    private Principal obtainUser(String pathInContext, HttpRequest request, HttpResponse response) throws IOException, IOException {
        ServletHttpRequest servletHttpRequest = (ServletHttpRequest)request.getWrapper();
        WebResourcePermission resourcePermission = new WebResourcePermission((HttpServletRequest)servletHttpRequest);
        WebUserDataPermission dataPermission = new WebUserDataPermission((HttpServletRequest)servletHttpRequest);
        boolean unauthenticated = !this.checked.implies((Permission)resourcePermission) && !this.checked.implies((Permission)dataPermission);
        boolean forbidden = this.excludedPermissions.implies((Permission)resourcePermission) || this.excludedPermissions.implies((Permission)dataPermission);
        Principal user = null;
        if (!unauthenticated && !forbidden) {
            if (this.realm == null) {
                throw new HttpException(500, "Realm Not Configured");
            }
            if (this.authenticator == null) {
                throw new HttpException(500, "Mis-configured Authenticator for " + request.getPath());
            }
            user = this.authenticator.authenticate(this.realm, pathInContext, request, response);
            return user;
        }
        if (this.authenticator instanceof FormAuthenticator && pathInContext.endsWith("j_security_check")) {
            if (this.realm == null) {
                throw new HttpException(500, "Realm Not Configured");
            }
            return this.authenticator.authenticate(this.realm, pathInContext, request, response);
        }
        ContextManager.setCurrentCaller((Subject)this.defaultPrincipal.getSubject());
        return this.defaultPrincipal;
    }

    protected JAASJettyPrincipal generateDefaultPrincipal(DefaultPrincipal defaultPrincipal) throws GeronimoSecurityException {
        if (defaultPrincipal == null) {
            throw new GeronimoSecurityException("Unable to generate default principal");
        }
        JAASJettyPrincipal result = new JAASJettyPrincipal("default");
        Subject defaultSubject = ConfigurationUtil.generateDefaultSubject((DefaultPrincipal)defaultPrincipal);
        result.setSubject(defaultSubject);
        return result;
    }
}

