/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jetty.requestlog;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.jetty.requestlog.JettyLogManager;
import org.apache.geronimo.jetty.requestlog.JettyRequestLog;
import org.apache.geronimo.management.geronimo.WebAccessLog;

public class JettyLogManagerImpl
implements JettyLogManager {
    private static final Log log = LogFactory.getLog((Class)JettyLogManagerImpl.class);
    private static final Pattern FULL_LINE_PATTERN = Pattern.compile("^.*", 8);
    private static final Pattern ACCESS_LOG_PATTERN = Pattern.compile("(\\S*) (\\S*) (\\S*) \\[(.*)\\] \\\"(\\S*) (\\S*).*?\\\" (\\S*) (\\S*).*");
    private static final int GROUP_HOST = 1;
    private static final int GROUP_USER = 3;
    private static final int GROUP_DATE = 4;
    private static final int GROUP_METHOD = 5;
    private static final int GROUP_URI = 6;
    private static final int GROUP_RESPONSE_CODE = 7;
    private static final int GROUP_RESPONSE_LENGTH = 8;
    private static final String ACCESS_LOG_DATE_FORMAT = "dd/MMM/yyyy:HH:mm:ss ZZZZ";
    private Collection logGbeans;
    public static final GBeanInfo GBEAN_INFO;

    public JettyLogManagerImpl(Collection logGbeans) {
        this.logGbeans = logGbeans;
    }

    public String[] getLogFileNames() {
        ArrayList<String> files = new ArrayList<String>();
        Iterator it = this.logGbeans.iterator();
        while (it.hasNext()) {
            JettyRequestLog log = (JettyRequestLog)it.next();
            if (log.getFilename() == null) continue;
            files.add(log.getFilename());
        }
        return files.toArray(new String[files.size()]);
    }

    public WebAccessLog.SearchResults getMatchingItems(String logFile, String host, String user, String method, String uri, Date startDate, Date endDate, Integer skipResults, Integer maxResults) {
        File log = null;
        Iterator it = this.logGbeans.iterator();
        while (it.hasNext()) {
            JettyRequestLog logger = (JettyRequestLog)it.next();
            if (logger.getFilename() == null || !logger.getFilename().equals(logFile)) continue;
            log = new File(logger.getAbsoluteFilePath());
            break;
        }
        if (log == null) {
            throw new IllegalArgumentException("Unknown log file '" + logFile + "'");
        }
        return this.search(log, host, user, method, uri, startDate, endDate, skipResults, maxResults);
    }

    private WebAccessLog.SearchResults search(File file, String host, String user, String method, String uri, Date startDate, Date endDate, Integer skipResults, Integer maxResults) {
        if (host != null && host.equals("")) {
            host = null;
        }
        if (user != null && user.equals("")) {
            user = null;
        }
        if (method != null && method.equals("")) {
            method = null;
        }
        if (uri != null && uri.equals("")) {
            uri = null;
        }
        LinkedList<WebAccessLog.LogMessage> list = new LinkedList<WebAccessLog.LogMessage>();
        boolean capped = false;
        int lineCount = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            FileChannel fc = raf.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            CharBuffer cb = Charset.forName("US-ASCII").decode(bb);
            Matcher lines = FULL_LINE_PATTERN.matcher(cb);
            Matcher target = ACCESS_LOG_PATTERN.matcher("");
            long start = startDate == null ? 0L : startDate.getTime();
            long end = endDate == null ? 0L : endDate.getTime();
            SimpleDateFormat format = start == 0L && end == 0L ? null : new SimpleDateFormat(ACCESS_LOG_DATE_FORMAT);
            int max = maxResults == null ? 1000 : Math.min(maxResults, 1000);
            log.warn((Object)("CRITERIA: " + file.getAbsolutePath() + " " + host + " " + user + " " + method + " " + uri + " " + start + " " + end + " " + skipResults + " " + max));
            while (lines.find()) {
                ++lineCount;
                if (capped) continue;
                CharSequence line = cb.subSequence(lines.start(), lines.end());
                target.reset(line);
                if (!target.find() || host != null && !host.equals(target.group(1)) || user != null && !user.equals(target.group(3)) || method != null && !method.equals(target.group(5)) || uri != null && !target.group(6).startsWith(uri)) continue;
                if (format != null) {
                    try {
                        long entry = format.parse(target.group(4)).getTime();
                        if (start > entry || end > 0L && end < entry) {
                            continue;
                        }
                    }
                    catch (ParseException e) {
                        // empty catch block
                    }
                }
                if (skipResults != null && skipResults > lineCount) continue;
                if (list.size() > max) {
                    capped = true;
                    continue;
                }
                list.add(new WebAccessLog.LogMessage(lineCount, ((Object)line).toString()));
            }
            fc.close();
            raf.close();
        }
        catch (Exception e) {
            log.error((Object)"Unexpected error processing logs", (Throwable)e);
        }
        return new WebAccessLog.SearchResults(lineCount, list.toArray(new WebAccessLog.LogMessage[list.size()]), capped);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("Jetty Log Manager", JettyLogManagerImpl.class);
        infoFactory.addReference("LogGBeans", JettyRequestLog.class);
        infoFactory.addInterface(JettyLogManager.class);
        infoFactory.setConstructor(new String[]{"LogGBeans"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

