/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gbean.jmx;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import net.sf.cglib.reflect.FastClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBean;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GConstructorInfo;
import org.apache.geronimo.gbean.GOperationInfo;
import org.apache.geronimo.gbean.GReferenceInfo;
import org.apache.geronimo.gbean.InvalidConfigurationException;
import org.apache.geronimo.gbean.jmx.AbstractManagedObject;
import org.apache.geronimo.gbean.jmx.GBeanMBeanAttribute;
import org.apache.geronimo.gbean.jmx.GBeanMBeanContext;
import org.apache.geronimo.gbean.jmx.GBeanMBeanOperation;
import org.apache.geronimo.gbean.jmx.GBeanMBeanReference;
import org.apache.geronimo.gbean.jmx.MethodInvoker;
import org.apache.geronimo.kernel.jmx.MBeanOperationSignature;
import org.apache.geronimo.kernel.management.NotificationType;

public class GBeanMBean
extends AbstractManagedObject
implements DynamicMBean {
    public static final FastClass fastClass;
    private static final Log log;
    private final Map attributeMap = new HashMap();
    private final Map referenceMap = new HashMap();
    private final Map operationMap = new HashMap();
    private final Set notifications = new HashSet();
    private final ClassLoader classLoader;
    private final GBeanInfo gbeanInfo;
    private final MBeanInfo mbeanInfo;
    private final String name;
    private final Class type;
    private boolean offline = true;
    private Object target;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public GBeanMBean(GBeanInfo beanInfo, ClassLoader classLoader) throws InvalidConfigurationException {
        this.gbeanInfo = beanInfo;
        this.classLoader = classLoader;
        try {
            this.type = classLoader.loadClass(beanInfo.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new InvalidConfigurationException("Could not load GBeanInfo class from classloader:  className=" + beanInfo.getClassName());
        }
        this.name = beanInfo.getName();
        Map constructorTypes = this.gbeanInfo.getConstructor().getAttributeTypeMap();
        Iterator iterator = beanInfo.getAttributes().iterator();
        while (iterator.hasNext()) {
            GAttributeInfo attributeInfo = (GAttributeInfo)iterator.next();
            this.addAttribute(new GBeanMBeanAttribute(this, attributeInfo, (Class)constructorTypes.get(attributeInfo.getName())));
        }
        iterator = beanInfo.getReferences().iterator();
        while (iterator.hasNext()) {
            GReferenceInfo referenceInfo = (GReferenceInfo)iterator.next();
            this.addReference(new GBeanMBeanReference(this, referenceInfo, (Class)constructorTypes.get(referenceInfo.getName())));
        }
        iterator = beanInfo.getOperations().iterator();
        while (iterator.hasNext()) {
            GOperationInfo operationInfo = (GOperationInfo)iterator.next();
            this.addOperation(new GBeanMBeanOperation(this, operationInfo));
        }
        this.addManagedObjectInterface();
        int idx = 0;
        MBeanAttributeInfo[] mbeanAttrs = new MBeanAttributeInfo[this.attributeMap.size()];
        Iterator i = this.attributeMap.values().iterator();
        while (i.hasNext()) {
            GBeanMBeanAttribute attr = (GBeanMBeanAttribute)i.next();
            mbeanAttrs[idx++] = attr.getMBeanAttributeInfo();
        }
        idx = 0;
        MBeanOperationInfo[] mbeanOps = new MBeanOperationInfo[this.operationMap.size()];
        Iterator i2 = this.operationMap.values().iterator();
        while (i2.hasNext()) {
            GBeanMBeanOperation op = (GBeanMBeanOperation)i2.next();
            mbeanOps[idx++] = op.getMbeanOperationInfo();
        }
        this.mbeanInfo = new MBeanInfo(beanInfo.getClassName(), null, mbeanAttrs, new MBeanConstructorInfo[0], mbeanOps, this.notifications.toArray(new MBeanNotificationInfo[this.notifications.size()]));
    }

    public GBeanMBean(GBeanInfo beanInfo) throws InvalidConfigurationException {
        this(beanInfo, GBeanMBean.getContextClassLoader());
    }

    public GBeanMBean(String className, ClassLoader classLoader) throws Exception {
        this(GBeanInfo.getGBeanInfo(className, classLoader), classLoader);
    }

    public GBeanMBean(String className) throws Exception {
        this(className, ClassLoader.getSystemClassLoader());
    }

    public String getName() {
        return this.name;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public Class getType() {
        return this.type;
    }

    public Object getTarget() {
        return this.target;
    }

    public synchronized ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        ObjectName returnValue = super.preRegister(server, objectName);
        GConstructorInfo constructorInfo = this.gbeanInfo.getConstructor();
        Class[] parameterTypes = constructorInfo.getTypes().toArray(new Class[constructorInfo.getTypes().size()]);
        Constructor constructor = this.type.getConstructor(parameterTypes);
        Object[] parameters = new Object[parameterTypes.length];
        Iterator names = constructorInfo.getAttributeNames().iterator();
        Iterator assertedTypes = constructorInfo.getTypes().iterator();
        for (int i = 0; i < parameters.length; ++i) {
            String name = (String)names.next();
            if (this.attributeMap.containsKey(name)) {
                parameters[i] = this.getAttribute(name);
            } else if (this.referenceMap.containsKey(name)) {
                GBeanMBeanReference reference = (GBeanMBeanReference)this.referenceMap.get(name);
                reference.online();
                parameters[i] = reference.getProxy();
            } else {
                throw new InvalidConfigurationException("Unknown attribute or reference name in constructor: name=" + name);
            }
            Class assertedType = (Class)assertedTypes.next();
            if (!($assertionsDisabled || parameters[i] == null || assertedType.isPrimitive() || assertedType.isAssignableFrom(parameters[i].getClass()))) {
                throw new AssertionError((Object)("Attempting to construct " + objectName + " of type " + this.gbeanInfo.getClassName() + ". Constructor parameter " + i + " should be " + assertedType.getName() + " but is " + parameters[i].getClass().getName()));
            }
        }
        try {
            this.target = constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw e;
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)("Constructor mismatch for " + returnValue), (Throwable)e);
            throw e;
        }
        Iterator iterator = this.attributeMap.values().iterator();
        while (iterator.hasNext()) {
            GBeanMBeanAttribute attribute = (GBeanMBeanAttribute)iterator.next();
            attribute.online();
        }
        iterator = this.referenceMap.values().iterator();
        while (iterator.hasNext()) {
            GBeanMBeanReference reference = (GBeanMBeanReference)iterator.next();
            if (constructorInfo.getAttributeNames().contains(reference.getName())) continue;
            reference.online();
        }
        return returnValue;
    }

    public void postRegister(Boolean registrationDone) {
        super.postRegister(registrationDone);
        if (registrationDone.booleanValue()) {
            if (this.target instanceof GBean) {
                GBean gbean = (GBean)this.target;
                gbean.setGBeanContext(new GBeanMBeanContext(this.server, this, this.objectName));
            }
            this.offline = false;
        } else {
            Iterator iterator = this.referenceMap.values().iterator();
            while (iterator.hasNext()) {
                GBeanMBeanReference reference = (GBeanMBeanReference)iterator.next();
                reference.offline();
            }
            this.target = null;
        }
    }

    public void postDeregister() {
        Iterator iterator = this.attributeMap.values().iterator();
        while (iterator.hasNext()) {
            GBeanMBeanAttribute attribute = (GBeanMBeanAttribute)iterator.next();
            attribute.offline();
        }
        iterator = this.referenceMap.values().iterator();
        while (iterator.hasNext()) {
            GBeanMBeanReference reference = (GBeanMBeanReference)iterator.next();
            reference.offline();
        }
        if (this.target instanceof GBean) {
            GBean gbean = (GBean)this.target;
            gbean.setGBeanContext(null);
        }
        this.offline = true;
        this.target = null;
        super.postDeregister();
    }

    public GBeanInfo getGBeanInfo() {
        return this.gbeanInfo;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        Iterator iterator = this.referenceMap.values().iterator();
        while (iterator.hasNext()) {
            GBeanMBeanReference reference = (GBeanMBeanReference)iterator.next();
            reference.start();
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            if (this.target instanceof GBean) {
                ((GBean)this.target).doStart();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            if (this.target instanceof GBean) {
                ((GBean)this.target).doStop();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        Iterator iterator = this.referenceMap.values().iterator();
        while (iterator.hasNext()) {
            GBeanMBeanReference reference = (GBeanMBeanReference)iterator.next();
            reference.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFail() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            if (this.target instanceof GBean) {
                ((GBean)this.target).doFail();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        Iterator iterator = this.referenceMap.values().iterator();
        while (iterator.hasNext()) {
            GBeanMBeanReference reference = (GBeanMBeanReference)iterator.next();
            reference.stop();
        }
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        GBeanMBeanAttribute attribute = (GBeanMBeanAttribute)this.attributeMap.get(attributeName);
        if (attribute == null) {
            throw new AttributeNotFoundException("Unknown attribute " + attributeName);
        }
        return attribute.getValue();
    }

    public void setAttribute(Attribute attributeValue) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        GBeanMBeanAttribute attribute = (GBeanMBeanAttribute)this.attributeMap.get(attributeValue.getName());
        if (attribute == null) {
            throw new AttributeNotFoundException("Unknown attribute " + attributeValue.getName());
        }
        attribute.setValue(attributeValue.getValue());
    }

    public void setAttribute(String name, Object value) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        GBeanMBeanAttribute attribute = (GBeanMBeanAttribute)this.attributeMap.get(name);
        if (attribute == null) {
            throw new AttributeNotFoundException("Unknown attribute " + name);
        }
        attribute.setValue(value);
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList results = new AttributeList(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            try {
                Object value = this.getAttribute(name);
                results.add(new Attribute(name, value));
                continue;
            }
            catch (JMException e) {
                log.warn((Object)("Exception while getting attribute " + name), (Throwable)e);
            }
        }
        return results;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList results = new AttributeList(attributes.size());
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            try {
                this.setAttribute(attribute);
                results.add(attribute);
            }
            catch (JMException e) {
                log.warn((Object)("Exception while setting attribute " + attribute.getName()), (Throwable)e);
            }
        }
        return results;
    }

    public Object invoke(String methodName, Object[] arguments, String[] types) throws MBeanException, ReflectionException {
        MBeanOperationSignature key = new MBeanOperationSignature(methodName, types);
        Object operation = this.operationMap.get(key);
        if (operation == null) {
            throw new ReflectionException(new NoSuchMethodException("Unknown operation " + key));
        }
        if (operation instanceof GBeanMBeanAttribute) {
            if (arguments == null || arguments.length == 0) {
                return ((GBeanMBeanAttribute)operation).getValue();
            }
            ((GBeanMBeanAttribute)operation).setValue(arguments[0]);
            return null;
        }
        return ((GBeanMBeanOperation)operation).invoke(arguments);
    }

    public Set getReferencePatterns(String name) {
        GBeanMBeanReference reference = (GBeanMBeanReference)this.referenceMap.get(name);
        if (reference == null) {
            throw new IllegalArgumentException("Unknown reference " + name);
        }
        return reference.getPatterns();
    }

    public void setReferencePatterns(String name, Set patterns) {
        GBeanMBeanReference reference = (GBeanMBeanReference)this.referenceMap.get(name);
        if (reference == null) {
            throw new IllegalArgumentException("Unknown reference " + name);
        }
        reference.setPatterns(patterns);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.mbeanInfo.getNotifications();
    }

    private void addAttribute(GBeanMBeanAttribute mbeanAttribute) {
        String attributeName = mbeanAttribute.getName();
        this.attributeMap.put(attributeName, mbeanAttribute);
    }

    private void addReference(GBeanMBeanReference mbeanReference) {
        String referenceName = mbeanReference.getName();
        this.referenceMap.put(referenceName, mbeanReference);
    }

    private void addOperation(GBeanMBeanOperation mbeanOperation) {
        MBeanOperationSignature signature = new MBeanOperationSignature(mbeanOperation.getName(), mbeanOperation.getParameterTypes());
        this.operationMap.put(signature, mbeanOperation);
    }

    private void addManagedObjectInterface() {
        this.addAttribute(new GBeanMBeanAttribute(this, "state", Integer.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Integer(GBeanMBean.this.getState());
            }
        }, null));
        this.addAttribute(new GBeanMBeanAttribute(this, "objectName", String.class, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return GBeanMBean.this.getObjectName();
            }
        }, null));
        this.addAttribute(new GBeanMBeanAttribute(this, "startTime", Long.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Long(GBeanMBean.this.getStartTime());
            }
        }, null));
        this.addAttribute(new GBeanMBeanAttribute(this, "stateManageable", Boolean.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Boolean(GBeanMBean.this.isStateManageable());
            }
        }, null));
        this.addAttribute(new GBeanMBeanAttribute(this, "statisticsProvider", Boolean.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Boolean(GBeanMBean.this.isStatisticsProvider());
            }
        }, null));
        this.addAttribute(new GBeanMBeanAttribute(this, "eventProvider", Boolean.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                return new Boolean(GBeanMBean.this.isEventProvider());
            }
        }, null));
        this.addOperation(new GBeanMBeanOperation(this, "start", Collections.EMPTY_LIST, Void.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                GBeanMBean.this.start();
                return null;
            }
        }));
        this.addOperation(new GBeanMBeanOperation(this, "startRecursive", Collections.EMPTY_LIST, Void.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                GBeanMBean.this.startRecursive();
                return null;
            }
        }));
        this.addOperation(new GBeanMBeanOperation(this, "stop", Collections.EMPTY_LIST, Void.TYPE, new MethodInvoker(){

            public Object invoke(Object target, Object[] arguments) throws Exception {
                GBeanMBean.this.stop();
                return null;
            }
        }));
        this.notifications.add(new MBeanNotificationInfo(NotificationType.TYPES, "javax.management.Notification", "J2EE Notifications"));
    }

    static {
        $assertionsDisabled = !GBeanMBean.class.desiredAssertionStatus();
        fastClass = FastClass.create((Class)GBeanMBean.class);
        log = LogFactory.getLog((Class)GBeanMBean.class);
    }
}

